/* (c) 2014 Open Source Geospatial Foundation - all rights reserved
 * (c) 2001 - 2013 OpenPlans
 * This code is licensed under the GPL 2.0 license, available at the root
 * application directory.
 */

package org.geoserver.security.xml;

import org.geoserver.security.config.SecurityRoleServiceConfig;

public class XMLRoleServiceConfig extends XMLSecurityServiceConfig implements SecurityRoleServiceConfig {

    private static final long serialVersionUID = 1L;

    protected String adminRoleName;
    protected String groupAdminRoleName;

    public XMLRoleServiceConfig() {}

    public XMLRoleServiceConfig(XMLRoleServiceConfig other) {
        super(other);
        adminRoleName = other.getAdminRoleName();
        groupAdminRoleName = other.getGroupAdminRoleName();
    }

    @Override
    public String getGroupAdminRoleName() {
        return groupAdminRoleName;
    }

    @Override
    public void setGroupAdminRoleName(String groupAdminRoleName) {
        this.groupAdminRoleName = groupAdminRoleName;
    }

    @Override
    public String getAdminRoleName() {
        return adminRoleName;
    }

    @Override
    public void setAdminRoleName(String name) {
        adminRoleName = name;
    }
}
