/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geotools.util.logging.Logging;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public final class Requests {
    static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver");
    public static final String PROXY_PARAM = "PROXY_BASE_URL";

    public static String appendContextPath(String url, String contextPath) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (contextPath == null) {
            return url;
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return url + "/" + contextPath;
    }

    public static String appendQueryString(String url, String queryString) {
        if (url.endsWith("?") || url.endsWith("&")) {
            return url + queryString;
        }
        if (url.indexOf(63) != -1) {
            return url + "&" + queryString;
        }
        return url + "?" + queryString;
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
    }

    public static InputStream getInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        conn.connect();
        if (conn instanceof HttpURLConnection) {
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                encoding = "";
            }
            if (encoding.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(conn.getInputStream());
            }
            if (encoding.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(conn.getInputStream(), new Inflater(true));
            }
            return conn.getInputStream();
        }
        return conn.getInputStream();
    }

    public static Map parseOptionParameter(String rawOptionString) throws IllegalArgumentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (rawOptionString == null) {
            return map;
        }
        StringTokenizer semiColonSplitter = new StringTokenizer(rawOptionString, ";");
        while (semiColonSplitter.hasMoreElements()) {
            String curKVP = semiColonSplitter.nextToken();
            int cloc = curKVP.indexOf(":");
            if (cloc <= 0) {
                throw new IllegalArgumentException("Key-value-pair: '" + curKVP + "' isn't properly formed.  It must be of the form 'Key:Value1,Value2...'");
            }
            String key = curKVP.substring(0, cloc);
            String values = curKVP.substring(cloc + 1, curKVP.length());
            if (values.indexOf(",") != -1) {
                ArrayList<String> valueList = new ArrayList<String>();
                StringTokenizer commaSplitter = new StringTokenizer(values, ",");
                while (commaSplitter.hasMoreElements()) {
                    valueList.add(commaSplitter.nextToken());
                }
                map.put(key, valueList);
                continue;
            }
            map.put(key, values);
        }
        return map;
    }
}

