/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;

public class NearestMatchWarningAppender
extends AbstractDispatcherCallback {
    static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    static final ThreadLocal<List<String>> WARNINGS = ThreadLocal.withInitial(() -> new ArrayList());

    public static void addWarning(String layerName, String dimension, Object value, String unit, WarningType warningType) {
        List<String> warnings = WARNINGS.get();
        if (warningType == WarningType.NotFound) {
            warnings.add("99 No nearest value found on " + layerName + ": " + dimension);
        } else {
            String type = warningType == WarningType.Nearest ? "Nearest value" : "Default value";
            String unitSpec = unit == null ? "" : unit;
            String valueSpec = NearestMatchWarningAppender.formatValue(value);
            warnings.add("99 " + type + " used: " + dimension + "=" + valueSpec + " " + unitSpec + " (" + layerName + ")");
        }
    }

    private static String formatValue(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            sdf.setTimeZone(UTC_TZ);
            return sdf.format(value);
        }
        if (value == null) {
            return "-";
        }
        return value.toString();
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        List<String> warnings = WARNINGS.get();
        if (warnings != null && !warnings.isEmpty()) {
            HttpServletResponse httpResponse = request.getHttpResponse();
            for (String warning : warnings) {
                httpResponse.addHeader("Warning", warning);
            }
            return super.responseDispatched(request, operation, result, response);
        }
        return response;
    }

    public void finished(Request request) {
        WARNINGS.remove();
    }

    public static enum WarningType {
        Nearest,
        Default,
        NotFound;

    }
}

