/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.SortedSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.file.LockFile;
import org.geoserver.security.impl.AbstractRoleStore;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.xml.XMLRoleService;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLRoleStore
extends AbstractRoleStore {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    protected Resource roleResource;
    protected LockFile lockFile = null;
    private boolean validatingXMLSchema = true;

    public boolean isValidatingXMLSchema() {
        return this.validatingXMLSchema;
    }

    public void setValidatingXMLSchema(boolean validatingXMLSchema) {
        this.validatingXMLSchema = validatingXMLSchema;
    }

    @Override
    public void initializeFromService(GeoServerRoleService service) throws IOException {
        this.roleResource = ((XMLRoleService)service).roleResource;
        this.validatingXMLSchema = ((XMLRoleService)service).isValidatingXMLSchema();
        super.initializeFromService(service);
    }

    @Override
    protected void serialize() throws IOException {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1);
        }
        Document doc = builder.newDocument();
        Element rolereg = doc.createElement("roleRegistry");
        doc.appendChild(rolereg);
        rolereg.setAttribute("xmlns", "http://www.geoserver.org/security/roles");
        rolereg.setAttribute("version", "1.0");
        Element rolelist = doc.createElement("roleList");
        rolereg.appendChild(rolelist);
        for (GeoServerRole geoServerRole : this.helper.roleMap.values()) {
            Element element = doc.createElement("role");
            rolelist.appendChild(element);
            element.setAttribute("id", geoServerRole.getAuthority());
            GeoServerRole parentObject = this.helper.role_parentMap.get(geoServerRole);
            if (parentObject != null) {
                element.setAttribute("parentID", parentObject.getAuthority());
            }
            for (Object object : geoServerRole.getProperties().keySet()) {
                Element property = doc.createElement("property");
                element.appendChild(property);
                property.setAttribute("name", object.toString());
                property.setTextContent(geoServerRole.getProperties().getProperty(object.toString()));
            }
        }
        Element userList = doc.createElement("userList");
        rolereg.appendChild(userList);
        for (String string : this.helper.user_roleMap.keySet()) {
            Element userroles = doc.createElement("userRoles");
            userList.appendChild(userroles);
            userroles.setAttribute("username", string);
            SortedSet<GeoServerRole> roleObjects = this.helper.user_roleMap.get(string);
            for (GeoServerRole roleObject : roleObjects) {
                Element ref = doc.createElement("roleRef");
                userroles.appendChild(ref);
                ref.setAttribute("roleID", roleObject.getAuthority());
            }
        }
        Element element = doc.createElement("groupList");
        rolereg.appendChild(element);
        for (String groupName : this.helper.group_roleMap.keySet()) {
            Element grouproles = doc.createElement("groupRoles");
            element.appendChild(grouproles);
            grouproles.setAttribute("groupname", groupName);
            SortedSet<GeoServerRole> sortedSet = this.helper.group_roleMap.get(groupName);
            for (GeoServerRole roleObject : sortedSet) {
                Element ref = doc.createElement("roleRef");
                grouproles.appendChild(ref);
                ref.setAttribute("roleID", roleObject.getAuthority());
            }
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "XML");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try (BufferedOutputStream out = new BufferedOutputStream(this.roleResource.out());){
                transformer.transform(new DOMSource(doc), new StreamResult(out));
                ((OutputStream)out).flush();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    protected void deserialize() throws IOException {
        super.deserialize();
        this.releaseLock();
    }

    public String toString() {
        return this.getName();
    }

    protected void ensureLock() throws IOException {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = new LockFile(this.roleResource);
        try {
            this.lockFile.writeLock();
        }
        catch (IOException ex) {
            this.lockFile = null;
            throw ex;
        }
    }

    protected void releaseLock() {
        if (this.lockFile == null) {
            return;
        }
        this.lockFile.writeUnLock();
        this.lockFile = null;
    }

    @Override
    public void addRole(GeoServerRole role) throws IOException {
        this.ensureLock();
        super.addRole(role);
    }

    @Override
    public void updateRole(GeoServerRole role) throws IOException {
        this.ensureLock();
        super.updateRole(role);
    }

    @Override
    public boolean removeRole(GeoServerRole role) throws IOException {
        this.ensureLock();
        return super.removeRole(role);
    }

    @Override
    public void store() throws IOException {
        this.ensureLock();
        super.store();
        this.releaseLock();
    }

    @Override
    public void disAssociateRoleFromGroup(GeoServerRole role, String groupname) throws IOException {
        this.ensureLock();
        super.disAssociateRoleFromGroup(role, groupname);
    }

    @Override
    public void associateRoleToGroup(GeoServerRole role, String groupname) throws IOException {
        this.ensureLock();
        super.associateRoleToGroup(role, groupname);
    }

    @Override
    public void associateRoleToUser(GeoServerRole role, String username) throws IOException {
        this.ensureLock();
        super.associateRoleToUser(role, username);
    }

    @Override
    public void disAssociateRoleFromUser(GeoServerRole role, String username) throws IOException {
        this.ensureLock();
        super.disAssociateRoleFromUser(role, username);
    }

    @Override
    public void setParentRole(GeoServerRole role, GeoServerRole parentRole) throws IOException {
        this.ensureLock();
        super.setParentRole(role, parentRole);
    }

    @Override
    public void clear() throws IOException {
        this.ensureLock();
        super.clear();
    }
}

