/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rememberme;

import java.util.HashSet;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.filter.GeoServerWebAuthenticationDetails;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.rememberme.RememberMeUserDetailsService;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;

public class GeoServerTokenBasedRememberMeServices
extends TokenBasedRememberMeServices {
    public GeoServerTokenBasedRememberMeServices(String key, UserDetailsService userDetailsService) {
        super(key, userDetailsService);
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password) {
        Matcher m = RememberMeUserDetailsService.TOKEN_PATTERN.matcher(username);
        String uName = !m.matches() ? username : m.group(1).replace("\\@", "@");
        return super.makeTokenSignature(tokenExpiryTime, uName, password);
    }

    protected String retrieveUserName(Authentication authentication) {
        if (authentication.getDetails() instanceof GeoServerWebAuthenticationDetails) {
            String userGroupServiceName = ((GeoServerWebAuthenticationDetails)((Object)authentication.getDetails())).getUserGroupServiceName();
            if (userGroupServiceName == null || userGroupServiceName.trim().length() == 0) {
                return "";
            }
            return this.encode(super.retrieveUserName(authentication), userGroupServiceName);
        }
        return "";
    }

    String encode(String username, String userGroupServiceName) {
        if (userGroupServiceName == null) {
            return username;
        }
        if (username.endsWith("@" + userGroupServiceName)) {
            return username;
        }
        return username.replace("@", "\\@") + "@" + userGroupServiceName;
    }

    protected Authentication createSuccessfulAuthentication(HttpServletRequest request, UserDetails user) {
        if (user instanceof RememberMeUserDetailsService.RememberMeUserDetails) {
            user = ((RememberMeUserDetailsService.RememberMeUserDetails)user).getWrappedObject();
        }
        HashSet<GeoServerRole> roles = new HashSet<GeoServerRole>();
        if (user.getAuthorities().contains(GeoServerRole.AUTHENTICATED_ROLE)) {
            roles.addAll(user.getAuthorities());
        } else {
            roles = new HashSet();
            roles.addAll(user.getAuthorities());
            roles.add(GeoServerRole.AUTHENTICATED_ROLE);
        }
        RememberMeAuthenticationToken auth = new RememberMeAuthenticationToken(this.getKey(), (Object)user, roles);
        auth.setDetails(this.getAuthenticationDetailsSource().buildDetails((Object)request));
        return auth;
    }
}

