/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.MasterPasswordProvider;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.password.URLMasterPasswordProviderConfig;
import org.geoserver.security.password.URLMasterPasswordProviderException;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidator;
import org.geotools.util.URLs;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;

public final class URLMasterPasswordProvider
extends MasterPasswordProvider {
    static final char[] BASE = new char[]{'U', 'n', '6', 'd', 'I', 'l', 'X', 'T', 'Q', 'c', 'L', ')', '$', '#', 'q', 'J', 'U', 'l', 'X', 'Q', 'U', '!', 'n', 'n', 'p', '%', 'U', 'r', '5', 'U', 'u', '3', '5', 'H', '`', 'x', 'P', 'F', 'r', 'X'};
    static final int[] PERM = new int[]{32, 19, 30, 11, 34, 26, 3, 21, 9, 37, 38, 13, 23, 2, 18, 4, 20, 1, 29, 17, 0, 31, 14, 36, 12, 24, 15, 35, 16, 39, 25, 5, 10, 8, 7, 6, 33, 27, 28, 22};
    URLMasterPasswordProviderConfig config;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.config = (URLMasterPasswordProviderConfig)config;
    }

    @Override
    protected char[] doGetMasterPassword() throws Exception {
        char[] cArray;
        InputStream in = URLMasterPasswordProvider.input(this.config.getURL(), this.getConfigDir());
        try {
            cArray = SecurityUtils.toChars(this.decode(IOUtils.toByteArray((InputStream)in)));
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return cArray;
    }

    @Override
    protected void doSetMasterPassword(char[] passwd) throws Exception {
        try (OutputStream out = URLMasterPasswordProvider.output(this.config.getURL(), this.getConfigDir());){
            out.write(this.encode(passwd));
        }
    }

    Resource getConfigDir() throws IOException {
        return this.getSecurityManager().masterPasswordProvider().get(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] encode(char[] passwd) {
        if (!this.config.isEncrypting()) {
            return SecurityUtils.toBytes(passwd);
        }
        StandardPBEByteEncryptor encryptor = new StandardPBEByteEncryptor();
        char[] key = this.key();
        try {
            encryptor.setPasswordCharArray(key);
            byte[] byArray = Base64.encodeBase64((byte[])encryptor.encrypt(SecurityUtils.toBytes(passwd)));
            return byArray;
        }
        finally {
            SecurityUtils.scramble(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] decode(byte[] passwd) {
        if (!this.config.isEncrypting()) {
            return passwd;
        }
        StandardPBEByteEncryptor encryptor = new StandardPBEByteEncryptor();
        char[] key = this.key();
        try {
            encryptor.setPasswordCharArray(key);
            byte[] byArray = encryptor.decrypt(Base64.decodeBase64((byte[])passwd));
            return byArray;
        }
        finally {
            SecurityUtils.scramble(key);
        }
    }

    char[] key() {
        return SecurityUtils.permute(BASE, 32, PERM);
    }

    static OutputStream output(URL url, Resource configDir) throws IOException {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File f = URLs.urlToFile((URL)url);
            if (!f.isAbsolute()) {
                return configDir.get(f.getPath()).out();
            }
            return new FileOutputStream(f);
        }
        URLConnection cx = url.openConnection();
        cx.setDoOutput(true);
        return cx.getOutputStream();
    }

    static InputStream input(URL url, Resource configDir) throws IOException {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File f = URLs.urlToFile((URL)url);
            if (!f.isAbsolute()) {
                Resource res = configDir.get(f.getPath());
                if (res.getType() != Resource.Type.RESOURCE) {
                    throw new FileNotFoundException();
                }
                return res.in();
            }
            return new FileInputStream(f);
        }
        return url.openStream();
    }

    public static class SecurityProvider
    extends GeoServerSecurityProvider {
        @Override
        public void configure(XStreamPersister xp) {
            super.configure(xp);
            xp.getXStream().alias("urlProvider", URLMasterPasswordProviderConfig.class);
        }

        @Override
        public Class<? extends MasterPasswordProvider> getMasterPasswordProviderClass() {
            return URLMasterPasswordProvider.class;
        }

        @Override
        public MasterPasswordProvider createMasterPasswordProvider(MasterPasswordProviderConfig config) throws IOException {
            return new URLMasterPasswordProvider();
        }

        @Override
        public SecurityConfigValidator createConfigurationValidator(GeoServerSecurityManager securityManager) {
            return new URLMasterPasswordProviderValidator(securityManager);
        }
    }

    public static class URLMasterPasswordProviderValidator
    extends SecurityConfigValidator {
        public URLMasterPasswordProviderValidator(GeoServerSecurityManager securityManager) {
            super(securityManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(MasterPasswordProviderConfig config) throws SecurityConfigException {
            super.validate(config);
            URLMasterPasswordProviderConfig urlConfig = (URLMasterPasswordProviderConfig)config;
            URL url = urlConfig.getURL();
            if (url == null) {
                throw new URLMasterPasswordProviderException("URL_REQUIRED", new Object[0]);
            }
            if (config.isReadOnly()) {
                try (InputStream in = URLMasterPasswordProvider.input(url, this.manager.masterPasswordProvider().get(config.getName()));){
                    in.read();
                }
                catch (IOException ex) {
                    throw new URLMasterPasswordProviderException("URL_LOCATION_NOT_READABLE", url);
                }
            }
        }
    }
}

