/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.PropertyFileWatcher;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;
import org.vfny.geoserver.global.ConfigurationException;

public class EditableUserDAO
implements UserDetailsService {
    private Map<String, UserDetails> myDetailStorage = new HashMap<String, UserDetails>();
    private PropertyFileWatcher myWatcher;
    private GeoServer geoServer;

    private Resource getUserFile() throws ConfigurationException, IOException {
        GeoServerResourceLoader loader = this.geoServer.getCatalog().getResourceLoader();
        return loader.get("security/users.properties");
    }

    public EditableUserDAO() {
        try {
            this.myWatcher = new PropertyFileWatcher(this.getUserFile());
        }
        catch (Exception e) {
            this.createDefaultUser();
        }
        this.update();
        if (this.myDetailStorage.isEmpty()) {
            this.createDefaultUser();
        }
    }

    private void createDefaultUser() {
        String name = this.geoServer == null ? "admin" : this.geoServer.getGlobal().getAdminUsername();
        String passwd = this.geoServer == null ? "geoserver" : this.geoServer.getGlobal().getAdminPassword();
        ArrayList<SimpleGrantedAuthority> auths = new ArrayList<SimpleGrantedAuthority>();
        auths.add(new SimpleGrantedAuthority("ROLE_ADMINISTRATOR"));
        this.myDetailStorage.put(name, (UserDetails)new User(name, passwd, true, true, true, true, auths));
    }

    public UserDetails loadUserByUsername(String username) {
        this.update();
        return this.myDetailStorage.get(username);
    }

    public void setUserDetails(String username, UserAttribute details) throws IOException, ConfigurationException {
        this.update();
        this.myDetailStorage.put(username, this.makeUser(username, details));
        this.syncChanges();
    }

    public void deleteUser(String username) throws IOException, ConfigurationException {
        this.update();
        this.myDetailStorage.remove(username);
        this.syncChanges();
    }

    private void update() {
        try {
            if (this.myWatcher != null && this.myWatcher.isStale()) {
                Properties prop = this.myWatcher.getProperties();
                UserAttributeEditor uae = new UserAttributeEditor();
                this.myDetailStorage.clear();
                for (String string : prop.keySet()) {
                    uae.setAsText(prop.getProperty(string));
                    UserAttribute attrs = (UserAttribute)uae.getValue();
                    if (attrs == null) continue;
                    this.myDetailStorage.put(string, this.makeUser(string, attrs));
                }
            }
        }
        catch (IOException ioe) {
            this.myDetailStorage.clear();
            this.createDefaultUser();
        }
    }

    private UserDetails makeUser(String username, UserAttribute attrs) {
        return new User(username, attrs.getPassword(), attrs.isEnabled(), true, true, true, (Collection)attrs.getAuthorities());
    }

    private void syncChanges() throws IOException, ConfigurationException {
        Properties prop = new Properties();
        for (UserDetails details : this.myDetailStorage.values()) {
            String key = details.getUsername();
            String value = details.getPassword();
            for (GrantedAuthority auth : details.getAuthorities()) {
                value = value + "," + auth.getAuthority();
            }
            if (!details.isEnabled()) {
                value = value + ",disabled";
            }
            prop.setProperty(key, value);
        }
        try (BufferedOutputStream os = new BufferedOutputStream(this.getUserFile().out());){
            prop.store(os, "Geoserver user data. Format is username=password,role1,role2,...[enabled|disabled]");
        }
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public Set<String> getNameSet() {
        return this.myDetailStorage.keySet();
    }
}

