/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationFilterConfig;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.geoserver.security.filter.GeoServerWebAuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;

public class GeoServerUserNamePasswordAuthenticationFilter
extends GeoServerCompositeFilter
implements GeoServerAuthenticationFilter {
    public static final String URL_LOGIN_SUCCCESS = "/web";
    public static final String URL_LOGIN_FAILURE = "/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=true";
    public static final String URL_LOGIN_FORM = "/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=false";
    private LoginUrlAuthenticationEntryPoint aep;
    String[] pathInfos;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.pathInfos = "/j_spring_security_check,/j_spring_security_check/,/login".split(",");
        UsernamePasswordAuthenticationFilterConfig upConfig = (UsernamePasswordAuthenticationFilterConfig)config;
        this.aep = new LoginUrlAuthenticationEntryPoint(URL_LOGIN_FORM);
        this.aep.setForceHttps(false);
        try {
            this.aep.afterPropertiesSet();
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
        RememberMeServices rms = this.securityManager.getRememberMeService();
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter(){

            protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
                for (String pathInfo : GeoServerUserNamePasswordAuthenticationFilter.this.pathInfos) {
                    if (!GeoServerUserNamePasswordAuthenticationFilter.this.getRequestPath(request).startsWith(pathInfo)) continue;
                    return true;
                }
                return false;
            }
        };
        filter.setPasswordParameter(upConfig.getPasswordParameterName());
        filter.setUsernameParameter(upConfig.getUsernameParameterName());
        filter.setAuthenticationManager(this.getSecurityManager().authenticationManager());
        filter.setRememberMeServices(rms);
        GeoServerWebAuthenticationDetailsSource s = new GeoServerWebAuthenticationDetailsSource();
        filter.setAuthenticationDetailsSource((AuthenticationDetailsSource)s);
        try {
            filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
        }
        catch (IllegalStateException e) {
            filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new SessionFixationProtectionStrategy());
        }
        filter.setAllowSessionCreation(false);
        SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler();
        successHandler.setDefaultTargetUrl(URL_LOGIN_SUCCCESS);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)successHandler);
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setDefaultFailureUrl(URL_LOGIN_FAILURE);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)failureHandler);
        this.getNestedFilters().add((Filter)filter);
    }

    @Override
    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.aep;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        req.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.aep);
        super.doFilter(req, res, chain);
    }

    @Override
    public boolean applicableForHtml() {
        return true;
    }

    @Override
    public boolean applicableForServices() {
        return false;
    }
}

