/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingDataAccess;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureSource;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class ReadOnlyDataAccess<T extends FeatureType, F extends Feature>
extends DecoratingDataAccess<T, F> {
    static final String READ_ONLY = "This data access is read only";
    private WrapperPolicy policy;

    ReadOnlyDataAccess(DataAccess<T, F> delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public FeatureSource<T, F> getFeatureSource(Name typeName) throws IOException {
        FeatureSource fs = super.getFeatureSource(typeName);
        if (fs == null) {
            return null;
        }
        return (FeatureSource)SecuredObjects.secure(fs, this.policy);
    }

    @Override
    public void createSchema(T featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public void updateSchema(Name typeName, T featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    RuntimeException notifyUnsupportedOperation() {
        if (this.policy.response == Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess();
        }
        return new UnsupportedOperationException("This data access is read only, service code is supposed to perform writes via FeatureStore instead");
    }
}

