/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredCoverageStoreInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.security.decorators.SecuredObjectFactory;
import org.geoserver.security.decorators.SecuredWMSLayerInfo;
import org.geoserver.security.decorators.SecuredWMTSLayerInfo;
import org.geotools.util.logging.Logging;

public class DefaultSecureCatalogFactory
implements SecuredObjectFactory {
    private static final Logger LOGGER = Logging.getLogger(DefaultSecureCatalogFactory.class);

    @Override
    public boolean canSecure(Class clazz) {
        return CoverageInfo.class.isAssignableFrom(clazz) || CoverageStoreInfo.class.isAssignableFrom(clazz) || DataStoreInfo.class.isAssignableFrom(clazz) || FeatureTypeInfo.class.isAssignableFrom(clazz) || LayerInfo.class.isAssignableFrom(clazz) || WMSLayerInfo.class.isAssignableFrom(clazz) || WMTSLayerInfo.class.isAssignableFrom(clazz);
    }

    @Override
    public Object secure(Object object, WrapperPolicy policy) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (CoverageInfo.class.isAssignableFrom(clazz)) {
            return new SecuredCoverageInfo(this.logIfSecured((CoverageInfo)object), policy);
        }
        if (CoverageStoreInfo.class.isAssignableFrom(clazz)) {
            return new SecuredCoverageStoreInfo(this.logIfSecured((CoverageStoreInfo)object), policy);
        }
        if (DataStoreInfo.class.isAssignableFrom(clazz)) {
            return new SecuredDataStoreInfo(this.logIfSecured((DataStoreInfo)object), policy);
        }
        if (FeatureTypeInfo.class.isAssignableFrom(clazz)) {
            return new SecuredFeatureTypeInfo(this.logIfSecured((FeatureTypeInfo)object), policy);
        }
        if (LayerInfo.class.isAssignableFrom(clazz)) {
            return new SecuredLayerInfo(this.logIfSecured((LayerInfo)object), policy);
        }
        if (WMSLayerInfo.class.isAssignableFrom(clazz)) {
            return new SecuredWMSLayerInfo(this.logIfSecured((WMSLayerInfo)object), policy);
        }
        if (WMTSLayerInfo.class.isAssignableFrom(clazz)) {
            return new SecuredWMTSLayerInfo(this.logIfSecured((WMTSLayerInfo)object), policy);
        }
        throw new IllegalArgumentException("Don't know how to wrap " + object);
    }

    public int getPriority() {
        return 100;
    }

    private void logDoubleWrap(Object unwrapped, Object orig) {
        String msg = String.format("Tried to double secure: %s already securing %s", orig, unwrapped);
        LOGGER.warning(msg);
    }

    private WMTSLayerInfo logIfSecured(WMTSLayerInfo object) {
        WMTSLayerInfo unwrapped = ModificationProxy.unwrap(object);
        if (unwrapped instanceof SecuredWMTSLayerInfo) {
            this.logDoubleWrap(unwrapped, object);
        }
        return object;
    }

    private WMSLayerInfo logIfSecured(WMSLayerInfo object) {
        WMSLayerInfo unwrapped = ModificationProxy.unwrap(object);
        if (unwrapped instanceof SecuredWMSLayerInfo) {
            this.logDoubleWrap(unwrapped, object);
        }
        return object;
    }

    private LayerInfo logIfSecured(LayerInfo object) {
        LayerInfo unwrapped = ModificationProxy.unwrap(object);
        if (unwrapped instanceof SecuredLayerInfo) {
            this.logDoubleWrap(unwrapped, object);
        }
        return object;
    }

    private FeatureTypeInfo logIfSecured(FeatureTypeInfo object) {
        FeatureTypeInfo unwrapped = ModificationProxy.unwrap(object);
        if (unwrapped instanceof SecuredFeatureTypeInfo) {
            this.logDoubleWrap(unwrapped, object);
        }
        return object;
    }

    private CoverageStoreInfo logIfSecured(CoverageStoreInfo object) {
        CoverageStoreInfo unwrapped = ModificationProxy.unwrap(object);
        if (unwrapped instanceof SecuredCoverageStoreInfo) {
            this.logDoubleWrap(unwrapped, object);
        }
        return object;
    }

    private CoverageInfo logIfSecured(CoverageInfo object) {
        CoverageInfo unwrapped = ModificationProxy.unwrap(object);
        if (unwrapped instanceof SecuredDataStoreInfo) {
            this.logDoubleWrap(unwrapped, object);
        }
        return object;
    }

    private DataStoreInfo logIfSecured(DataStoreInfo object) {
        DataStoreInfo unwrapped = ModificationProxy.unwrap(object);
        if (unwrapped instanceof SecuredDataStoreInfo) {
            this.logDoubleWrap(unwrapped, object);
        }
        return object;
    }
}

