/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.List;
import javax.annotation.Nullable;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.opengis.filter.Filter;
import org.springframework.security.core.Authentication;

public interface ResourceAccessManager {
    public WorkspaceAccessLimits getAccessLimits(Authentication var1, WorkspaceInfo var2);

    public DataAccessLimits getAccessLimits(Authentication var1, LayerInfo var2);

    default public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer, List<LayerGroupInfo> containers) {
        return this.getAccessLimits(user, layer);
    }

    public DataAccessLimits getAccessLimits(Authentication var1, ResourceInfo var2);

    public StyleAccessLimits getAccessLimits(Authentication var1, StyleInfo var2);

    public LayerGroupAccessLimits getAccessLimits(Authentication var1, LayerGroupInfo var2);

    default public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup, List<LayerGroupInfo> containers) {
        return this.getAccessLimits(user, layerGroup);
    }

    @Nullable
    public Filter getSecurityFilter(Authentication var1, Class<? extends CatalogInfo> var2);
}

