/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.geoserver.ows.FlatKvpParser;
import org.geoserver.ows.KvpParser;
import org.geoserver.platform.ServiceException;
import org.xml.sax.helpers.NamespaceSupport;

public class NamespaceKvpParser
extends KvpParser {
    private final boolean useComma;

    public NamespaceKvpParser(String key) {
        this(key, false);
    }

    public NamespaceKvpParser(String key, boolean useComma) {
        super(key, NamespaceSupport.class);
        this.useComma = useComma;
    }

    public NamespaceSupport parse(String value) throws Exception {
        List declarations;
        if (this.useComma) {
            String[] parts = value.split(",(?![^()]*+\\))");
            declarations = Arrays.asList(parts);
        } else {
            declarations = (List)new FlatKvpParser("", String.class).parse(value);
        }
        NamespaceSupport ctx = new NamespaceSupport();
        for (String decl : declarations) {
            String uri;
            String prefix;
            String separator;
            if (!(decl = decl.trim()).startsWith("xmlns(") || !decl.endsWith(")")) {
                throw new ServiceException("Illegal namespace declaration, should be of the form xmlns(<prefix>=<ns uri>): " + decl, "InvalidParameterValue", this.getKey());
            }
            decl = decl.substring("xmlns(".length());
            String[] parts = (decl = decl.substring(0, decl.length() - 1)).split(separator = this.useComma ? "," : "=");
            if (parts.length == 1) {
                prefix = "";
                uri = parts[0];
            } else if (parts.length == 2) {
                prefix = parts[0];
                uri = parts[1];
            } else {
                throw new ServiceException("Illegal namespace declaration, should be of the form prefix" + separator + "<namespace uri>: " + decl, "InvalidParameterValue", this.getKey());
            }
            try {
                new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new ServiceException("Illegal namespace declaration: " + decl, "InvalidParameterValue", this.getKey());
            }
            ctx.declarePrefix(prefix, uri);
        }
        return ctx;
    }
}

