/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.CaseInsensitiveMap;

public class HTTPHeadersCollector
extends AbstractDispatcherCallback {
    public static final ThreadLocal<Map<String, String>> HEADERS = new ThreadLocal();

    public Request init(Request request) {
        HttpServletRequest hr = request.getHttpRequest();
        Enumeration names = hr.getHeaderNames();
        CaseInsensitiveMap headers = new CaseInsensitiveMap(new HashMap());
        while (names.hasMoreElements()) {
            String header = (String)names.nextElement();
            String value = hr.getHeader(header);
            headers.put(header, value);
        }
        HEADERS.set((Map<String, String>)headers);
        return request;
    }

    public void finished(Request request) {
        HEADERS.remove();
    }

    public static String getHeader(String header) {
        Map<String, String> headers = HEADERS.get();
        if (headers == null) {
            return null;
        }
        return headers.get(header);
    }
}

