/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.GeoServerExtensions;

public class XFrameOptionsFilter
implements Filter {
    private static final boolean DEFAULT_SHOULD_SET_POLICY = true;
    private static final String DEFAULT_FRAME_POLICY = "SAMEORIGIN";
    private static final String X_FRAME_OPTIONS = "X-Frame-Options";
    public static final String GEOSERVER_XFRAME_SHOULD_SET_POLICY = "geoserver.xframe.shouldSetPolicy";
    public static final String GEOSERVER_XFRAME_POLICY = "geoserver.xframe.policy";

    private static boolean shouldSetPolicy() {
        boolean shouldSetPolicy = true;
        if (StringUtils.isNotEmpty((CharSequence)GeoServerExtensions.getProperty((String)GEOSERVER_XFRAME_SHOULD_SET_POLICY))) {
            shouldSetPolicy = Boolean.parseBoolean(GeoServerExtensions.getProperty((String)GEOSERVER_XFRAME_SHOULD_SET_POLICY));
        }
        return shouldSetPolicy;
    }

    private static String getFramePolicy() {
        String framePolicy = DEFAULT_FRAME_POLICY;
        if (StringUtils.isNotEmpty((CharSequence)GeoServerExtensions.getProperty((String)GEOSERVER_XFRAME_POLICY))) {
            framePolicy = GeoServerExtensions.getProperty((String)GEOSERVER_XFRAME_POLICY);
        }
        return framePolicy;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (XFrameOptionsFilter.shouldSetPolicy()) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader(X_FRAME_OPTIONS, XFrameOptionsFilter.getFramePolicy());
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

