/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.ResourceInfo;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;

public class TypeNameExtractingVisitor
extends DefaultFilterVisitor {
    Catalog catalog;
    Set<QName> typeNames = new HashSet<QName>();

    public TypeNameExtractingVisitor(Catalog catalog) {
        this.catalog = catalog;
    }

    public Object visit(Id filter, Object data) {
        for (Identifier id : filter.getIdentifiers()) {
            ResourceInfo r;
            String[] split;
            FeatureId fid;
            if (!(id instanceof FeatureId) || (fid = (FeatureId)id).getID() == null || (split = fid.getID().split("\\.")).length <= 1 || (r = this.catalog.getResourceByName(split[0], ResourceInfo.class)) == null) continue;
            this.typeNames.add(new QName(r.getNamespace().getURI(), r.getName()));
        }
        return data;
    }

    public Set<QName> getTypeNames() {
        return this.typeNames;
    }
}

