/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.config.impl.JAIInfoImpl;
import org.geoserver.config.impl.SettingsInfoImpl;

public class GeoServerInfoImpl
implements GeoServerInfo {
    protected String id;
    protected SettingsInfo settings = new SettingsInfoImpl();
    protected JAIInfo jai = new JAIInfoImpl();
    protected CoverageAccessInfo coverageAccess = new CoverageAccessInfoImpl();
    protected MetadataMap metadata = new MetadataMap();
    protected Map<Object, Object> clientProperties = new HashMap<Object, Object>();
    protected long updateSequence;
    protected String adminUsername;
    protected String adminPassword;
    protected int featureTypeCacheSize;
    protected Boolean globalServices = true;
    protected Boolean useHeadersProxyURL = false;
    protected transient GeoServer geoServer;
    protected Integer xmlPostRequestLogBufferSize = 1024;
    protected Boolean xmlExternalEntitiesEnabled = Boolean.FALSE;
    protected String lockProviderName;
    protected GeoServerInfo.WebUIMode webUIMode = GeoServerInfo.WebUIMode.DEFAULT;
    protected Boolean allowStoredQueriesPerWorkspace = true;
    protected ContactInfo contact;
    protected String charset;
    protected String title;
    protected Integer numDecimals;
    protected String onlineResource;
    protected String schemaBaseUrl;
    protected String proxyBaseUrl;
    protected Boolean verbose;
    protected Boolean verboseExceptions;
    private ResourceErrorHandling resourceErrorHandling;

    public GeoServerInfoImpl(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public GeoServerInfoImpl() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public SettingsInfo getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(SettingsInfo settings) {
        this.settings = settings;
    }

    public void setContact(ContactInfo contactInfo) {
        this.getSettings().setContact(contactInfo);
    }

    public ContactInfo getContact() {
        return this.getSettings().getContact();
    }

    @Override
    public JAIInfo getJAI() {
        return this.jai;
    }

    @Override
    public void setJAI(JAIInfo jai) {
        this.jai = jai;
    }

    @Override
    public CoverageAccessInfo getCoverageAccess() {
        return this.coverageAccess;
    }

    @Override
    public void setCoverageAccess(CoverageAccessInfo coverageAccess) {
        this.coverageAccess = coverageAccess;
    }

    public void setTitle(String title) {
        this.getSettings().setTitle(title);
    }

    public String getTitle() {
        return this.getSettings().getTitle();
    }

    public String getCharset() {
        return this.getSettings().getCharset();
    }

    public void setCharset(String charset) {
        this.getSettings().setCharset(charset);
    }

    public int getNumDecimals() {
        return this.getSettings().getNumDecimals();
    }

    public void setNumDecimals(int numDecimals) {
        this.getSettings().setNumDecimals(numDecimals);
    }

    public String getOnlineResource() {
        return this.getSettings().getOnlineResource();
    }

    public void setOnlineResource(String onlineResource) {
        this.getSettings().setOnlineResource(onlineResource);
    }

    public String getProxyBaseUrl() {
        return this.getSettings().getProxyBaseUrl();
    }

    public void setProxyBaseUrl(String proxyBaseUrl) {
        this.getSettings().setProxyBaseUrl(proxyBaseUrl);
    }

    public String getSchemaBaseUrl() {
        return this.getSettings().getSchemaBaseUrl();
    }

    public void setSchemaBaseUrl(String schemaBaseUrl) {
        this.getSettings().setSchemaBaseUrl(schemaBaseUrl);
    }

    public boolean isVerbose() {
        return this.getSettings().isVerbose();
    }

    public void setVerbose(boolean verbose) {
        this.getSettings().setVerbose(verbose);
    }

    public boolean isVerboseExceptions() {
        return this.getSettings().isVerboseExceptions();
    }

    public void setVerboseExceptions(boolean verboseExceptions) {
        this.getSettings().setVerboseExceptions(verboseExceptions);
    }

    @Override
    public long getUpdateSequence() {
        return this.updateSequence;
    }

    @Override
    public void setUpdateSequence(long updateSequence) {
        this.updateSequence = updateSequence;
    }

    @Override
    public String getAdminPassword() {
        return this.adminPassword;
    }

    @Override
    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    @Override
    public String getAdminUsername() {
        return this.adminUsername;
    }

    @Override
    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    @Override
    public int getFeatureTypeCacheSize() {
        return this.featureTypeCacheSize;
    }

    @Override
    public void setFeatureTypeCacheSize(int featureTypeCacheSize) {
        this.featureTypeCacheSize = featureTypeCacheSize;
    }

    @Override
    public Boolean isGlobalServices() {
        return this.globalServices;
    }

    @Override
    public void setGlobalServices(Boolean forceVirtualServices) {
        this.globalServices = forceVirtualServices;
    }

    @Override
    public Boolean isUseHeadersProxyURL() {
        return this.useHeadersProxyURL == null ? false : this.useHeadersProxyURL;
    }

    @Override
    public void setUseHeadersProxyURL(Boolean useHeadersProxyURL) {
        this.useHeadersProxyURL = useHeadersProxyURL;
    }

    @Override
    public void setXmlPostRequestLogBufferSize(Integer bufferSize) {
        this.xmlPostRequestLogBufferSize = bufferSize;
    }

    @Override
    public Integer getXmlPostRequestLogBufferSize() {
        return this.xmlPostRequestLogBufferSize;
    }

    @Override
    public void setXmlExternalEntitiesEnabled(Boolean xmlExternalEntitiesEnabled) {
        this.xmlExternalEntitiesEnabled = xmlExternalEntitiesEnabled;
    }

    @Override
    public Boolean isXmlExternalEntitiesEnabled() {
        return this.xmlExternalEntitiesEnabled;
    }

    @Override
    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadata) {
        this.metadata = metadata;
    }

    @Override
    public Map<Object, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<Object, Object> properties) {
        this.clientProperties = properties;
    }

    @Override
    public String getLockProviderName() {
        return this.lockProviderName;
    }

    @Override
    public void setLockProviderName(String lockProviderName) {
        this.lockProviderName = lockProviderName;
    }

    @Override
    public void dispose() {
        if (this.coverageAccess != null) {
            this.coverageAccess.dispose();
        }
    }

    @Override
    public Boolean isAllowStoredQueriesPerWorkspace() {
        return this.allowStoredQueriesPerWorkspace == null ? Boolean.TRUE : this.allowStoredQueriesPerWorkspace;
    }

    @Override
    public void setAllowStoredQueriesPerWorkspace(Boolean allowStoredQueriesPerWorkspace) {
        this.allowStoredQueriesPerWorkspace = allowStoredQueriesPerWorkspace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.settings == null ? 0 : this.settings.hashCode());
        result = 31 * result + (this.adminPassword == null ? 0 : this.adminPassword.hashCode());
        result = 31 * result + (this.adminUsername == null ? 0 : this.adminUsername.hashCode());
        result = 31 * result + (this.clientProperties == null ? 0 : this.clientProperties.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + Long.valueOf(this.updateSequence).hashCode();
        result = 31 * result + (this.globalServices != false ? 1231 : 1237);
        result = 31 * result + this.xmlPostRequestLogBufferSize;
        result = 31 * result + (this.resourceErrorHandling == null ? 0 : this.resourceErrorHandling.hashCode());
        result = 31 * result + (this.lockProviderName == null ? 0 : this.lockProviderName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoServerInfo)) {
            return false;
        }
        GeoServerInfo other = (GeoServerInfo)obj;
        if (this.adminPassword == null ? other.getAdminPassword() != null : !this.adminPassword.equals(other.getAdminPassword())) {
            return false;
        }
        if (this.adminUsername == null ? other.getAdminUsername() != null : !this.adminUsername.equals(other.getAdminUsername())) {
            return false;
        }
        if (this.settings == null ? other.getSettings() != null : !this.settings.equals(other.getSettings())) {
            return false;
        }
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.updateSequence != other.getUpdateSequence()) {
            return false;
        }
        if (!Objects.equals(this.globalServices, other.isGlobalServices())) {
            return false;
        }
        if (this.xmlPostRequestLogBufferSize == null ? other.getXmlPostRequestLogBufferSize() != null : !this.xmlPostRequestLogBufferSize.equals(other.getXmlPostRequestLogBufferSize())) {
            return false;
        }
        if (this.getResourceErrorHandling() == null ? other.getResourceErrorHandling() != null : !this.getResourceErrorHandling().equals((Object)other.getResourceErrorHandling())) {
            return false;
        }
        return !(this.lockProviderName == null ? other.getLockProviderName() != null : !this.lockProviderName.equals(other.getLockProviderName()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getTitle() + ']';
    }

    public Object readResolve() {
        if (this.globalServices == null) {
            this.globalServices = true;
        }
        if (this.xmlPostRequestLogBufferSize == null) {
            this.xmlPostRequestLogBufferSize = 1024;
        }
        if (this.settings == null) {
            this.settings = new SettingsInfoImpl();
        }
        if (this.contact != null) {
            this.setContact(this.contact);
            this.contact = null;
        }
        if (this.charset != null) {
            this.setCharset(this.charset);
            this.charset = null;
        }
        if (this.title != null) {
            this.setTitle(this.title);
            this.title = null;
        }
        if (this.numDecimals != null) {
            this.setNumDecimals(this.numDecimals);
            this.numDecimals = null;
        }
        if (this.onlineResource != null) {
            this.setOnlineResource(this.onlineResource);
            this.onlineResource = null;
        }
        if (this.schemaBaseUrl != null) {
            this.setSchemaBaseUrl(this.schemaBaseUrl);
            this.schemaBaseUrl = null;
        }
        if (this.proxyBaseUrl != null) {
            this.setProxyBaseUrl(this.proxyBaseUrl);
            this.proxyBaseUrl = null;
        }
        if (this.verbose != null) {
            this.setVerbose(this.verbose);
            this.verbose = null;
        }
        if (this.verboseExceptions != null) {
            this.setVerboseExceptions(this.verboseExceptions);
            this.verboseExceptions = null;
        }
        return this;
    }

    @Override
    public void setResourceErrorHandling(ResourceErrorHandling mode) {
        this.resourceErrorHandling = mode;
    }

    @Override
    public ResourceErrorHandling getResourceErrorHandling() {
        if (this.resourceErrorHandling == null) {
            return ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS;
        }
        return this.resourceErrorHandling;
    }

    @Override
    public GeoServerInfo.WebUIMode getWebUIMode() {
        return this.webUIMode;
    }

    @Override
    public void setWebUIMode(GeoServerInfo.WebUIMode webUIMode) {
        this.webUIMode = webUIMode;
    }
}

