/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.lang.reflect.Proxy;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFacade;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.util.logging.Logging;

public class DefaultGeoServerFacade
implements GeoServerFacade {
    static final Logger LOGGER = Logging.getLogger(DefaultGeoServerFacade.class);
    GeoServerInfo global;
    List<SettingsInfo> settings = new ArrayList<SettingsInfo>();
    LoggingInfo logging;
    List<ServiceInfo> services = new ArrayList<ServiceInfo>();
    GeoServer geoServer;

    public DefaultGeoServerFacade(GeoServer geoServer) {
        this.geoServer = geoServer;
        this.global = geoServer.getFactory().createGlobal();
        this.logging = geoServer.getFactory().createLogging();
    }

    @Override
    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    @Override
    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public GeoServerInfo getGlobal() {
        if (this.global == null) {
            return null;
        }
        return ModificationProxy.create(this.global, GeoServerInfo.class);
    }

    @Override
    public void setGlobal(GeoServerInfo global) {
        this.resolve(global);
        this.setId(global.getSettings());
        this.global = global;
    }

    @Override
    public void save(GeoServerInfo global) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(global);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireGlobalModified(global, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public SettingsInfo getSettings(WorkspaceInfo workspace) {
        for (SettingsInfo s : this.settings) {
            if (!s.getWorkspace().equals(workspace)) continue;
            return ModificationProxy.create(s, SettingsInfo.class);
        }
        return null;
    }

    @Override
    public void add(SettingsInfo s) {
        s = DefaultGeoServerFacade.unwrap(s);
        this.setId(s);
        this.settings.add(s);
    }

    @Override
    public void save(SettingsInfo settings) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(settings);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        settings = (SettingsInfo)proxy.getProxyObject();
        this.geoServer.fireSettingsModified(settings, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void remove(SettingsInfo s) {
        s = DefaultGeoServerFacade.unwrap(s);
        this.settings.remove(s);
    }

    @Override
    public LoggingInfo getLogging() {
        if (this.logging == null) {
            return null;
        }
        return ModificationProxy.create(this.logging, LoggingInfo.class);
    }

    @Override
    public void setLogging(LoggingInfo logging) {
        this.logging = logging;
    }

    @Override
    public void save(LoggingInfo logging) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(logging);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireLoggingModified(logging, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void add(ServiceInfo service) {
        service = DefaultGeoServerFacade.unwrap(service);
        this.setId(service);
        service.setGeoServer(this.geoServer);
        this.services.add(service);
    }

    @Override
    public void save(ServiceInfo service) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(service);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireServiceModified(service, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void remove(ServiceInfo service) {
        this.services.remove(service);
    }

    @Override
    public <T extends ServiceInfo> T getService(Class<T> clazz) {
        return this.find(clazz, null, this.services);
    }

    @Override
    public <T extends ServiceInfo> T getService(WorkspaceInfo workspace, Class<T> clazz) {
        return this.find(clazz, workspace, this.services);
    }

    @Override
    public <T extends ServiceInfo> T getService(String id, Class<T> clazz) {
        for (ServiceInfo si : this.services) {
            if (!id.equals(si.getId())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not locate service of type " + clazz + " and id '" + id + "', available services were " + this.services);
        }
        return null;
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, Class<T> clazz) {
        return this.findByName(name, null, clazz, this.services);
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, WorkspaceInfo workspace, Class<T> clazz) {
        return this.findByName(name, workspace, clazz, this.services);
    }

    @Override
    public Collection<? extends ServiceInfo> getServices() {
        return ModificationProxy.createList(this.filter(this.services, null), ServiceInfo.class);
    }

    @Override
    public Collection<? extends ServiceInfo> getServices(WorkspaceInfo workspace) {
        return ModificationProxy.createList(this.filter(this.services, workspace), ServiceInfo.class);
    }

    @Override
    public void dispose() {
        if (this.global != null) {
            this.global.dispose();
        }
        if (this.settings != null) {
            this.settings.clear();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }

    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    protected void resolve(GeoServerInfo info) {
        GeoServerInfoImpl global = (GeoServerInfoImpl)info;
        if (global.getMetadata() == null) {
            global.setMetadata(new MetadataMap());
        }
        if (global.getClientProperties() == null) {
            global.setClientProperties(new HashMap<Object, Object>());
        }
        if (global.getCoverageAccess() == null) {
            global.setCoverageAccess(new CoverageAccessInfoImpl());
        }
    }

    <T extends ServiceInfo> T find(Class<T> clazz, WorkspaceInfo workspace, List<ServiceInfo> services) {
        for (ServiceInfo si : services) {
            if (!clazz.isAssignableFrom(si.getClass()) || !this.wsEquals(workspace, si.getWorkspace())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not locate service of type " + clazz + " in workspace " + workspace + ", available services were " + services);
        }
        return null;
    }

    <T extends ServiceInfo> T findByName(String name, WorkspaceInfo workspace, Class<T> clazz, List<ServiceInfo> services) {
        for (ServiceInfo si : services) {
            if (!name.equals(si.getName()) || !this.wsEquals(workspace, si.getWorkspace())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not locate service of type " + clazz + " in workspace " + workspace + " and name '" + name + "', available services were " + services);
        }
        return null;
    }

    public List filter(List<ServiceInfo> services, WorkspaceInfo workspace) {
        ArrayList<ServiceInfo> list2 = new ArrayList<ServiceInfo>();
        for (ServiceInfo si : services) {
            if (!this.wsEquals(workspace, si.getWorkspace())) continue;
            list2.add(si);
        }
        return list2;
    }

    boolean wsEquals(WorkspaceInfo ws1, WorkspaceInfo ws2) {
        if (ws1 == null) {
            return ws2 == null;
        }
        return ws1.equals(ws2);
    }

    protected void setId(Object o) {
        if (OwsUtils.get((Object)o, (String)"id") == null) {
            String uid = new UID().toString();
            OwsUtils.set((Object)o, (String)"id", (Object)(o.getClass().getSimpleName() + "-" + uid));
        }
    }
}

