/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.SystemUtils;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Mark;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.URLs;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.xml.sax.EntityResolver;

public class GeoServerDataDirectory {
    GeoServerResourceLoader resourceLoader;
    EntityResolverProvider entityResolverProvider;
    GeoServerResourceLocator resourceLocator;
    static final String WORKSPACE_XML = "workspace.xml";
    static final String NAMESPACE_XML = "namespace.xml";
    static final String DATASTORE_XML = "datastore.xml";
    static final String COVERAGESTORE_XML = "coveragestore.xml";
    static final String WMSSTORE_XML = "wmsstore.xml";
    static final String WMTSSTORE_XML = "wmtsstore.xml";
    static final String FEATURETYPE_XML = "featuretype.xml";
    static final String COVERAGE_XML = "coverage.xml";
    static final String WMSLAYER_XML = "wmslayer.xml";
    static final String WMTSLAYER_XML = "wmtslayer.xml";
    static final String LAYER_XML = "layer.xml";
    static final String WORKSPACE_DIR = "workspaces";
    static final String LAYERGROUP_DIR = "layergroups";
    static final String STYLE_DIR = "styles";
    static final String SECURITY_DIR = "security";

    public GeoServerDataDirectory(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public GeoServerDataDirectory(File baseDirectory) {
        this(new GeoServerResourceLoader(baseDirectory));
    }

    public GeoServerResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Resource get(String path) {
        return this.resourceLoader.get(path);
    }

    public File root() {
        return this.resourceLoader.getBaseDirectory();
    }

    public File findOrCreateDir(String ... location) throws IOException {
        return this.get(Paths.path((String[])location)).dir();
    }

    public File findFile(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])location));
        return Resources.find((Resource)resource);
    }

    public File findDataRoot() throws IOException {
        Resource directory = this.get("data");
        return Resources.directory((Resource)directory);
    }

    public File findOrCreateDataRoot() throws IOException {
        Resource directory = this.get("data");
        return directory.dir();
    }

    public File findDataDir(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        return Resources.directory((Resource)resource);
    }

    public File findOrCreateDataDir(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        return resource.dir();
    }

    public File findDataFile(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        return Resources.file((Resource)resource);
    }

    public File findLegacyResourceDir(ResourceInfo resource) throws IOException {
        StoreInfo store = resource.getStore();
        String dirname = store.getName() + "_" + resource.getName();
        File dir = null;
        if (resource instanceof FeatureTypeInfo) {
            dir = this.resourceLoader.find(new String[]{"featureTypes", dirname});
        } else if (resource instanceof CoverageInfo) {
            dir = this.resourceLoader.find(new String[]{"coverages", dirname});
        }
        return dir != null ? dir : null;
    }

    @Nonnull
    public Resource getRoot(String ... path) {
        Resource r = this.get(Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getSecurity(String ... path) {
        Resource r = this.get(Paths.path((String[])new String[]{SECURITY_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getWorkspaces(String ... path) {
        Resource r = this.get(Paths.path((String[])new String[]{WORKSPACE_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource defaultWorkspaceConfig() {
        Resource r = this.getRoot("default.xml");
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(WorkspaceInfo ws, String ... path) {
        Resource r = ws == null ? this.get(Paths.path((String[])path)) : this.getWorkspaces(ws.getName(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WorkspaceInfo ws) {
        Resource r = this.get(ws, WORKSPACE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(NamespaceInfo ns, String ... path) {
        Resource r = ns == null ? this.get(Paths.path((String[])path)) : this.getWorkspaces(ns.getPrefix(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(NamespaceInfo ns) {
        Resource r = this.get(ns, NAMESPACE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(StoreInfo store, String ... path) {
        Resource r = this.get(store.getWorkspace(), store.getName(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(DataStoreInfo ds) {
        Resource r = this.get(ds, DATASTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(CoverageStoreInfo cs) {
        Resource r = this.get(cs, COVERAGESTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMSStoreInfo wmss) {
        Resource r = this.get(wmss, WMSSTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMTSStoreInfo wmss) {
        Resource r = this.get(wmss, WMTSSTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    private Resource config(StoreInfo si) {
        Resource r;
        if (si instanceof DataStoreInfo) {
            r = this.config((DataStoreInfo)si);
        } else if (si instanceof CoverageStoreInfo) {
            r = this.config((CoverageStoreInfo)si);
        } else if (si instanceof WMTSStoreInfo) {
            r = this.config((WMTSStoreInfo)si);
        } else if (si instanceof WMSStoreInfo) {
            r = this.config((WMSStoreInfo)si);
        } else {
            throw new IllegalArgumentException("Only DataStoreInfo, CoverageStoreInfo, and WMS/WMTSStoreInfo are supported.");
        }
        assert (r != null);
        return r;
    }

    @Nonnull
    private Resource config(ResourceInfo si) {
        Resource r;
        if (si instanceof FeatureTypeInfo) {
            r = this.config((FeatureTypeInfo)si);
        } else if (si instanceof CoverageInfo) {
            r = this.config((CoverageInfo)si);
        } else if (si instanceof WMTSLayerInfo) {
            r = this.config((WMTSLayerInfo)si);
        } else if (si instanceof WMSLayerInfo) {
            r = this.config((WMSLayerInfo)si);
        } else {
            throw new IllegalArgumentException("Only FeatureTypeInfo, CoverageInfo, and WMS/WMTSLayerInfo are supported.");
        }
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(ResourceInfo ri, String ... path) {
        Resource r = this.get(ri.getStore(), ri.getName(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(FeatureTypeInfo fti) {
        Resource r = this.get(fti, FEATURETYPE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(CoverageInfo c) {
        Resource r = this.get(c, COVERAGE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMSLayerInfo wmsl) {
        Resource r = this.get(wmsl, WMSLAYER_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMTSLayerInfo wmsl) {
        Resource r = this.get(wmsl, WMTSLAYER_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(LayerInfo l, String ... path) {
        Resource r;
        if (l.getResource() instanceof FeatureTypeInfo) {
            r = this.get(l.getResource(), path);
        } else if (l.getResource() instanceof CoverageInfo) {
            r = this.get(l.getResource(), path);
        } else if (l.getResource() instanceof WMTSLayerInfo) {
            r = this.get(l.getResource(), path);
        } else if (l.getResource() instanceof WMSLayerInfo) {
            r = this.get(l.getResource(), path);
        } else {
            throw new IllegalArgumentException("Only FeatureTypeInfo, CoverageInfo, and WMS/WMTSLayerInfo are supported.");
        }
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(LayerInfo li) {
        Resource r = this.get(li, LAYER_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getLayerGroups(String ... path) {
        Resource r = this.getLayerGroups((WorkspaceInfo)null, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getLayerGroups(WorkspaceInfo wsi, String ... path) {
        Resource r = this.get(wsi, Paths.path((String[])new String[]{LAYERGROUP_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(LayerGroupInfo lgi, String ... path) {
        WorkspaceInfo wsi = lgi.getWorkspace();
        Resource r = this.getLayerGroups(wsi, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(LayerGroupInfo lgi) {
        Resource r = this.get(lgi, String.format("%s.xml", lgi.getName()));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getStyles(String ... path) {
        Resource r = this.getStyles((WorkspaceInfo)null, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getStyles(WorkspaceInfo wsi, String ... path) {
        Resource r = this.get(wsi, Paths.path((String[])new String[]{STYLE_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(StyleInfo si, String ... path) {
        WorkspaceInfo workspace = si != null ? si.getWorkspace() : null;
        Resource r = this.getStyles(workspace, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(StyleInfo s) {
        String filename = s.getFilename() != null && s.getFilename().endsWith(".xml") && s.getFilename().startsWith(s.getName() + ".") ? s.getName() + ".xml.xml" : s.getName() + ".xml";
        Resource r = this.get(s, filename);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource style(StyleInfo s) {
        String filename = s.getFilename();
        Resource r = this.get(s, filename);
        assert (r != null);
        return r;
    }

    @Nonnull
    protected Style parsedStyleResources(StyleInfo s) throws IOException {
        Resource styleResource = this.style(s);
        if (styleResource.getType() == Resource.Type.UNDEFINED) {
            throw new FileNotFoundException("No such resource: " + s.getFilename());
        }
        ResourceAwareResourceLocator locator = new ResourceAwareResourceLocator();
        locator.setSourceUrl(Resources.toURL((Resource)styleResource));
        StyledLayerDescriptor sld = Styles.handler(s.getFormat()).parse(styleResource, s.getFormatVersion(), (ResourceLocator)locator, null);
        Style style = Styles.style(sld);
        assert (style != null);
        return style;
    }

    @Nonnull
    public StyledLayerDescriptor parsedSld(StyleInfo s) throws IOException {
        Resource styleResource = this.style(s);
        if (styleResource.getType() == Resource.Type.UNDEFINED) {
            throw new IOException("No such resource: " + s.getFilename() + (s.getWorkspace() != null ? " in workspace " + s.getWorkspace() : ""));
        }
        File input = styleResource.file();
        GeoServerResourceLocator locator = new GeoServerResourceLocator();
        locator.setSourceUrl(Resources.toURL((Resource)styleResource));
        EntityResolver entityResolver = this.getEntityResolver();
        StyledLayerDescriptor sld = Styles.handler(s.getFormat()).parse(input, s.getFormatVersion(), (ResourceLocator)locator, this.getEntityResolver());
        return sld;
    }

    @Nonnull
    public Style parsedStyle(StyleInfo s) throws IOException {
        StyledLayerDescriptor sld = this.parsedSld(s);
        Style style = Styles.style(sld);
        assert (style != null);
        return style;
    }

    private EntityResolver getEntityResolver() {
        EntityResolver resolver = null;
        EntityResolverProvider provider = (EntityResolverProvider)GeoServerExtensions.bean(EntityResolverProvider.class);
        if (provider != null) {
            resolver = provider.getEntityResolver();
        }
        return resolver;
    }

    @Nonnull
    public Resource config(SettingsInfo s) {
        Resource r = this.get(s.getWorkspace(), "settings.xml");
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(LoggingInfo l) {
        Resource r = this.getRoot("logging.xml");
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(GeoServerInfo g) {
        Resource r = this.getRoot("global.xml");
        assert (r != null);
        return r;
    }

    List<Resource> additionalStyleResources(StyleInfo s) throws IOException {
        final ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource baseDir = this.get(s, new String[0]);
        try {
            Style parsedStyle = this.parsedStyleResources(s);
            parsedStyle.accept((StyleVisitor)new AbstractStyleVisitor(){

                public void visit(ExternalGraphic exgr) {
                    if (exgr.getOnlineResource() == null) {
                        return;
                    }
                    try {
                        String location = exgr.getURI();
                        Resource r = GeoServerDataDirectory.this.resourceLoader.fromURL(location);
                        if (r != null && r.getType() != Resource.Type.UNDEFINED) {
                            resources.add(r);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error attemping to process SLD resource", e);
                    }
                }

                public void visit(Mark mark) {
                    String name;
                    Expression wellKnownName = mark.getWellKnownName();
                    if (wellKnownName instanceof Literal && (name = (String)wellKnownName.evaluate(null, String.class)).startsWith("resource:/")) {
                        try {
                            Resource r = GeoServerDataDirectory.this.resourceLoader.fromURL(name);
                            if (r != null && r.getType() != Resource.Type.UNDEFINED) {
                                resources.add(r);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error attemping to process SLD resource", e);
                        }
                    }
                }

                public void visit(ChannelSelection cs) {
                    SelectedChannelType[] rgbChannels;
                    if (cs.getGrayChannel() != null) {
                        cs.getGrayChannel().accept((StyleVisitor)this);
                    }
                    if ((rgbChannels = cs.getRGBChannels()) != null) {
                        for (SelectedChannelType ch : rgbChannels) {
                            if (ch == null) continue;
                            ch.accept((StyleVisitor)this);
                        }
                    }
                }
            });
        }
        catch (FileNotFoundException e) {
            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error loading style:" + e);
        }
        catch (IOException e) {
            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error loading style", e);
        }
        return resources;
    }

    public static URL fileToUrlPreservingCqlTemplates(File file) {
        URL url = URLs.fileToUrl((File)file);
        if (!file.getPath().contains("${")) {
            return url;
        }
        try {
            return new URL(url.toExternalForm().replace("%7B", "{").replace("%7D", "}"));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public ResourceStore getResourceStore() {
        return this.resourceLoader.getResourceStore();
    }

    public ResourceLocator getResourceLocator() {
        GeoServerResourceLocator locator = new GeoServerResourceLocator();
        locator.setSourceUrl(URLs.fileToUrl((File)this.getStyles(new String[0]).dir()));
        return locator;
    }

    public ResourceLocator getResourceLocator(WorkspaceInfo ws) {
        GeoServerResourceLocator locator = new GeoServerResourceLocator();
        locator.setSourceUrl(URLs.fileToUrl((File)this.getStyles(ws, new String[0]).dir()));
        return locator;
    }

    private class GeoServerResourceLocator
    extends ResourceAwareResourceLocator {
        private GeoServerResourceLocator() {
        }

        public URL locateResource(String uri) {
            URL url = super.locateResource(uri);
            if (url != null && url.getProtocol().equalsIgnoreCase("resource")) {
                Resource resource = GeoServerDataDirectory.this.resourceLoader.fromURL(url);
                File file = Resources.exists((Resource)resource) ? resource.file() : Paths.toFile((File)GeoServerDataDirectory.this.root(), (String)resource.path());
                URL u = GeoServerDataDirectory.fileToUrlPreservingCqlTemplates(file);
                if (url.getQuery() != null) {
                    try {
                        u = new URL(u.toString() + "?" + url.getQuery());
                    }
                    catch (MalformedURLException ex) {
                        GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error processing query string for resource with uri: " + uri, ex);
                        return null;
                    }
                }
                if (url.getRef() != null) {
                    try {
                        u = new URL(u.toString() + "#" + url.getRef());
                    }
                    catch (MalformedURLException ex) {
                        GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error processing # fragment for resource with uri: " + uri, ex);
                        return null;
                    }
                }
                return u;
            }
            return url;
        }
    }

    private class ResourceAwareResourceLocator
    extends DefaultResourceLocator {
        private ResourceAwareResourceLocator() {
        }

        protected URL validateRelativeURL(URL relativeUrl) {
            if (relativeUrl.getProtocol().equalsIgnoreCase("resource")) {
                String path = relativeUrl.getPath();
                if (GeoServerDataDirectory.this.resourceLoader.get(path).getType() != Resource.Type.UNDEFINED) {
                    return relativeUrl;
                }
                return null;
            }
            return super.validateRelativeURL(relativeUrl);
        }

        protected URL makeRelativeURL(String uri, String query) {
            if (SystemUtils.IS_OS_WINDOWS && uri.contains("\\")) {
                uri = uri.replace('\\', '/');
            }
            return super.makeRelativeURL(uri, query);
        }
    }
}

