/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LockingCatalogFacade;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AbstractCatalogFacade;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CatalogInfoLookup;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ProxyUtils;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class DefaultCatalogFacade
extends AbstractCatalogFacade
implements CatalogFacade {
    static final Function<StoreInfo, Name> STORE_NAME_MAPPER = s -> new NameImpl(s.getWorkspace().getId(), s.getName());
    static final Function<ResourceInfo, Name> RESOURCE_NAME_MAPPER = r -> new NameImpl(r.getNamespace().getId(), r.getName());
    static final Function<LayerInfo, Name> LAYER_NAME_MAPPER = l -> RESOURCE_NAME_MAPPER.apply(l.getResource());
    static final Function<LayerGroupInfo, Name> LAYERGROUP_NAME_MAPPER = lg -> new NameImpl(lg.getWorkspace() != null ? lg.getWorkspace().getId() : null, lg.getName());
    static final Function<NamespaceInfo, Name> NAMESPACE_NAME_MAPPER = n -> new NameImpl(n.getPrefix());
    static final Function<WorkspaceInfo, Name> WORKSPACE_NAME_MAPPER = w -> new NameImpl(w.getName());
    static final Function<StyleInfo, Name> STYLE_NAME_MAPPER = s -> new NameImpl(s.getWorkspace() != null ? s.getWorkspace().getId() : null, s.getName());
    protected CatalogInfoLookup<StoreInfo> stores = new CatalogInfoLookup<StoreInfo>(STORE_NAME_MAPPER);
    protected Map<String, DataStoreInfo> defaultStores = new ConcurrentHashMap<String, DataStoreInfo>();
    protected CatalogInfoLookup<ResourceInfo> resources = new CatalogInfoLookup<ResourceInfo>(RESOURCE_NAME_MAPPER);
    protected volatile NamespaceInfo defaultNamespace;
    protected CatalogInfoLookup<NamespaceInfo> namespaces = new CatalogInfoLookup<NamespaceInfo>(NAMESPACE_NAME_MAPPER);
    protected volatile WorkspaceInfo defaultWorkspace;
    protected CatalogInfoLookup<WorkspaceInfo> workspaces = new CatalogInfoLookup<WorkspaceInfo>(WORKSPACE_NAME_MAPPER);
    protected LayerInfoLookup layers = new LayerInfoLookup();
    protected List<MapInfo> maps = new CopyOnWriteArrayList<MapInfo>();
    protected CatalogInfoLookup<LayerGroupInfo> layerGroups = new CatalogInfoLookup<LayerGroupInfo>(LAYERGROUP_NAME_MAPPER);
    protected CatalogInfoLookup<StyleInfo> styles = new CatalogInfoLookup<StyleInfo>(STYLE_NAME_MAPPER);
    private CatalogImpl catalog;

    public DefaultCatalogFacade(Catalog catalog) {
        this.setCatalog(catalog);
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = (CatalogImpl)catalog;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public StoreInfo add(StoreInfo store) {
        this.resolve(store);
        this.stores.add(store);
        return ModificationProxy.create(store, StoreInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StoreInfo store) {
        store = DefaultCatalogFacade.unwrap(store);
        CatalogInfoLookup<StoreInfo> catalogInfoLookup = this.stores;
        synchronized (catalogInfoLookup) {
            this.stores.remove(store);
        }
    }

    @Override
    public void save(StoreInfo store) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(store);
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(store, propertyNames, oldValues, newValues);
        this.stores.update(store);
        this.commitProxy(store);
        this.afterSaved(store, propertyNames, oldValues, newValues);
    }

    @Override
    public <T extends StoreInfo> T detach(T store) {
        return store;
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        StoreInfo store = (StoreInfo)this.stores.findById(id, clazz);
        return (T)this.wrapInModificationProxy(store, clazz);
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        StoreInfo result;
        if (workspace == ANY_WORKSPACE) {
            result = this.stores.findFirst(clazz, s -> name.equals(s.getName()));
        } else {
            NameImpl qname = new NameImpl(workspace != null ? workspace.getId() : null, name);
            result = (StoreInfo)this.stores.findByName((Name)qname, clazz);
        }
        return (T)this.wrapInModificationProxy(result, clazz);
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        WorkspaceInfo ws = workspace == null ? this.getDefaultWorkspace() : workspace;
        List<StoreInfo> matches = this.stores.list(clazz, s -> ws.equals(s.getWorkspace()));
        return ModificationProxy.createList(matches, clazz);
    }

    @Override
    public <T extends StoreInfo> List<T> getStores(Class<T> clazz) {
        return ModificationProxy.createList(this.stores.list(clazz, CatalogInfoLookup.TRUE), clazz);
    }

    @Override
    public DataStoreInfo getDefaultDataStore(WorkspaceInfo workspace) {
        if (this.defaultStores.containsKey(workspace.getId())) {
            DataStoreInfo defaultStore = this.defaultStores.get(workspace.getId());
            return ModificationProxy.create(defaultStore, DataStoreInfo.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultDataStore(WorkspaceInfo workspace, DataStoreInfo store) {
        DataStoreInfo old = this.defaultStores.get(workspace.getId());
        this.catalog.fireModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultDataStore"), (List)Arrays.asList(old), (List)Arrays.asList(store));
        Map<String, DataStoreInfo> map = this.defaultStores;
        synchronized (map) {
            if (store != null) {
                this.defaultStores.put(workspace.getId(), store);
            } else {
                this.defaultStores.remove(workspace.getId());
            }
        }
        this.catalog.firePostModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultDataStore"), (List)Arrays.asList(old), (List)Arrays.asList(store));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceInfo add(ResourceInfo resource) {
        this.resolve(resource);
        CatalogInfoLookup<ResourceInfo> catalogInfoLookup = this.resources;
        synchronized (catalogInfoLookup) {
            this.resources.add(resource);
        }
        return ModificationProxy.create(resource, ResourceInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ResourceInfo resource) {
        resource = DefaultCatalogFacade.unwrap(resource);
        CatalogInfoLookup<ResourceInfo> catalogInfoLookup = this.resources;
        synchronized (catalogInfoLookup) {
            this.resources.remove(resource);
        }
    }

    @Override
    public void save(ResourceInfo resource) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(resource);
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(resource, propertyNames, oldValues, newValues);
        this.resources.update(resource);
        this.layers.update(resource);
        this.commitProxy(resource);
        this.afterSaved(resource, propertyNames, oldValues, newValues);
    }

    @Override
    public <T extends ResourceInfo> T detach(T resource) {
        return resource;
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        ResourceInfo result = (ResourceInfo)this.resources.findById(id, clazz);
        return (T)this.wrapInModificationProxy(result, clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo namespace, String name, Class<T> clazz) {
        ResourceInfo result;
        if (namespace == ANY_NAMESPACE) {
            result = this.resources.findFirst(clazz, r -> name.equals(r.getName()));
        } else {
            NameImpl qname = new NameImpl(namespace != null ? namespace.getId() : null, name);
            result = (ResourceInfo)this.resources.findByName((Name)qname, clazz);
        }
        return (T)this.wrapInModificationProxy(result, clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResources(Class<T> clazz) {
        return ModificationProxy.createList(this.resources.list(clazz, CatalogInfoLookup.TRUE), clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo namespace, Class<T> clazz) {
        NamespaceInfo ns = namespace == null ? this.getDefaultNamespace() : namespace;
        List<ResourceInfo> matches = this.resources.list(clazz, r -> ns.equals(r.getNamespace()));
        return ModificationProxy.createList(matches, clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        ResourceInfo resource = null;
        NamespaceInfo ns = null;
        if (store.getWorkspace() != null && store.getWorkspace().getName() != null && (ns = this.getNamespaceByPrefix(store.getWorkspace().getName())) != null) {
            resource = (ResourceInfo)this.resources.findByName((Name)new NameImpl(ns.getId(), name), clazz);
            if (resource != null && !store.equals(resource.getStore())) {
                return null;
            }
        } else {
            resource = this.resources.findFirst(clazz, r -> name.equals(r.getName()) && store.equals(r.getStore()));
        }
        return (T)this.wrapInModificationProxy(resource, clazz);
    }

    private <T extends CatalogInfo> T wrapInModificationProxy(T ci, Class<T> clazz) {
        if (ci != null) {
            return ModificationProxy.create(ci, clazz);
        }
        return null;
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        List<ResourceInfo> matches = this.resources.list(clazz, r -> store.equals(r.getStore()));
        return ModificationProxy.createList(matches, clazz);
    }

    @Override
    public LayerInfo add(LayerInfo layer) {
        this.resolve(layer);
        this.layers.add(layer);
        return ModificationProxy.create(layer, LayerInfo.class);
    }

    @Override
    public void remove(LayerInfo layer) {
        this.layers.remove(DefaultCatalogFacade.unwrap(layer));
    }

    @Override
    public void save(LayerInfo layer) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(layer);
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(layer, propertyNames, oldValues, newValues);
        this.layers.update(layer);
        this.commitProxy(layer);
        this.afterSaved(layer, propertyNames, oldValues, newValues);
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return layer;
    }

    @Override
    public LayerInfo getLayer(String id) {
        LayerInfo li = this.layers.findById(id, LayerInfo.class);
        return this.wrapInModificationProxy(li, LayerInfo.class);
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        LayerInfo result = this.layers.findFirst(LayerInfo.class, li -> name.equals(li.getName()));
        return this.wrapInModificationProxy(result, LayerInfo.class);
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        Name name = RESOURCE_NAME_MAPPER.apply(resource);
        LayerInfo layer = this.layers.findByName(name, LayerInfo.class);
        if (layer == null) {
            return Collections.emptyList();
        }
        ArrayList<LayerInfo> matches = new ArrayList<LayerInfo>();
        matches.add(layer);
        return ModificationProxy.createList(matches, LayerInfo.class);
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        List<LayerInfo> matches = this.layers.list(LayerInfo.class, li -> style.equals(li.getDefaultStyle()) || li.getStyles().contains(style));
        return ModificationProxy.createList(matches, LayerInfo.class);
    }

    @Override
    public List<LayerInfo> getLayers() {
        return ModificationProxy.createList(new ArrayList(this.layers.values()), LayerInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapInfo add(MapInfo map) {
        this.resolve(map);
        List<MapInfo> list2 = this.maps;
        synchronized (list2) {
            this.maps.add(map);
        }
        return ModificationProxy.create(map, MapInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MapInfo map) {
        List<MapInfo> list2 = this.maps;
        synchronized (list2) {
            this.maps.remove(DefaultCatalogFacade.unwrap(map));
        }
    }

    @Override
    public void save(MapInfo map) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(map);
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(map, propertyNames, oldValues, newValues);
        this.commitProxy(map);
        this.afterSaved(map, propertyNames, oldValues, newValues);
    }

    @Override
    public MapInfo detach(MapInfo map) {
        return map;
    }

    @Override
    public MapInfo getMap(String id) {
        for (MapInfo map : this.maps) {
            if (!id.equals(map.getId())) continue;
            return ModificationProxy.create(map, MapInfo.class);
        }
        return null;
    }

    @Override
    public MapInfo getMapByName(String name) {
        for (MapInfo map : this.maps) {
            if (!name.equals(map.getName())) continue;
            return ModificationProxy.create(map, MapInfo.class);
        }
        return null;
    }

    @Override
    public List<MapInfo> getMaps() {
        return ModificationProxy.createList(new ArrayList<MapInfo>(this.maps), MapInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LayerGroupInfo add(LayerGroupInfo layerGroup) {
        this.resolve(layerGroup);
        CatalogInfoLookup<LayerGroupInfo> catalogInfoLookup = this.layerGroups;
        synchronized (catalogInfoLookup) {
            this.layerGroups.add(layerGroup);
        }
        return ModificationProxy.create(layerGroup, LayerGroupInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(LayerGroupInfo layerGroup) {
        CatalogInfoLookup<LayerGroupInfo> catalogInfoLookup = this.layerGroups;
        synchronized (catalogInfoLookup) {
            this.layerGroups.remove(DefaultCatalogFacade.unwrap(layerGroup));
        }
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(layerGroup);
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(layerGroup, propertyNames, oldValues, newValues);
        this.layerGroups.update(layerGroup);
        this.commitProxy(layerGroup);
        this.afterSaved(layerGroup, propertyNames, oldValues, newValues);
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return layerGroup;
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return ModificationProxy.createList(new ArrayList<LayerGroupInfo>(this.layerGroups.values()), LayerGroupInfo.class);
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo workspace) {
        WorkspaceInfo ws = workspace == null ? this.getDefaultWorkspace() : workspace;
        Predicate<LayerGroupInfo> predicate = workspace == NO_WORKSPACE ? lg -> lg.getWorkspace() == null : lg -> ws.equals(lg.getWorkspace());
        List<LayerGroupInfo> matches = this.layerGroups.list(LayerGroupInfo.class, predicate);
        return ModificationProxy.createList(matches, LayerGroupInfo.class);
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        LayerGroupInfo result = this.layerGroups.findById(id, LayerGroupInfo.class);
        return this.wrapInModificationProxy(result, LayerGroupInfo.class);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        return this.getLayerGroupByName(NO_WORKSPACE, name);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo workspace, String name) {
        LayerGroupInfo match = workspace == NO_WORKSPACE ? this.layerGroups.findByName((Name)new NameImpl(null, name), LayerGroupInfo.class) : (ANY_WORKSPACE == workspace ? this.layerGroups.findFirst(LayerGroupInfo.class, lg -> name.equals(lg.getName())) : this.layerGroups.findByName((Name)new NameImpl(workspace.getId(), name), LayerGroupInfo.class));
        return this.wrapInModificationProxy(match, LayerGroupInfo.class);
    }

    @Override
    public NamespaceInfo add(NamespaceInfo namespace) {
        this.resolve(namespace);
        NamespaceInfo unwrapped = DefaultCatalogFacade.unwrap(namespace);
        this.namespaces.add(unwrapped);
        return ModificationProxy.create(unwrapped, NamespaceInfo.class);
    }

    @Override
    public void remove(NamespaceInfo namespace) {
        if (namespace.equals(this.defaultNamespace)) {
            this.defaultNamespace = null;
        }
        this.namespaces.remove(namespace);
    }

    @Override
    public void save(NamespaceInfo namespace) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(namespace);
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(namespace, propertyNames, oldValues, newValues);
        this.namespaces.update(namespace);
        this.commitProxy(namespace);
        this.afterSaved(namespace, propertyNames, oldValues, newValues);
    }

    @Override
    public NamespaceInfo detach(NamespaceInfo namespace) {
        return namespace;
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return this.wrapInModificationProxy(this.defaultNamespace, NamespaceInfo.class);
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        NamespaceInfo old = this.defaultNamespace;
        this.catalog.fireModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultNamespace"), (List)Arrays.asList(old), (List)Arrays.asList(defaultNamespace));
        this.defaultNamespace = DefaultCatalogFacade.unwrap(defaultNamespace);
        this.catalog.firePostModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultNamespace"), (List)Arrays.asList(old), (List)Arrays.asList(defaultNamespace));
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        NamespaceInfo ns = this.namespaces.findById(id, NamespaceInfo.class);
        return this.wrapInModificationProxy(ns, NamespaceInfo.class);
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        NamespaceInfo ns = this.namespaces.findByName((Name)new NameImpl(prefix), NamespaceInfo.class);
        return this.wrapInModificationProxy(ns, NamespaceInfo.class);
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        NamespaceInfo result = this.namespaces.findFirst(NamespaceInfo.class, ns -> uri.equals(ns.getURI()));
        return this.wrapInModificationProxy(result, NamespaceInfo.class);
    }

    @Override
    public List<NamespaceInfo> getNamespacesByURI(String uri) {
        List<NamespaceInfo> found = this.namespaces.list(NamespaceInfo.class, namespaceInfo -> namespaceInfo.getURI().equals(uri));
        return ModificationProxy.createList(found, NamespaceInfo.class);
    }

    @Override
    public List<NamespaceInfo> getNamespaces() {
        return ModificationProxy.createList(new ArrayList<NamespaceInfo>(this.namespaces.values()), NamespaceInfo.class);
    }

    @Override
    public WorkspaceInfo add(WorkspaceInfo workspace) {
        this.resolve(workspace);
        WorkspaceInfo unwrapped = DefaultCatalogFacade.unwrap(workspace);
        this.workspaces.add(unwrapped);
        return ModificationProxy.create(unwrapped, WorkspaceInfo.class);
    }

    @Override
    public void remove(WorkspaceInfo workspace) {
        if (workspace.equals(this.defaultWorkspace)) {
            this.defaultWorkspace = null;
        }
        this.workspaces.remove(workspace);
    }

    @Override
    public void save(WorkspaceInfo workspace) {
        DataStoreInfo ds;
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(workspace);
        WorkspaceInfo ws = (WorkspaceInfo)h.getProxyObject();
        if (!workspace.getName().equals(ws.getName()) && (ds = this.defaultStores.remove(ws.getName())) != null) {
            this.defaultStores.put(workspace.getName(), ds);
        }
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(workspace, propertyNames, oldValues, newValues);
        this.workspaces.update(workspace);
        this.commitProxy(workspace);
        this.afterSaved(workspace, propertyNames, oldValues, newValues);
    }

    @Override
    public WorkspaceInfo detach(WorkspaceInfo workspace) {
        return workspace;
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return this.wrapInModificationProxy(this.defaultWorkspace, WorkspaceInfo.class);
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        WorkspaceInfo old = this.defaultWorkspace;
        this.catalog.fireModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultWorkspace"), (List)Arrays.asList(old), (List)Arrays.asList(workspace));
        this.defaultWorkspace = DefaultCatalogFacade.unwrap(workspace);
        this.catalog.firePostModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultWorkspace"), (List)Arrays.asList(old), (List)Arrays.asList(workspace));
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        return ModificationProxy.createList(new ArrayList<WorkspaceInfo>(this.workspaces.values()), WorkspaceInfo.class);
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        WorkspaceInfo ws = this.workspaces.findById(id, WorkspaceInfo.class);
        return this.wrapInModificationProxy(ws, WorkspaceInfo.class);
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        WorkspaceInfo ws = this.workspaces.findByName((Name)new NameImpl(name), WorkspaceInfo.class);
        return this.wrapInModificationProxy(ws, WorkspaceInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleInfo add(StyleInfo style) {
        this.resolve(style);
        CatalogInfoLookup<StyleInfo> catalogInfoLookup = this.styles;
        synchronized (catalogInfoLookup) {
            this.styles.add(style);
        }
        return ModificationProxy.create(style, StyleInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StyleInfo style) {
        CatalogInfoLookup<StyleInfo> catalogInfoLookup = this.styles;
        synchronized (catalogInfoLookup) {
            this.styles.remove(DefaultCatalogFacade.unwrap(style));
        }
    }

    @Override
    public void save(StyleInfo style) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(style);
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.beforeSaved(style, propertyNames, oldValues, newValues);
        this.styles.update(style);
        this.commitProxy(style);
        this.afterSaved(style, propertyNames, oldValues, newValues);
    }

    @Override
    public StyleInfo detach(StyleInfo style) {
        return style;
    }

    @Override
    public StyleInfo getStyle(String id) {
        StyleInfo match = this.styles.findById(id, StyleInfo.class);
        return this.wrapInModificationProxy(match, StyleInfo.class);
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        StyleInfo match = this.styles.findByName((Name)new NameImpl(null, name), StyleInfo.class);
        if (match == null) {
            match = this.styles.findFirst(StyleInfo.class, s -> name.equals(s.getName()));
        }
        return this.wrapInModificationProxy(match, StyleInfo.class);
    }

    @Override
    public StyleInfo getStyleByName(WorkspaceInfo workspace, String name) {
        if (null == workspace) {
            throw new NullPointerException("workspace");
        }
        if (null == name) {
            throw new NullPointerException("name");
        }
        if (workspace == ANY_WORKSPACE) {
            return this.getStyleByName(name);
        }
        NameImpl sn = new NameImpl(workspace == null ? null : workspace.getId(), name);
        StyleInfo match = this.styles.findByName((Name)sn, StyleInfo.class);
        return this.wrapInModificationProxy(match, StyleInfo.class);
    }

    @Override
    public List<StyleInfo> getStyles() {
        return ModificationProxy.createList(new ArrayList<StyleInfo>(this.styles.values()), StyleInfo.class);
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo workspace) {
        List<StyleInfo> matches;
        if (workspace == NO_WORKSPACE) {
            matches = this.styles.list(StyleInfo.class, s -> s.getWorkspace() == null);
        } else {
            WorkspaceInfo ws = workspace == null ? this.getDefaultWorkspace() : workspace;
            matches = this.styles.list(StyleInfo.class, s -> ws.equals(s.getWorkspace()));
        }
        return ModificationProxy.createList(matches, StyleInfo.class);
    }

    @Override
    public void dispose() {
        if (this.stores != null) {
            this.stores.clear();
        }
        if (this.defaultStores != null) {
            this.defaultStores.clear();
        }
        if (this.resources != null) {
            this.resources.clear();
        }
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (this.workspaces != null) {
            this.workspaces.clear();
        }
        if (this.layers != null) {
            this.layers.clear();
        }
        if (this.layerGroups != null) {
            this.layerGroups.clear();
        }
        if (this.maps != null) {
            this.maps.clear();
        }
        if (this.styles != null) {
            this.styles.clear();
        }
    }

    @Override
    public void resolve() {
        if (this.workspaces == null) {
            this.workspaces = new CatalogInfoLookup<WorkspaceInfo>(WORKSPACE_NAME_MAPPER);
        }
        for (WorkspaceInfo workspaceInfo : this.workspaces.values()) {
            this.resolve(workspaceInfo);
        }
        if (this.namespaces == null) {
            this.namespaces = new CatalogInfoLookup<NamespaceInfo>(NAMESPACE_NAME_MAPPER);
        }
        for (NamespaceInfo namespaceInfo : this.namespaces.values()) {
            this.resolve(namespaceInfo);
        }
        if (this.stores == null) {
            this.stores = new CatalogInfoLookup<StoreInfo>(STORE_NAME_MAPPER);
        }
        for (CatalogInfo catalogInfo : this.stores.values()) {
            this.resolve((StoreInfoImpl)catalogInfo);
        }
        if (this.styles == null) {
            this.styles = new CatalogInfoLookup<StyleInfo>(STYLE_NAME_MAPPER);
        }
        for (StyleInfo styleInfo : this.styles.values()) {
            this.resolve(styleInfo);
        }
        if (this.resources == null) {
            this.resources = new CatalogInfoLookup<ResourceInfo>(RESOURCE_NAME_MAPPER);
        }
        for (CatalogInfo catalogInfo : this.resources.values()) {
            this.resolve((ResourceInfo)catalogInfo);
        }
        if (this.layers == null) {
            this.layers = new LayerInfoLookup();
        }
        for (LayerInfo layerInfo : this.layers.values()) {
            this.resolve(layerInfo);
        }
        if (this.layerGroups == null) {
            this.layerGroups = new CatalogInfoLookup<LayerGroupInfo>(LAYERGROUP_NAME_MAPPER);
        }
        for (LayerGroupInfo layerGroupInfo : this.layerGroups.values()) {
            this.resolve(layerGroupInfo);
        }
        if (this.maps == null) {
            this.maps = new ArrayList<MapInfo>();
        }
        for (MapInfo mapInfo : this.maps) {
            this.resolve(mapInfo);
        }
    }

    @Override
    public void syncTo(CatalogFacade dao) {
        if ((dao = ProxyUtils.unwrap(dao, LockingCatalogFacade.class)) instanceof DefaultCatalogFacade) {
            DefaultCatalogFacade other = (DefaultCatalogFacade)dao;
            other.stores = this.stores.setCatalog(this.catalog);
            other.defaultStores = this.defaultStores;
            other.resources = this.resources.setCatalog(this.catalog);
            other.defaultNamespace = this.defaultNamespace;
            other.namespaces = this.namespaces.setCatalog(this.catalog);
            other.defaultWorkspace = this.defaultWorkspace;
            other.workspaces = this.workspaces.setCatalog(this.catalog);
            other.layers = this.layers.setCatalog(this.catalog);
            other.maps = this.maps;
            other.layerGroups = this.layerGroups.setCatalog(this.catalog);
            other.styles = this.styles.setCatalog(this.catalog);
        } else {
            for (WorkspaceInfo workspaceInfo : this.workspaces.values()) {
                dao.add(workspaceInfo);
            }
            for (NamespaceInfo namespaceInfo : this.namespaces.values()) {
                dao.add(namespaceInfo);
            }
            for (StoreInfo storeInfo : this.stores.values()) {
                dao.add(storeInfo);
            }
            for (ResourceInfo resourceInfo : this.resources.values()) {
                dao.add(resourceInfo);
            }
            for (StyleInfo styleInfo : this.styles.values()) {
                dao.add(styleInfo);
            }
            for (LayerInfo layerInfo : this.layers.values()) {
                dao.add(layerInfo);
            }
            for (LayerGroupInfo layerGroupInfo : this.layerGroups.values()) {
                dao.add(layerGroupInfo);
            }
            for (MapInfo mapInfo : this.maps) {
                dao.add(mapInfo);
            }
            if (this.defaultWorkspace != null) {
                dao.setDefaultWorkspace(this.defaultWorkspace);
            }
            if (this.defaultNamespace != null) {
                dao.setDefaultNamespace(this.defaultNamespace);
            }
            for (Map.Entry entry : this.defaultStores.entrySet()) {
                WorkspaceInfo ws = this.workspaces.findById((String)entry.getKey(), WorkspaceInfo.class);
                if (null == ws) continue;
                dao.setDefaultDataStore(ws, (DataStoreInfo)entry.getValue());
            }
        }
    }

    @Override
    public <T extends CatalogInfo> int count(Class<T> of, Filter filter) {
        return Iterables.size(this.iterable(of, filter, null));
    }

    @Override
    public boolean canSort(Class<? extends CatalogInfo> type, String propertyName) {
        String[] path = propertyName.split("\\.");
        Class<CatalogInfo> clazz = type;
        for (int i = 0; i < path.length; ++i) {
            Method getter;
            String property = path[i];
            try {
                getter = OwsUtils.getter(clazz, (String)property, null);
            }
            catch (RuntimeException e) {
                return false;
            }
            clazz = getter.getReturnType();
            if (i != path.length - 1) continue;
            boolean primitive = clazz.isPrimitive();
            boolean comparable = Comparable.class.isAssignableFrom(clazz);
            boolean canSort = primitive || comparable;
            return canSort;
        }
        throw new IllegalStateException("empty property name");
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, @Nullable Integer offset, @Nullable Integer count, SortBy ... sortOrder) {
        if (sortOrder != null) {
            for (SortBy so : sortOrder) {
                if (sortOrder == null || this.canSort(of, so.getPropertyName().getPropertyName())) continue;
                throw new IllegalArgumentException("Can't sort objects of type " + of.getName() + " by " + so.getPropertyName());
            }
        }
        Iterable iterable = this.iterable(of, filter, sortOrder);
        if (offset != null && offset > 0) {
            iterable = Iterables.skip(iterable, (int)offset);
        }
        if (count != null && count >= 0) {
            iterable = Iterables.limit((Iterable)iterable, (int)count);
        }
        Iterator<T> iterator = iterable.iterator();
        return new CloseableIteratorAdapter<T>(iterator);
    }

    public <T extends CatalogInfo> Iterable<T> iterable(Class<T> of, Filter filter, SortBy[] sortByList) {
        ArrayList<MapInfo> all;
        if (NamespaceInfo.class.isAssignableFrom(of)) {
            all = this.namespaces.list(of, this.toPredicate(filter));
        } else if (WorkspaceInfo.class.isAssignableFrom(of)) {
            all = this.workspaces.list(of, this.toPredicate(filter));
        } else if (StoreInfo.class.isAssignableFrom(of)) {
            all = this.stores.list(of, this.toPredicate(filter));
        } else if (ResourceInfo.class.isAssignableFrom(of)) {
            all = this.resources.list(of, this.toPredicate(filter));
        } else if (LayerInfo.class.isAssignableFrom(of)) {
            all = this.layers.list(of, this.toPredicate(filter));
        } else if (LayerGroupInfo.class.isAssignableFrom(of)) {
            all = this.layerGroups.list(of, this.toPredicate(filter));
        } else if (PublishedInfo.class.isAssignableFrom(of)) {
            all = new ArrayList<T>();
            all.addAll(this.layers.list(LayerInfo.class, this.toPredicate(filter)));
            all.addAll(this.layerGroups.list(LayerGroupInfo.class, this.toPredicate(filter)));
        } else if (StyleInfo.class.isAssignableFrom(of)) {
            all = this.styles.list(of, this.toPredicate(filter));
        } else if (MapInfo.class.isAssignableFrom(of)) {
            all = new ArrayList<MapInfo>(this.maps);
        } else {
            throw new IllegalArgumentException("Unknown type: " + of);
        }
        if (null != sortByList) {
            for (int i = sortByList.length - 1; i >= 0; --i) {
                SortBy sortBy = sortByList[i];
                Ordering ordering = Ordering.from(this.comparator(sortBy));
                if (SortOrder.DESCENDING.equals((Object)sortBy.getSortOrder())) {
                    ordering = ordering.reverse();
                }
                all = ordering.sortedCopy(all);
            }
        }
        return ModificationProxy.createList(all, of);
    }

    private <T> Predicate<T> toPredicate(Filter filter) {
        if (filter != null && filter != Filter.INCLUDE) {
            return o -> filter.evaluate(o);
        }
        return CatalogInfoLookup.TRUE;
    }

    private Comparator<Object> comparator(final SortBy sortOrder) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object v1 = OwsUtils.get((Object)o1, (String)sortOrder.getPropertyName().getPropertyName());
                Object v2 = OwsUtils.get((Object)o2, (String)sortOrder.getPropertyName().getPropertyName());
                if (v1 == null) {
                    if (v2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                Comparable c1 = (Comparable)v1;
                Comparable c2 = (Comparable)v2;
                return c1.compareTo(c2);
            }
        };
    }

    static final class LayerInfoLookup
    extends CatalogInfoLookup<LayerInfo> {
        public LayerInfoLookup() {
            super(LAYER_NAME_MAPPER);
        }

        @Override
        public void update(ResourceInfo proxiedValue) {
            Map nameMap;
            LayerInfo value;
            Name newName;
            ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(proxiedValue);
            ResourceInfo actualValue = (ResourceInfo)h.getProxyObject();
            Name oldName = RESOURCE_NAME_MAPPER.apply(actualValue);
            if (!oldName.equals((Object)(newName = RESOURCE_NAME_MAPPER.apply(proxiedValue))) && (value = (LayerInfo)(nameMap = this.getMapForValue(this.nameMultiMap, LayerInfoImpl.class)).remove(oldName)) != null) {
                nameMap.put(newName, value);
            }
        }

        @Override
        public LayerInfoLookup setCatalog(Catalog catalog) {
            super.setCatalog(catalog);
            return this;
        }
    }
}

