/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ValidationResult {
    private final List<RuntimeException> errorList;

    public ValidationResult(List<RuntimeException> errors) {
        this.errorList = errors == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<RuntimeException>(errors));
    }

    public boolean isValid() {
        return this.errorList.isEmpty();
    }

    public void throwIfInvalid() {
        if (!this.isValid()) {
            int n = this.errorList.size();
            String msg = this.errorList.get(0).getMessage();
            throw new RuntimeException("Validation failed with " + n + " errors.  First error message is: " + msg);
        }
    }

    public List<RuntimeException> getErrors() {
        return this.errorList;
    }

    public String getErrosAsString(String separator) {
        return this.errorList.stream().map(Throwable::getMessage).collect(Collectors.joining(separator));
    }
}

