/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.media.jai.ImageLayout;
import org.geoserver.catalog.StructuredSingleGridCoverage2DReader;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class SingleGridCoverage2DReader
implements GridCoverage2DReader {
    protected GridCoverage2DReader delegate;
    protected String coverageName;

    public static SingleGridCoverage2DReader wrap(GridCoverage2DReader delegate, String coverageName) {
        if (delegate instanceof StructuredGridCoverage2DReader) {
            return new StructuredSingleGridCoverage2DReader((StructuredGridCoverage2DReader)delegate, coverageName);
        }
        return new SingleGridCoverage2DReader(delegate, coverageName);
    }

    public SingleGridCoverage2DReader(GridCoverage2DReader delegate, String coverageName) {
        if (delegate == null) {
            throw new IllegalArgumentException("The delegate coverage reader cannot be null");
        }
        this.delegate = delegate;
        if (coverageName == null) {
            throw new IllegalArgumentException("The coverage name must be specified");
        }
        this.coverageName = coverageName;
    }

    protected void checkCoverageName(String coverageName) {
        if (!this.coverageName.equals(coverageName)) {
            throw new IllegalArgumentException("Unknown coverage named " + coverageName + ", the only valid value is: " + this.coverageName);
        }
    }

    public Format getFormat() {
        return this.delegate.getFormat();
    }

    public Object getSource() {
        return this.delegate.getSource();
    }

    public String[] getMetadataNames() throws IOException {
        return this.delegate.getMetadataNames(this.coverageName);
    }

    public String[] getMetadataNames(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataNames(coverageName);
    }

    public String getMetadataValue(String name) throws IOException {
        return this.delegate.getMetadataValue(this.coverageName, name);
    }

    public String getMetadataValue(String coverageName, String name) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataValue(coverageName, name);
    }

    public void dispose() throws IOException {
        this.delegate.dispose();
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.delegate.getOriginalEnvelope(this.coverageName);
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalEnvelope(coverageName);
    }

    public GridEnvelope getOriginalGridRange() {
        return this.delegate.getOriginalGridRange(this.coverageName);
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridRange(coverageName);
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.delegate.getOriginalGridToWorld(this.coverageName, pixInCell);
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridToWorld(coverageName, pixInCell);
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        return this.delegate.read(this.coverageName, parameters);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.read(coverageName, parameters);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.delegate.getCoordinateReferenceSystem(this.coverageName);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getCoordinateReferenceSystem(coverageName);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.delegate.getDynamicParameters(this.coverageName);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getDynamicParameters(coverageName);
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.delegate.getReadingResolutions(this.coverageName, policy, requestedResolution);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getReadingResolutions(coverageName, policy, requestedResolution);
    }

    public String[] getGridCoverageNames() throws IOException {
        return new String[]{this.coverageName};
    }

    public int getGridCoverageCount() throws IOException {
        return this.delegate.getGridCoverageCount();
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.delegate.getImageLayout(this.coverageName);
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getImageLayout(coverageName);
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.delegate.getResolutionLevels(this.coverageName);
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getResolutionLevels(coverageName);
    }

    public DatasetLayout getDatasetLayout() {
        return this.delegate.getDatasetLayout();
    }

    public DatasetLayout getDatasetLayout(String coverageName) {
        return this.delegate.getDatasetLayout(coverageName);
    }

    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public ResourceInfo getInfo(String coverageName) {
        return this.delegate.getInfo(coverageName);
    }
}

