/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.GeoServerSLDVisitorAdapter;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.platform.ServiceException;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;

public class SLDNamedLayerRenameHelper {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    protected boolean applied = false;
    protected boolean skipErrors = false;
    Map<String, String> renamedLayers = new HashMap<String, String>();
    Map<String, String> renamedLayerGroups = new HashMap<String, String>();
    Map<String, String> renamedStyles = new HashMap<String, String>();
    Catalog catalog;

    public SLDNamedLayerRenameHelper(Catalog catalog) {
        this.catalog = catalog;
    }

    public SLDNamedLayerRenameHelper(Catalog catalog, boolean skipErrors) {
        this.catalog = catalog;
        this.skipErrors = skipErrors;
    }

    public static List<StyleInfo> getOrUpdateStylesToRename(Catalog catalog, CatalogInfo updatedInfo, boolean doRename) throws IOException {
        String oldName = "";
        String newName = "";
        SLDNamedLayerRenameHelper helper = new SLDNamedLayerRenameHelper(catalog);
        if (updatedInfo instanceof StyleInfo) {
            StyleInfo oldInfo = catalog.getStyle(updatedInfo.getId());
            oldName = oldInfo.getName();
            newName = ((StyleInfo)updatedInfo).getName();
            helper.registerStyleRename(oldName, newName);
        } else if (updatedInfo instanceof LayerInfo) {
            LayerInfo oldInfo = catalog.getLayer(updatedInfo.getId());
            oldName = oldInfo.getName();
            newName = ((LayerInfo)updatedInfo).getName();
            helper.registerLayerRename(oldName, newName);
        } else if (updatedInfo instanceof LayerGroupInfo) {
            LayerInfo oldInfo = catalog.getLayer(updatedInfo.getId());
            oldName = ((LayerGroupInfo)((Object)oldInfo)).getName();
            newName = ((LayerGroupInfo)updatedInfo).getName();
            helper.registerLayerGroupRename(oldName, newName);
        }
        if (newName.equals(oldName)) {
            return new ArrayList<StyleInfo>();
        }
        return helper.visitStyles(doRename);
    }

    public void registerLayerRename(String oldName, String newName) {
        this.renamedLayers.put(oldName, newName);
    }

    public void registerLayerGroupRename(String oldName, String newName) {
        this.renamedLayerGroups.put(oldName, newName);
    }

    public void registerStyleRename(String oldName, String newName) {
        this.renamedStyles.put(oldName, newName);
    }

    public List<StyleInfo> visitStyles(boolean doRename) throws IOException {
        ArrayList<StyleInfo> stylesToUpdate = new ArrayList<StyleInfo>();
        for (StyleInfo style : this.catalog.getStyles()) {
            SLDNamedLayerRenameVisitor visitor = new SLDNamedLayerRenameVisitor(this.catalog, doRename);
            try {
                StyledLayerDescriptor sld = this.catalog.getResourcePool().getSld(style);
                sld.accept((StyleVisitor)visitor);
                if (!visitor.needsRename) continue;
                stylesToUpdate.add(style);
                if (!doRename) continue;
                this.backupStyle(style);
                this.catalog.getResourcePool().writeSLD(style, sld, true);
            }
            catch (IOException | ServiceException e) {
                if (this.skipErrors) {
                    LOGGER.log(Level.INFO, "Skipping style '" + style.getName() + "'.", e);
                    continue;
                }
                throw e;
            }
        }
        return stylesToUpdate;
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION", "NP_NULL_PARAM_DEREF"})
    StyleInfo backupStyle(StyleInfo s) throws IOException {
        StyleInfo backup = this.catalog.getFactory().createStyle();
        new CatalogBuilder(this.catalog).updateStyle(backup, s);
        backup.setWorkspace(s.getWorkspace());
        String name = this.findUniqueStyleName(s.getWorkspace() == null ? null : s.getWorkspace().getName(), s.getName() + "_BACKUP");
        backup.setName(name);
        backup.setFilename(name + "." + FilenameUtils.getExtension((String)s.getFilename()));
        try (BufferedReader reader = this.catalog.getResourcePool().readStyle(s);){
            this.catalog.getResourcePool().writeStyle(backup, new ByteArrayInputStream(IOUtils.toByteArray((Reader)reader, (String)"UTF-8")));
        }
        return backup;
    }

    String findUniqueStyleName(String workspace, String name) {
        StyleInfo style = this.catalog.getStyleByName(workspace, name);
        if (style == null) {
            return name;
        }
        String styleName = null;
        int i = 1;
        while (style != null) {
            styleName = name + i;
            style = this.catalog.getStyleByName(workspace, styleName);
            ++i;
        }
        return styleName;
    }

    private class SLDNamedLayerRenameVisitor
    extends GeoServerSLDVisitorAdapter {
        boolean doRename;
        boolean needsRename;

        public SLDNamedLayerRenameVisitor(Catalog catalog, boolean doRename) {
            super(catalog, null);
            this.doRename = false;
            this.needsRename = false;
            this.doRename = doRename;
        }

        @Override
        public PublishedInfo visitNamedLayerInternal(StyledLayer namedLayer) {
            String layerName = namedLayer.getName();
            PublishedInfo p = this.catalog.getLayerGroupByName(layerName);
            if (p != null) {
                p = this.catalog.getLayerByName(layerName);
            }
            if (SLDNamedLayerRenameHelper.this.renamedLayerGroups.get(layerName) != null) {
                this.needsRename = true;
                if (this.doRename) {
                    namedLayer.setName(SLDNamedLayerRenameHelper.this.renamedLayerGroups.get(layerName));
                }
            } else if (SLDNamedLayerRenameHelper.this.renamedLayers.get(layerName) != null) {
                this.needsRename = true;
                if (this.doRename) {
                    namedLayer.setName(SLDNamedLayerRenameHelper.this.renamedLayers.get(layerName));
                }
            }
            return p;
        }

        @Override
        public StyleInfo visitNamedStyleInternal(NamedStyle namedStyle) {
            String styleName = namedStyle.getName();
            StyleInfo s = this.catalog.getStyleByName(styleName);
            if (SLDNamedLayerRenameHelper.this.renamedStyles.get(styleName) != null) {
                this.needsRename = true;
                if (this.doRename) {
                    namedStyle.setName(SLDNamedLayerRenameHelper.this.renamedStyles.get(styleName));
                }
            }
            return s;
        }
    }
}

