/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.impl.ProxyUtils;
import org.geoserver.catalog.impl.WrappingProxy;

public class LockingCatalogFacade
implements InvocationHandler,
WrappingProxy {
    GeoServerConfigurationLock configurationLock;
    CatalogFacade delegate;

    public LockingCatalogFacade(CatalogFacade delegate, GeoServerConfigurationLock configurationLock) {
        this.configurationLock = configurationLock;
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        GeoServerConfigurationLock.LockType lockType = this.configurationLock.getCurrentLock();
        if (lockType == GeoServerConfigurationLock.LockType.READ && this.isWriteMethod(method)) {
            this.configurationLock.tryUpgradeLock();
        }
        return method.invoke((Object)this.delegate, args);
    }

    private boolean isWriteMethod(Method method) {
        String name = method.getName();
        return name.startsWith("set") || name.startsWith("remove") || name.startsWith("add") || name.startsWith("save");
    }

    public static CatalogFacade create(CatalogFacade facade, GeoServerConfigurationLock configurationLock) {
        return ProxyUtils.createProxy(facade, CatalogFacade.class, new LockingCatalogFacade(facade, configurationLock));
    }

    @Override
    public Object getProxyObject() {
        return this.delegate;
    }
}

