/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.GeoServerSLDVisitor;
import org.geoserver.catalog.GeoServerSLDVisitorAdapter;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class LayerGroupHelper {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    private LayerGroupInfo group;

    public LayerGroupHelper(LayerGroupInfo group) {
        this.group = group;
    }

    public List<LayerInfo> allLayers() {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        LayerGroupHelper.allLayers(this.group, layers);
        return layers;
    }

    private static void allLayers(LayerGroupInfo group, List<LayerInfo> layers) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            layers.add(group.getRootLayer());
        }
        int size = group.getLayers().size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = group.getLayers().get(i);
            StyleInfo s = group.getStyles() == null || group.getStyles().size() == 0 ? null : group.getStyles().get(i);
            if (p instanceof LayerInfo) {
                LayerInfo l = (LayerInfo)p;
                layers.add(l);
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                LayerGroupHelper.allLayers((LayerGroupInfo)p, layers);
                continue;
            }
            if (p != null || s == null) continue;
            LayerGroupHelper.expandStyleGroup(s, group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem(), layers, null);
        }
    }

    public List<PublishedInfo> allPublished() {
        ArrayList<PublishedInfo> publisheds = new ArrayList<PublishedInfo>();
        this.allPublished(this.group, publisheds);
        return publisheds;
    }

    private List<PublishedInfo> allPublished(LayerGroupInfo group, List<PublishedInfo> publisheds) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            publisheds.add(group.getRootLayer());
        }
        int size = group.getLayers().size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = group.getLayers().get(i);
            StyleInfo s = group.getStyles() == null || group.getStyles().size() == 0 ? null : group.getStyles().get(i);
            if (p instanceof LayerInfo) {
                LayerInfo l = (LayerInfo)p;
                publisheds.add(l);
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                publisheds.add(p);
                continue;
            }
            if (p != null || s == null) continue;
            ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
            LayerGroupHelper.expandStyleGroup(s, group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem(), layers, null);
            publisheds.addAll(layers);
        }
        return publisheds;
    }

    public List<LayerGroupInfo> allGroups() {
        ArrayList<LayerGroupInfo> groups = new ArrayList<LayerGroupInfo>();
        LayerGroupHelper.allGroups(this.group, groups);
        return groups;
    }

    private static void allGroups(LayerGroupInfo group, List<LayerGroupInfo> groups) {
        groups.add(group);
        for (PublishedInfo p : group.getLayers()) {
            if (!(p instanceof LayerGroupInfo)) continue;
            LayerGroupInfo g = (LayerGroupInfo)p;
            LayerGroupHelper.allGroups(g, groups);
        }
    }

    public List<StyleInfo> allStyles() {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        LayerGroupHelper.allStyles(this.group, styles);
        return styles;
    }

    private static void allStyles(LayerGroupInfo group, List<StyleInfo> styles) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            styles.add(group.getRootLayerStyle());
        }
        int size = group.getLayers().size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = group.getLayers().get(i);
            StyleInfo s = group.getStyles().get(i);
            if (p instanceof LayerInfo) {
                styles.add(group.getStyles().get(i));
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                LayerGroupHelper.allStyles((LayerGroupInfo)p, styles);
                continue;
            }
            if (p != null || s == null) continue;
            LayerGroupHelper.expandStyleGroup(s, group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem(), null, styles);
        }
    }

    public List<LayerInfo> allLayersForRendering() {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        LayerGroupHelper.allLayersForRendering(this.group, layers, true);
        return layers;
    }

    private static void allLayersForRendering(LayerGroupInfo group, List<LayerInfo> layers, boolean root) {
        switch (group.getMode()) {
            case EO: {
                layers.add(group.getRootLayer());
                break;
            }
            case CONTAINER: {
                if (root) {
                    throw new UnsupportedOperationException("LayerGroup mode " + LayerGroupInfo.Mode.CONTAINER.getName() + " can not be rendered");
                }
            }
            default: {
                int size = group.getLayers().size();
                for (int i = 0; i < size; ++i) {
                    PublishedInfo p = group.getLayers().get(i);
                    StyleInfo s = group.getStyles().get(i);
                    if (p instanceof LayerInfo) {
                        LayerInfo l = (LayerInfo)p;
                        layers.add(l);
                        continue;
                    }
                    if (p instanceof LayerGroupInfo) {
                        LayerGroupHelper.allLayersForRendering((LayerGroupInfo)p, layers, false);
                        continue;
                    }
                    if (p != null || s == null) continue;
                    LayerGroupHelper.expandStyleGroup(s, group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem(), layers, null);
                }
            }
        }
    }

    public List<StyleInfo> allStylesForRendering() {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        LayerGroupHelper.allStylesForRendering(this.group, styles, true);
        return styles;
    }

    private static void allStylesForRendering(LayerGroupInfo group, List<StyleInfo> styles, boolean root) {
        switch (group.getMode()) {
            case EO: {
                styles.add(group.getRootLayerStyle());
                break;
            }
            case CONTAINER: {
                if (root) {
                    throw new UnsupportedOperationException("LayerGroup mode " + LayerGroupInfo.Mode.CONTAINER.getName() + " can not be rendered");
                }
            }
            default: {
                int size = group.getLayers().size();
                for (int i = 0; i < size; ++i) {
                    PublishedInfo p = group.getLayers().get(i);
                    StyleInfo s = group.getStyles().get(i);
                    if (p instanceof LayerInfo) {
                        StyleInfo styleInfo = group.getStyles().get(i);
                        if (((LayerInfo)p).getResource() instanceof WMSLayerInfo) {
                            WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)((LayerInfo)p).getResource();
                            styleInfo = LayerGroupHelper.getRemoteWmsLayerStyle(wmsLayerInfo, styleInfo);
                        }
                        styles.add(styleInfo);
                        continue;
                    }
                    if (p instanceof LayerGroupInfo) {
                        LayerGroupHelper.allStylesForRendering((LayerGroupInfo)p, styles, false);
                        continue;
                    }
                    if (p != null || s == null) continue;
                    LayerGroupHelper.expandStyleGroup(s, group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem(), null, styles);
                }
            }
        }
    }

    public void calculateBounds(CoordinateReferenceSystem crs) throws Exception {
        List<LayerInfo> layers = this.allLayers();
        if (layers.isEmpty()) {
            return;
        }
        LayerInfo l = layers.get(0);
        ReferencedEnvelope bounds = new ReferencedEnvelope(crs);
        for (int i = 0; i < layers.size(); ++i) {
            l = layers.get(i);
            bounds.expandToInclude((Envelope)LayerGroupHelper.transform(l.getResource().getLatLonBoundingBox(), crs));
        }
        this.group.setBounds(bounds);
    }

    public void calculateBoundsFromCRS(CoordinateReferenceSystem crs) {
        org.opengis.geometry.Envelope crsEnvelope = CRS.getEnvelope((CoordinateReferenceSystem)crs);
        if (crsEnvelope != null) {
            ReferencedEnvelope refEnvelope = new ReferencedEnvelope(crsEnvelope);
            this.group.setBounds(refEnvelope);
        } else {
            this.group.setBounds(null);
        }
    }

    public void calculateBounds() throws Exception {
        List<LayerInfo> layers = this.allLayers();
        if (layers.isEmpty()) {
            return;
        }
        LayerInfo l = layers.get(0);
        ReferencedEnvelope bounds = l.getResource().boundingBox();
        boolean latlon = false;
        if (bounds == null) {
            bounds = l.getResource().getLatLonBoundingBox();
            latlon = true;
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
        }
        for (int i = 1; i < layers.size(); ++i) {
            ReferencedEnvelope re;
            l = layers.get(i);
            ResourceInfo resource = l.getResource();
            if (latlon) {
                re = resource.getLatLonBoundingBox();
            } else {
                re = resource.boundingBox();
                if (re == null) {
                    re = resource.getLatLonBoundingBox();
                }
            }
            re = LayerGroupHelper.transform(re, bounds.getCoordinateReferenceSystem());
            if (re == null) {
                throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
            }
            bounds.expandToInclude((Envelope)re);
        }
        this.group.setBounds(bounds);
    }

    private static ReferencedEnvelope transform(ReferencedEnvelope e, CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)e.getCoordinateReferenceSystem())) {
            return e.transform(crs, true);
        }
        return e;
    }

    public Stack<LayerGroupInfo> checkLoops() {
        Stack<LayerGroupInfo> path = new Stack<LayerGroupInfo>();
        if (LayerGroupHelper.checkLoops(this.group, path)) {
            return path;
        }
        return null;
    }

    public String getLoopAsString(Stack<LayerGroupInfo> path) {
        if (path == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (LayerGroupInfo g : path) {
            s.append("/").append(g.getName());
        }
        return s.toString();
    }

    private static boolean checkLoops(LayerGroupInfo group, Stack<LayerGroupInfo> path) {
        path.push(group);
        if (group.getLayers() != null) {
            int size = group.getLayers().size();
            for (int i = 0; i < size; ++i) {
                PublishedInfo child = group.getLayers().get(i);
                StyleInfo s = group.getStyles() == null || group.getStyles().size() == 0 ? null : group.getStyles().get(i);
                if (child instanceof LayerGroupInfo) {
                    if (LayerGroupHelper.isGroupInStack((LayerGroupInfo)child, path)) {
                        path.push((LayerGroupInfo)child);
                        return true;
                    }
                    if (!LayerGroupHelper.checkLoops((LayerGroupInfo)child, path)) continue;
                    return true;
                }
                if (child != null || s == null || !LayerGroupHelper.checkStyleGroupLoops(s, group, path)) continue;
                return true;
            }
        }
        path.pop();
        return false;
    }

    private static boolean checkStyleGroupLoops(StyleInfo styleGroup, final LayerGroupInfo group, final Stack<LayerGroupInfo> path) {
        try {
            StyledLayerDescriptor sld = styleGroup.getSLD();
            final boolean[] hasLoop = new boolean[]{false};
            sld.accept((StyleVisitor)new GeoServerSLDVisitorAdapter((Catalog)GeoServerExtensions.bean((String)"catalog"), group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem()){
                private final IllegalStateException recursionException;
                {
                    super(catalog, fallbackCrs);
                    this.recursionException = new IllegalStateException("Style group contains recursive structure");
                }

                @Override
                public void visit(StyledLayerDescriptor sld) {
                    try {
                        super.visit(sld);
                    }
                    catch (IllegalStateException e) {
                        if (this.recursionException.equals(e)) {
                            hasLoop[0] = true;
                        }
                        throw e;
                    }
                }

                @Override
                public PublishedInfo visitNamedLayerInternal(StyledLayer namedLayer) {
                    if (namedLayer.getName() != null && namedLayer.getName().equals(group.getName())) {
                        throw this.recursionException;
                    }
                    LayerGroupInfo child = this.catalog.getLayerGroupByName(namedLayer.getName());
                    if (child != null) {
                        if (LayerGroupHelper.isGroupInStack(child, path)) {
                            path.push(child);
                            throw this.recursionException;
                        }
                        if (LayerGroupHelper.checkLoops(child, path)) {
                            throw this.recursionException;
                        }
                        return child;
                    }
                    return null;
                }
            });
            return hasLoop[0];
        }
        catch (IOException | UncheckedIOException | IllegalStateException | UnsupportedOperationException | ServiceException e) {
            LOGGER.log(Level.WARNING, "Error extracting layers from Style Group '" + styleGroup.getName() + "'. Skipping...", e);
            return false;
        }
    }

    private static boolean isGroupInStack(LayerGroupInfo group, Stack<LayerGroupInfo> path) {
        for (LayerGroupInfo groupInPath : path) {
            if (groupInPath.getId() == null || !groupInPath.getId().equals(group.getId())) continue;
            return true;
        }
        return false;
    }

    private static void expandStyleGroup(StyleInfo styleGroup, CoordinateReferenceSystem crs, List<LayerInfo> layers, List<StyleInfo> styles) {
        if (layers == null) {
            layers = new ArrayList<LayerInfo>();
        }
        if (styles == null) {
            styles = new ArrayList<StyleInfo>();
        }
        try {
            StyledLayerDescriptor sld = styleGroup.getSLD();
            StyleGroupHelper helper = new StyleGroupHelper((Catalog)GeoServerExtensions.bean((String)"catalog"), crs);
            sld.accept((StyleVisitor)helper);
            layers.addAll(helper.getLayers());
            styles.addAll(helper.getStyles());
        }
        catch (IOException | UncheckedIOException | IllegalStateException | UnsupportedOperationException | ServiceException e) {
            LOGGER.log(Level.WARNING, "Error extracting styles from Style Group '" + styleGroup.getName() + "'. Skipping...", e);
        }
    }

    private static StyleInfo getRemoteWmsLayerStyle(WMSLayerInfo wmsLayerInfo, StyleInfo styleInfo) {
        if (styleInfo == null) {
            styleInfo = wmsLayerInfo.getDefaultStyle();
        } else if (!wmsLayerInfo.findRemoteStyleByName(styleInfo.getName()).isPresent()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(styleInfo.getName() + " style is not a known remote style for WMS Layer " + wmsLayerInfo + ", Re-configure the Resource");
            }
            styleInfo = WMSLayerInfoImpl.DEFAULT_ON_REMOTE;
        }
        return styleInfo;
    }

    protected static class StyleGroupHelper
    extends GeoServerSLDVisitorAdapter {
        List<LayerInfo> layers;
        List<StyleInfo> styles;

        public StyleGroupHelper(Catalog catalog, CoordinateReferenceSystem fallbackCrs) {
            super(catalog, fallbackCrs);
        }

        @Override
        public void visit(StyledLayerDescriptor sld) {
            this.layers = new ArrayList<LayerInfo>();
            this.styles = new ArrayList<StyleInfo>();
            super.visit(sld);
        }

        public List<LayerInfo> getLayers() {
            return this.layers;
        }

        public List<StyleInfo> getStyles() {
            return this.styles;
        }

        @Override
        public PublishedInfo visitNamedLayerInternal(StyledLayer namedLayer) {
            PublishedInfo p = this.catalog.getLayerGroupByName(namedLayer.getName());
            if (p == null && (p = this.catalog.getLayerByName(namedLayer.getName())) == null) {
                throw new ServiceException("No layer or layer group with name \"" + namedLayer.getName() + "\"");
            }
            return p;
        }

        @Override
        public StyleInfo visitNamedStyleInternal(NamedStyle namedStyle) {
            StyleInfo s = this.catalog.getStyleByName(namedStyle.getName());
            this.layers.add((LayerInfo)this.info);
            this.styles.add(s);
            return s;
        }

        @Override
        public void visitUserStyleInternal(Style userStyle) {
            this.layers.add((LayerInfo)this.info);
            GeoServerSLDVisitor.StyleWrappingStyleInfoImpl style = new GeoServerSLDVisitor.StyleWrappingStyleInfoImpl(userStyle);
            style.setCatalog(this.catalog);
            this.styles.add(style);
        }
    }
}

