/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ColorModelFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.operator.ConstantDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewHandler;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geoserver.catalog.StructuredCoverageViewReader;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.FilterFactory2;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoverageViewReader
implements GridCoverage2DReader {
    private static final int HETEROGENEOUS_RASTER_GUTTER = 10;
    public static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Logger LOGGER = Logging.getLogger(CoverageViewReader.class);
    CoverageView coverageView;
    private CoverageViewHandler handler;
    boolean canSupportHeterogeneousCoverages = false;
    String referenceName;
    private String coverageName;
    private GridCoverage2DReader delegate;
    private Hints hints;
    private GridCoverageFactory coverageFactory;
    private ImageLayout imageLayout;

    public CoverageViewReader(GridCoverage2DReader delegate, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        Object factory;
        this.coverageName = coverageView.getName();
        this.delegate = delegate;
        this.coverageView = coverageView;
        this.hints = hints;
        this.referenceName = coverageView.getBand(0).getInputCoverageBands().get(0).getCoverageName();
        this.canSupportHeterogeneousCoverages = JAIExt.isJAIExtOperation((String)"BandMerge");
        this.handler = new CoverageViewHandler(this.canSupportHeterogeneousCoverages, delegate, this.referenceName, coverageView);
        if (this.hints != null && this.hints.containsKey((Object)Hints.GRID_COVERAGE_FACTORY) && (factory = this.hints.get((Object)Hints.GRID_COVERAGE_FACTORY)) != null && factory instanceof GridCoverageFactory) {
            this.coverageFactory = (GridCoverageFactory)factory;
        }
        if (this.coverageFactory == null) {
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        }
        try {
            ImageLayout layout = delegate.getImageLayout(this.referenceName);
            SampleModel originalSampleModel = layout.getSampleModel(null);
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)originalSampleModel.getDataType(), (int)originalSampleModel.getWidth(), (int)originalSampleModel.getHeight(), (int)coverageView.getCoverageBands().size());
            ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
            this.imageLayout = new ImageLayout2(layout.getMinX(null), layout.getMinY(null), originalSampleModel.getWidth(), originalSampleModel.getHeight());
            this.imageLayout.setSampleModel(sampleModel);
            this.imageLayout.setColorModel(colorModel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        GridCoverage2D result;
        int index;
        Optional<Object> ggParameter = Optional.empty();
        if (parameters != null) {
            ggParameter = Arrays.stream(parameters).filter(parameter -> parameter.getDescriptor().getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())).findFirst();
        }
        GridGeometry2D requestedGridGeometry = null;
        if (ggParameter.isPresent()) {
            ReferencedEnvelope dataEnvelope;
            ParameterValue value = (ParameterValue)ggParameter.get();
            requestedGridGeometry = (GridGeometry2D)value.getValue();
            ReferencedEnvelope requestedEnvelope = ReferencedEnvelope.reference((Envelope)requestedGridGeometry.getEnvelope());
            if (CRS.equalsIgnoreMetadata((Object)requestedEnvelope, (Object)(dataEnvelope = ReferencedEnvelope.reference((Envelope)this.handler.getOriginalEnvelope())))) {
                if (!requestedEnvelope.intersects((BoundingBox)dataEnvelope)) {
                    return null;
                }
            } else {
                try {
                    ReferencedEnvelope re84 = requestedEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                    ReferencedEnvelope de84 = dataEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                    if (!re84.intersects((BoundingBox)de84)) {
                        return null;
                    }
                }
                catch (FactoryException | TransformException e) {
                    LOGGER.log(Level.FINE, "Cannot determine if the requested BBOX intersects the data one, continuing", e);
                }
            }
            if (!this.handler.isHomogeneousCoverages()) {
                GridEnvelope2D range = requestedGridGeometry.getGridRange2D();
                GridEnvelope2D expandedRange = new GridEnvelope2D((int)range.getMinX() - 10, (int)range.getMinY() - 10, (int)range.getWidth() + 20, (int)range.getHeight() + 20);
                GridGeometry2D expandedGG = new GridGeometry2D((GridEnvelope)expandedRange, requestedGridGeometry.getGridToCRS(), requestedGridGeometry.getCoordinateReferenceSystem());
                value.setValue((Object)expandedGG);
            }
        }
        List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
        ArrayList<GridCoverage2D> coverages = new ArrayList<GridCoverage2D>();
        CoverageViewHandler.CoveragesConsistencyChecker checker = null;
        int coverageBandsSize = bands.size();
        ArrayList<Integer> selectedBandIndices = new ArrayList<Integer>();
        for (int m = 0; m < coverageBandsSize; ++m) {
            selectedBandIndices.add(m);
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                int[] bandIndicesParam;
                ParameterValue param = (ParameterValue)parameters[i];
                if (!AbstractGridFormat.BANDS.getName().equals(param.getDescriptor().getName()) || (bandIndicesParam = (int[])param.getValue()) == null) continue;
                selectedBandIndices = new ArrayList();
                for (int bIdx = 0; bIdx < bandIndicesParam.length; ++bIdx) {
                    selectedBandIndices.add(bandIndicesParam[bIdx]);
                }
                break;
            }
        }
        HashMap<String, GridCoverage2D> inputCoverages = new HashMap<String, GridCoverage2D>();
        GridCoverage2D dynamicAlphaSource = null;
        int nonNullCoverages = 0;
        Iterator bIdx = selectedBandIndices.iterator();
        while (bIdx.hasNext()) {
            GridCoverage2D coverage;
            int bIdx2 = (Integer)bIdx.next();
            CoverageView.CoverageBand band = bands.get(bIdx2);
            List<CoverageView.InputCoverageBand> selectedBands = band.getInputCoverageBands();
            String coverageName = selectedBands.get(0).getCoverageName();
            if (inputCoverages.containsKey(coverageName)) continue;
            SingleGridCoverage2DReader reader = SingleGridCoverage2DReader.wrap(this.delegate, coverageName);
            if (checker == null) {
                checker = new CoverageViewHandler.CoveragesConsistencyChecker(reader, this.canSupportHeterogeneousCoverages);
            } else {
                checker.checkConsistency(reader);
            }
            GeneralParameterValue[] filteredParameters = parameters;
            if (parameters != null) {
                filteredParameters = (GeneralParameterValue[])Arrays.stream(parameters).filter(parameter -> !parameter.getDescriptor().getName().equals(AbstractGridFormat.BANDS.getName())).toArray(GeneralParameterValue[]::new);
            }
            if ((coverage = reader.read(filteredParameters)) == null) {
                if (this.handler.isHomogeneousCoverages() || this.handler.getEnvelopeCompositionType() == CoverageView.EnvelopeCompositionType.INTERSECTION) {
                    return null;
                }
            } else {
                ++nonNullCoverages;
            }
            if (dynamicAlphaSource == null && this.hasDynamicAlpha(coverage, reader)) {
                dynamicAlphaSource = coverage;
            }
            inputCoverages.put(coverageName, coverage);
        }
        if (nonNullCoverages == 0 || inputCoverages.isEmpty()) {
            return null;
        }
        if (nonNullCoverages < inputCoverages.size()) {
            float height;
            float width;
            if (requestedGridGeometry != null) {
                GridEnvelope2D range = requestedGridGeometry.getGridRange2D();
                width = (float)range.getWidth();
                height = (float)range.getHeight();
            } else {
                GridCoverage2D reference = inputCoverages.values().stream().filter(c -> c != null).findFirst().get();
                RenderedImage ri = reference.getRenderedImage();
                width = ri.getWidth();
                height = ri.getHeight();
            }
            for (String name : inputCoverages.keySet()) {
                SingleGridCoverage2DReader reader = SingleGridCoverage2DReader.wrap(this.delegate, name);
                ImageLayout layout = reader.getImageLayout();
                int numBands = layout.getSampleModel(null).getNumBands();
                Object[] bandValues = new Number[numBands];
                Arrays.fill(bandValues, (Object)0.0);
                ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])bandValues, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
        }
        ArrayList<CoverageView.CoverageBand> mergedBands = new ArrayList<CoverageView.CoverageBand>();
        CoverageView.CoverageBand mBand = null;
        for (int idx = 0; idx < selectedBandIndices.size(); ++idx) {
            if (mBand == null) {
                mBand = new CoverageView.CoverageBand();
                mBand.setInputCoverageBands(bands.get((Integer)selectedBandIndices.get(idx)).getInputCoverageBands());
            }
            String coverageName = bands.get((Integer)selectedBandIndices.get(idx)).getInputCoverageBands().get(0).getCoverageName();
            if (idx + 1 < selectedBandIndices.size() && bands.get((Integer)selectedBandIndices.get(idx + 1)).getInputCoverageBands().get(0).getCoverageName().equals(coverageName)) {
                ArrayList<CoverageView.InputCoverageBand> groupBands = new ArrayList<CoverageView.InputCoverageBand>();
                groupBands.addAll(mBand.getInputCoverageBands());
                groupBands.addAll(bands.get((Integer)selectedBandIndices.get(idx + 1)).getInputCoverageBands());
                mBand.setInputCoverageBands(groupBands);
                continue;
            }
            mergedBands.add(mBand);
            mBand = null;
        }
        int transformationChoice = index = 0;
        CoverageViewHandler.CoverageResolutionChooser resolutionChooser = this.handler.getCoverageResolutionChooser();
        for (CoverageView.CoverageBand band : mergedBands) {
            List<CoverageView.InputCoverageBand> selectedBands = band.getInputCoverageBands();
            String coverageName = selectedBands.get(0).getCoverageName();
            ArrayList<Integer> bandIndices = new ArrayList<Integer>(selectedBands.size());
            for (CoverageView.InputCoverageBand icb : selectedBands) {
                int bandIdx = 0;
                String bandString = icb.getBand();
                if (bandString != null && !bandString.isEmpty()) {
                    bandIdx = Integer.parseInt(bandString);
                }
                bandIndices.add(bandIdx);
            }
            GridCoverage2D coverage = (GridCoverage2D)inputCoverages.get(coverageName);
            Hints localHints = new Hints((RenderingHints)this.hints);
            if (dynamicAlphaSource != null && mergedBands.size() == 1 && (bandIndices.size() == 1 || bandIndices.size() == 3)) {
                int alphaBandIndex = this.getAlphaBandIndex(coverage);
                this.addAlphaColorModelHint(localHints, bandIndices.size());
                bandIndices.add(alphaBandIndex);
            }
            coverage = this.retainBands(bandIndices, coverage, localHints);
            if (mergedBands.size() > 1) {
                coverage = this.prepareForBandMerge(coverage);
            }
            coverages.add(coverage);
            if (resolutionChooser.visit(coverage)) {
                transformationChoice = index;
            }
            ++index;
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Read coverage " + coverageName + ", result has envelope " + coverage.getEnvelope2D());
        }
        if (coverages.size() > 1) {
            int currentBandCount;
            Hints localHints = new Hints((RenderingHints)this.hints);
            if (dynamicAlphaSource != null && ((currentBandCount = this.countBands(coverages)) == 1 || currentBandCount == 3)) {
                int alphaBandIndex = this.getAlphaBandIndex(dynamicAlphaSource);
                GridCoverage2D alphaBandCoverage = this.retainBands(Arrays.asList(alphaBandIndex), dynamicAlphaSource, this.hints);
                coverages.add(alphaBandCoverage);
                this.addAlphaColorModelHint(localHints, currentBandCount);
            }
            String operationName = "BandMerge";
            ParameterValueGroup param = PROCESSOR.getOperation(operationName).getParameters();
            if (!this.handler.isHomogeneousCoverages()) {
                param.parameter("transform_choice").setValue((Object)"index");
                param.parameter("coverage_idx").setValue(transformationChoice);
            }
            param.parameter("sources").setValue(coverages);
            localHints.put((Object)JAI.KEY_COLOR_MODEL_FACTORY, (Object)new ColorModelFactory(){

                public ColorModel createColorModel(SampleModel sampleModel, List sources, Map configuration) {
                    ColorSpace cs;
                    int dataType = sampleModel.getDataType();
                    int numBands = sampleModel.getNumBands();
                    switch (numBands) {
                        case 1: 
                        case 2: {
                            cs = ColorSpace.getInstance(1003);
                            break;
                        }
                        case 3: {
                            cs = ColorSpace.getInstance(1000);
                            break;
                        }
                        default: {
                            cs = new BogusColorSpace(numBands);
                        }
                    }
                    return RasterFactory.createComponentColorModel((int)dataType, (ColorSpace)cs, (boolean)false, (boolean)false, (int)1);
                }
            });
            result = (GridCoverage2D)PROCESSOR.doOperation(param, localHints);
        } else {
            result = (GridCoverage2D)coverages.get(0);
        }
        return result;
    }

    private GridCoverage2D prepareForBandMerge(GridCoverage2D coverage) {
        RenderedImage ri = coverage.getRenderedImage();
        SampleModel sampleModel = ri.getSampleModel();
        if (sampleModel.getNumBands() == 1 && ri.getColorModel() instanceof IndexColorModel) {
            ImageWorker worker = new ImageWorker(ri);
            worker.removeIndexColorModel();
            RenderedImage formatted = worker.getRenderedImage();
            return new GridCoverageFactory().create((CharSequence)coverage.getName(), formatted, coverage.getGridGeometry(), coverage.getSampleDimensions(), new GridCoverage[]{coverage}, coverage.getProperties());
        }
        return coverage;
    }

    private void addAlphaColorModelHint(Hints localHints, int currentBandCount) {
        ImageLayout layout = new ImageLayout();
        ColorModel alphaModel = this.getColorModelWithAlpha(currentBandCount);
        layout.setColorModel(alphaModel);
        localHints.put((Object)JAI.KEY_IMAGE_LAYOUT, (Object)layout);
    }

    private ColorModel getColorModelWithAlpha(int currentBandCount) {
        if (currentBandCount == 3) {
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8, 8};
            return new ComponentColorModel(cs, nBits, true, false, 3, 0);
        }
        if (currentBandCount == 1) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{8, 8};
            return new ComponentColorModel(cs, nBits, true, false, 3, 0);
        }
        throw new IllegalArgumentException("Cannot create a color model with alphasupport starting with " + currentBandCount + " bands");
    }

    private int countBands(List<GridCoverage2D> coverages) {
        int count = 0;
        for (GridCoverage2D coverage : coverages) {
            count += coverage.getRenderedImage().getSampleModel().getNumBands();
        }
        return count;
    }

    private int getAlphaBandIndex(GridCoverage2D coverage) {
        ColorModel cm = coverage.getRenderedImage().getColorModel();
        if (!cm.hasAlpha() || cm.getNumComponents() == cm.getNumColorComponents()) {
            throw new IllegalArgumentException("The source coverage does not have an alpha band, cannot extract an alpha band");
        }
        if (cm.getNumColorComponents() == 1) {
            return 1;
        }
        return 3;
    }

    private GridCoverage2D retainBands(List<Integer> bandIndices, GridCoverage2D coverage, Hints hints) {
        ParameterValueGroup param = PROCESSOR.getOperation("SelectSampleDimension").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        int[] sampleDimensionArray = ArrayUtils.toPrimitive((Integer[])bandIndices.toArray(new Integer[bandIndices.size()]));
        param.parameter("SampleDimensions").setValue((Object)sampleDimensionArray);
        coverage = (GridCoverage2D)PROCESSOR.doOperation(param, hints);
        return coverage;
    }

    private boolean hasDynamicAlpha(GridCoverage2D coverage, GridCoverage2DReader reader) throws IOException {
        if (coverage == null) {
            return false;
        }
        ColorModel dynamicCm = coverage.getRenderedImage().getColorModel();
        if (!dynamicCm.hasAlpha() || !this.hasAlphaBand(dynamicCm)) {
            return false;
        }
        ImageLayout readerLayout = reader.getImageLayout();
        if (readerLayout == null) {
            return false;
        }
        ColorModel nativeCm = readerLayout.getColorModel(null);
        if (nativeCm == null || nativeCm.hasAlpha()) {
            return false;
        }
        return !this.hasAlphaBand(nativeCm);
    }

    private boolean hasAlphaBand(ColorModel cm) {
        return cm.getNumComponents() == 2 && cm.getNumColorComponents() == 1 || cm.getNumComponents() == 4 && cm.getNumColorComponents() == 3;
    }

    protected void checkCoverageName(String coverageName) {
        if (!this.coverageName.equalsIgnoreCase(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName isn't the one of this coverageView");
        }
    }

    public void dispose() throws IOException {
        this.delegate.dispose();
    }

    public static GridCoverage2DReader wrap(GridCoverage2DReader reader, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        if (reader instanceof StructuredGridCoverage2DReader) {
            return new StructuredCoverageViewReader((StructuredGridCoverage2DReader)reader, coverageView, coverageInfo, hints);
        }
        return new CoverageViewReader(reader, coverageView, coverageInfo, hints);
    }

    public Format getFormat() {
        return new Format(){
            private final Format delegateFormat;
            {
                this.delegateFormat = CoverageViewReader.this.delegate.getFormat();
            }

            public ParameterValueGroup getWriteParameters() {
                return this.delegateFormat.getWriteParameters();
            }

            public String getVersion() {
                return this.delegateFormat.getVersion();
            }

            public String getVendor() {
                return this.delegateFormat.getVendor();
            }

            public ParameterValueGroup getReadParameters() {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("name", this.getName());
                info.put("description", this.getDescription());
                info.put("vendor", this.getVendor());
                info.put("docURL", this.getDocURL());
                info.put("version", this.getVersion());
                ArrayList<DefaultParameterDescriptor> delegateFormatParams = new ArrayList<DefaultParameterDescriptor>();
                delegateFormatParams.addAll(this.delegateFormat.getReadParameters().getDescriptor().descriptors());
                if (!CoverageViewReader.this.checkIfDelegateReaderSupportsBands()) {
                    delegateFormatParams.add(AbstractGridFormat.BANDS);
                }
                return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(info, delegateFormatParams.toArray(new GeneralParameterDescriptor[delegateFormatParams.size()])));
            }

            public String getName() {
                return this.delegateFormat.getName();
            }

            public String getDocURL() {
                return this.delegateFormat.getDocURL();
            }

            public String getDescription() {
                return this.delegateFormat.getDescription();
            }
        };
    }

    private boolean checkIfDelegateReaderSupportsBands() {
        List parameters = this.delegate.getFormat().getReadParameters().getDescriptor().descriptors();
        for (GeneralParameterDescriptor parameterDescriptor : parameters) {
            if (!parameterDescriptor.getName().equals(AbstractGridFormat.BANDS.getName())) continue;
            return true;
        }
        return false;
    }

    public Object getSource() {
        return this.delegate.getSource();
    }

    public String[] getMetadataNames(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataNames(this.referenceName);
    }

    public String getMetadataValue(String coverageName, String name) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataValue(this.referenceName, name);
    }

    public String[] getGridCoverageNames() throws IOException {
        return this.delegate.getGridCoverageNames();
    }

    public int getGridCoverageCount() throws IOException {
        return this.delegate.getGridCoverageCount();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getCoordinateReferenceSystem(this.referenceName);
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.getOriginalEnvelope();
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.getOriginalGridRange();
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        this.checkCoverageName(coverageName);
        return this.getOriginalGridToWorld(pixInCell);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IOException {
        this.checkCoverageName(coverageName);
        return this.read(parameters);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getDynamicParameters(this.referenceName);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getReadingResolutions(this.referenceName, policy, requestedResolution);
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.imageLayout;
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.imageLayout;
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.getResolutionLevels();
    }

    public String[] getMetadataNames() throws IOException {
        return this.delegate.getMetadataNames(this.referenceName);
    }

    public String getMetadataValue(String name) throws IOException {
        return this.delegate.getMetadataValue(this.referenceName, name);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.delegate.getCoordinateReferenceSystem(this.referenceName);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.delegate.getDynamicParameters(this.referenceName);
    }

    public DatasetLayout getDatasetLayout() {
        return this.delegate.getDatasetLayout();
    }

    public DatasetLayout getDatasetLayout(String coverageName) {
        return this.delegate.getDatasetLayout(coverageName);
    }

    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public ResourceInfo getInfo(String coverageName) {
        return this.delegate.getInfo(coverageName);
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.handler.getReadingResolutions(policy, requestedResolution);
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.handler.getResolutionLevels();
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.handler.getOriginalEnvelope();
    }

    public GridEnvelope getOriginalGridRange() {
        return this.handler.getOriginalGridRange();
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.handler.getOriginalGridToWorld(pixInCell);
    }
}

