/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageReaderInputObjectConverter;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geotools.util.factory.Hints;

public class CoverageReaderFileConverter
implements CoverageReaderInputObjectConverter<File> {
    private final Catalog catalog;

    public CoverageReaderFileConverter(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public Optional<File> convert(Object input, @Nullable CoverageInfo coverageInfo, @Nullable Hints hints) {
        return this.convert(input, coverageInfo, null, hints);
    }

    @Override
    public Optional<File> convert(Object input, @Nullable CoverageInfo coverageInfo, @Nullable CoverageStoreInfo coverageStoreInfo, @Nullable Hints hints) {
        if (!(input instanceof String)) {
            return Optional.empty();
        }
        String urlString = (String)input;
        return this.canConvert(urlString) ? this.convertFile(urlString) : Optional.empty();
    }

    protected boolean canConvert(String input) {
        try {
            URI uri = new URI(input);
            return uri.getScheme() == null || "file".equalsIgnoreCase(uri.getScheme());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected Optional<File> convertFile(String input) {
        Resource resource = Files.asResource((File)this.catalog.getResourceLoader().getBaseDirectory());
        File readerFile = Resources.find((Resource)Resources.fromURL((Resource)resource, (String)input), (boolean)true);
        return readerFile != null ? Optional.of(readerFile) : Optional.empty();
    }
}

