/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.media.jai.ImageLayout;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.decorate.Wrapper;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;
import tech.units.indriya.format.SimpleUnitFormat;

public class CoverageDimensionCustomizerReader
implements GridCoverage2DReader {
    static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private CoverageInfo info;
    private GridCoverage2DReader delegate;
    private String coverageName;

    public static GridCoverageReader wrap(GridCoverage2DReader delegate, String coverageName, CoverageStoreInfo info) {
        GridCoverage2DReader reader = delegate;
        if (coverageName != null) {
            reader = SingleGridCoverage2DReader.wrap(delegate, coverageName);
        }
        if (reader instanceof StructuredGridCoverage2DReader) {
            return new CoverageDimensionCustomizerStructuredReader((StructuredGridCoverage2DReader)reader, coverageName, info);
        }
        return new CoverageDimensionCustomizerReader(reader, coverageName, info);
    }

    public static GridCoverageReader wrap(GridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
        GridCoverage2DReader reader = delegate;
        if (coverageName != null) {
            reader = SingleGridCoverage2DReader.wrap(delegate, coverageName);
        }
        if (reader instanceof StructuredGridCoverage2DReader) {
            return new CoverageDimensionCustomizerStructuredReader((StructuredGridCoverage2DReader)reader, coverageName, info);
        }
        return new CoverageDimensionCustomizerReader(reader, coverageName, info);
    }

    public CoverageDimensionCustomizerReader(GridCoverage2DReader delegate, String coverageName, CoverageStoreInfo storeInfo) {
        this.delegate = delegate;
        this.coverageName = coverageName;
        this.info = ResourcePool.getCoverageInfo(coverageName, storeInfo);
    }

    public CoverageDimensionCustomizerReader(GridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
        this.delegate = delegate;
        this.coverageName = coverageName;
        this.info = info;
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public CoverageInfo getCoverageInfo() {
        return this.info;
    }

    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public ResourceInfo getInfo(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getInfo(coverageName);
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        return this.read(this.coverageName, parameters);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        double[] wrappedNoDataValues;
        GridCoverage2D coverage;
        GridCoverage2D gridCoverage2D = coverage = coverageName != null ? this.delegate.read(coverageName, parameters) : this.delegate.read(parameters);
        if (coverage == null) {
            return coverage;
        }
        Map properties = coverage.getProperties();
        GridSampleDimension[] dims = coverage.getSampleDimensions();
        GridSampleDimension[] wrappedDims = null;
        if (this.info != null) {
            MetadataMap map;
            List<CoverageDimensionInfo> dimensions = this.info.getDimensions();
            if ((dimensions == null || dimensions.isEmpty()) && (map = this.info.getMetadata()).containsKey(CoverageView.COVERAGE_VIEW)) {
                CoverageView coverageView = (CoverageView)map.get(CoverageView.COVERAGE_VIEW);
                dimensions = new ArrayList<CoverageDimensionInfo>();
                List<CoverageView.CoverageBand> coverageBands = coverageView.getCoverageBands();
                for (CoverageView.CoverageBand band : coverageBands) {
                    CoverageDimensionImpl dimensionInfo = new CoverageDimensionImpl();
                    dimensionInfo.setName(band.getDefinition());
                    dimensions.add(dimensionInfo);
                }
            }
            int[] selectedBandIndexes = this.getSelectedBandIndexes(parameters);
            wrappedDims = this.wrapDimensions((SampleDimension[])dims, dimensions, selectedBandIndexes);
        }
        NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
        if (wrappedDims == null) {
            wrappedDims = dims;
        } else if (properties != null && noDataProperty != null && (wrappedNoDataValues = wrappedDims[0].getNoDataValues()) != null && wrappedNoDataValues.length > 0) {
            CoverageUtilities.setNoDataProperty((Map)properties, (Object)wrappedNoDataValues[0]);
        }
        return new GridCoverageWrapper(coverageName, coverage, wrappedDims, properties);
    }

    int[] getSelectedBandIndexes(GeneralParameterValue[] parameters) {
        if (this.delegate.getFormat() == null || !this.delegate.getFormat().getReadParameters().getDescriptor().descriptors().contains(AbstractGridFormat.BANDS)) {
            return null;
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                ParameterValue param = (ParameterValue)parameters[i];
                if (!AbstractGridFormat.BANDS.getName().equals(param.getDescriptor().getName())) continue;
                int[] bandIndicesParam = (int[])param.getValue();
                return bandIndicesParam;
            }
        }
        return null;
    }

    protected GridSampleDimension[] wrapDimensions(SampleDimension[] dims, List<CoverageDimensionInfo> storedDimensions, int[] bandIndexes) {
        GridSampleDimension[] wrappedDims = null;
        if (storedDimensions != null && storedDimensions.size() > 0) {
            int i = 0;
            wrappedDims = new GridSampleDimension[dims.length];
            for (SampleDimension dim : dims) {
                CoverageDimensionInfo cdi;
                if (bandIndexes != null) {
                    if (i >= bandIndexes.length) {
                        cdi = this.buildAlphaChannelDimnsionInfo(storedDimensions.get(0));
                    } else {
                        int idx = bandIndexes[i];
                        cdi = storedDimensions.get(idx);
                    }
                } else {
                    cdi = i >= storedDimensions.size() ? this.buildAlphaChannelDimnsionInfo(storedDimensions.get(0)) : storedDimensions.get(i);
                }
                wrappedDims[i] = WrappedSampleDimension.build((GridSampleDimension)dim, cdi);
                ++i;
            }
        }
        return wrappedDims;
    }

    private CoverageDimensionInfo buildAlphaChannelDimnsionInfo(CoverageDimensionInfo sample) {
        CoverageDimensionImpl result = new CoverageDimensionImpl(sample);
        result.setName("ALPHA_BAND");
        result.setDescription("Alpha");
        return result;
    }

    public Format getFormat() {
        return this.delegate.getFormat();
    }

    public Object getSource() {
        return this.delegate.getSource();
    }

    public String[] getMetadataNames() throws IOException {
        return this.delegate.getMetadataNames();
    }

    public String[] getMetadataNames(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataNames(coverageName);
    }

    public String getMetadataValue(String name) throws IOException {
        return this.delegate.getMetadataValue(name);
    }

    public String getMetadataValue(String coverageName, String name) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataValue(coverageName, name);
    }

    public void dispose() throws IOException {
        this.delegate.dispose();
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.delegate.getOriginalEnvelope();
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalEnvelope(coverageName);
    }

    public GridEnvelope getOriginalGridRange() {
        return this.delegate.getOriginalGridRange();
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridRange(coverageName);
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.delegate.getOriginalGridToWorld(pixInCell);
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridToWorld(coverageName, pixInCell);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.delegate.getCoordinateReferenceSystem();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getCoordinateReferenceSystem(coverageName);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.delegate.getDynamicParameters();
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getDynamicParameters(coverageName);
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.delegate.getReadingResolutions(policy, requestedResolution);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getReadingResolutions(coverageName, policy, requestedResolution);
    }

    public String[] getGridCoverageNames() throws IOException {
        return this.delegate.getGridCoverageNames();
    }

    public int getGridCoverageCount() throws IOException {
        return this.delegate.getGridCoverageCount();
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.delegate.getImageLayout();
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getImageLayout(coverageName);
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.delegate.getResolutionLevels();
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getResolutionLevels(coverageName);
    }

    protected void checkCoverageName(String coverageName) {
        if (this.coverageName != null && !this.coverageName.equals(coverageName)) {
            throw new IllegalArgumentException("Unkonwn coverage named " + coverageName + ", the only valid value is: " + this.coverageName);
        }
    }

    public DatasetLayout getDatasetLayout() {
        return this.delegate.getDatasetLayout();
    }

    public DatasetLayout getDatasetLayout(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getDatasetLayout(coverageName);
    }

    static class WrappedSampleDimension
    extends GridSampleDimension
    implements SampleDimension {
        private GridSampleDimension sampleDim;
        private List<Category> customCategories;
        private double[] configuredNoDataValues;
        private Unit<?> configuredUnit;
        private NumberRange<? extends Number> configuredRange;
        private String name;
        private InternationalString configuredDescription;

        public static WrappedSampleDimension build(GridSampleDimension sampleDim, CoverageDimensionInfo info) {
            double[] configuredNoDataValues;
            Unit unit;
            NumberRange configuredRange;
            List categories;
            SimpleInternationalString configuredDescription;
            String name;
            block14: {
                Unit defaultUnit;
                name = info.getName();
                InternationalString sampleDimDescription = sampleDim.getDescription();
                configuredDescription = sampleDimDescription == null || !sampleDimDescription.toString().equalsIgnoreCase(name) ? new SimpleInternationalString(name) : sampleDimDescription;
                categories = sampleDim.getCategories();
                configuredRange = info.getRange();
                String uom = info.getUnit();
                unit = defaultUnit = sampleDim.getUnits();
                try {
                    if (uom != null) {
                        unit = SimpleUnitFormat.getInstance().parse((CharSequence)uom);
                    }
                }
                catch (IllegalArgumentException | MeasurementParseException iae) {
                    if (!LOGGER.isLoggable(Level.WARNING) || defaultUnit == null) break block14;
                    LOGGER.warning("Unable to parse the specified unit (" + uom + "). Using the previous one: " + defaultUnit.toString());
                }
            }
            Unit configuredUnit = unit;
            List<Double> nullValues = info.getNullValues();
            if (nullValues != null && nullValues.size() > 0) {
                int size = nullValues.size();
                configuredNoDataValues = new double[size];
                for (int i = 0; i < size; ++i) {
                    configuredNoDataValues[i] = nullValues.get(i);
                }
            } else {
                configuredNoDataValues = sampleDim.getNoDataValues();
            }
            boolean nodataConfigured = configuredNoDataValues != null && configuredNoDataValues.length > 0;
            int numCategories = 0;
            ArrayList<Category> customCategories = new ArrayList<Category>(numCategories);
            if (categories != null && (numCategories = categories.size()) > 0) {
                Category wrapped = null;
                Iterator iterator = categories.iterator();
                while (iterator.hasNext()) {
                    Category category;
                    wrapped = category = (Category)iterator.next();
                    if (Category.NODATA.getName().equals(category.getName()) && category.isQuantitative()) {
                        double minimum = nodataConfigured ? configuredNoDataValues[0] : category.getRange().getMinimum();
                        double maximum = nodataConfigured ? configuredNoDataValues[0] : category.getRange().getMaximum();
                        wrapped = Double.isNaN(minimum) && Double.isNaN(maximum) ? new Category((CharSequence)Category.NODATA.getName(), category.getColors()[0], minimum) : new Category((CharSequence)Category.NODATA.getName(), category.getColors(), NumberRange.create((double)minimum, (double)maximum));
                    }
                    customCategories.add(wrapped);
                }
            }
            if (configuredRange != null && !Double.isInfinite(configuredRange.getMinimum()) && !Double.isInfinite(configuredRange.getMaximum())) {
                Class targetType = categories != null && !categories.isEmpty() ? ((Category)categories.get(0)).getRange().getElementClass() : Double.class;
                NumberRange dataRange = configuredRange.castTo(targetType);
                ArrayList<NumberRange> dataRanges = new ArrayList<NumberRange>();
                dataRanges.add(dataRange);
                for (Category category : customCategories) {
                    ArrayList<NumberRange> newDataRanges = new ArrayList<NumberRange>();
                    for (NumberRange dr : dataRanges) {
                        NumberRange[] subtracted;
                        for (NumberRange range : subtracted = dr.subtract((Range)category.getRange())) {
                            if (range.isEmpty()) continue;
                            newDataRanges.add(range);
                        }
                    }
                    dataRanges = newDataRanges;
                }
                for (int i = 0; i < dataRanges.size(); ++i) {
                    customCategories.add(new Category((CharSequence)("data" + i), (Color)null, (NumberRange)dataRanges.get(i)));
                }
            }
            return new WrappedSampleDimension(name, (InternationalString)configuredDescription, (NumberRange<? extends Number>)configuredRange, configuredUnit, configuredNoDataValues, customCategories.toArray(new Category[customCategories.size()]), sampleDim);
        }

        WrappedSampleDimension(String name, InternationalString configuredDescription, NumberRange<? extends Number> configuredRange, Unit<?> configuredUnit, double[] configuredNoDataValues, Category[] customCategories, GridSampleDimension sampleDim) {
            super((CharSequence)configuredDescription.toString(), customCategories, configuredUnit);
            this.configuredDescription = configuredDescription;
            this.configuredRange = configuredRange;
            this.configuredUnit = configuredUnit;
            this.configuredNoDataValues = configuredNoDataValues;
            this.customCategories = Arrays.asList(customCategories);
            this.sampleDim = sampleDim;
        }

        public SampleDimensionType getSampleDimensionType() {
            return this.sampleDim.getSampleDimensionType();
        }

        public InternationalString getDescription() {
            return this.configuredDescription;
        }

        public InternationalString[] getCategoryNames() throws IllegalStateException {
            return this.sampleDim.getCategoryNames();
        }

        public List<Category> getCategories() {
            return this.customCategories;
        }

        public Category getCategory(double sample) {
            return this.sampleDim.getCategory(sample);
        }

        public double[] getNoDataValues() throws IllegalStateException {
            return this.configuredNoDataValues;
        }

        public double getMinimumValue() {
            NumberRange<? extends Number> range = this.getRange();
            if (range != null) {
                return range.getMinimum();
            }
            return this.sampleDim.getMinimumValue();
        }

        public double getMaximumValue() {
            NumberRange<? extends Number> range = this.getRange();
            if (range != null) {
                return range.getMaximum();
            }
            return this.sampleDim.getMaximumValue();
        }

        public NumberRange<? extends Number> getRange() {
            return this.configuredRange;
        }

        public String getLabel(double value, Locale locale) {
            return this.sampleDim.getLabel(value, locale);
        }

        public Unit<?> getUnits() {
            return this.configuredUnit;
        }

        public double getOffset() throws IllegalStateException {
            return this.sampleDim.getOffset();
        }

        public double getScale() {
            return this.sampleDim.getScale();
        }

        public ColorModel getColorModel() {
            return this.sampleDim.getColorModel();
        }

        public ColorModel getColorModel(int visibleBand, int numBands) {
            return this.sampleDim.getColorModel(visibleBand, numBands);
        }

        public ColorModel getColorModel(int visibleBand, int numBands, int type) {
            return this.sampleDim.getColorModel(visibleBand, numBands, type);
        }

        public int hashCode() {
            return this.sampleDim.hashCode();
        }

        public boolean equals(Object object) {
            return this.sampleDim.equals(object);
        }

        private StringBuilder formatRange(StringBuilder builder, Locale locale) {
            NumberRange<? extends Number> range = this.getRange();
            builder.append('[');
            if (range != null) {
                builder.append(range.getMinimum()).append(" ... ").append(range.getMaximum());
            } else {
                Unit<?> unit = this.getUnits();
                if (unit != null) {
                    builder.append(unit);
                }
            }
            builder.append(']');
            return builder;
        }

        public String toString() {
            if (this.customCategories != null) {
                StringBuilder builder = new StringBuilder((CharSequence)this.configuredDescription);
                builder.append('(');
                builder = this.formatRange(builder, null);
                builder.append(')').append(LINE_SEPARATOR);
                for (Category category : this.customCategories) {
                    builder.append("  ").append(' ').append(' ').append(category).append(LINE_SEPARATOR);
                }
                return builder.toString();
            }
            return this.sampleDim.toString();
        }
    }

    public static class GridCoverageWrapper
    extends GridCoverage2D
    implements Wrapper {
        private PropertySourceImpl wrappedPropertySource;
        private GridSampleDimension[] wrappedSampleDimensions;
        private GridCoverage2D gridCoverage;

        public GridCoverageWrapper(String name, GridCoverage2D coverage, GridSampleDimension[] sampleDimensions, Map properties) {
            super((CharSequence)name, coverage);
            this.gridCoverage = coverage;
            this.wrappedSampleDimensions = sampleDimensions;
            this.wrappedPropertySource = new PropertySourceImpl(properties, (PropertySource)(coverage instanceof PropertySource ? coverage : null));
        }

        public GridSampleDimension getSampleDimension(int index) {
            return this.wrappedSampleDimensions[index];
        }

        public GridSampleDimension[] getSampleDimensions() {
            return (GridSampleDimension[])this.wrappedSampleDimensions.clone();
        }

        public Map getProperties() {
            return this.wrappedPropertySource.getProperties();
        }

        public Object getProperty(String arg0) {
            return this.wrappedPropertySource.getProperty(arg0);
        }

        public static GridCoverage2D wrapCoverage(GridCoverage2D coverage, GridCoverage2D sourceCoverage, GridSampleDimension[] wrappedDimensions, Map properties, boolean forceWrapping) {
            if (coverage instanceof GridCoverageWrapper || forceWrapping) {
                return new GridCoverageWrapper(coverage.getName().toString(), coverage, wrappedDimensions == null ? coverage.getSampleDimensions() : wrappedDimensions, properties == null ? sourceCoverage.getProperties() : properties);
            }
            return coverage;
        }

        public boolean isWrapperFor(Class<?> iface) {
            if (this.gridCoverage instanceof Wrapper) {
                return ((Wrapper)this.gridCoverage).isWrapperFor(iface);
            }
            return iface.isInstance(this.gridCoverage);
        }

        public <T> T unwrap(Class<T> iface) throws IllegalArgumentException {
            if (this.gridCoverage instanceof Wrapper) {
                return (T)((Wrapper)this.gridCoverage).unwrap(iface);
            }
            if (iface.isInstance(this.gridCoverage)) {
                return (T)this.gridCoverage;
            }
            throw new IllegalArgumentException("Cannot unwrap to the requested interface " + iface);
        }
    }

    static class CoverageDimensionCustomizerStructuredReader
    extends CoverageDimensionCustomizerReader
    implements StructuredGridCoverage2DReader {
        private StructuredGridCoverage2DReader structuredDelegate;

        public CoverageDimensionCustomizerStructuredReader(StructuredGridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
            super((GridCoverage2DReader)delegate, coverageName, info);
            this.structuredDelegate = delegate;
        }

        public CoverageDimensionCustomizerStructuredReader(StructuredGridCoverage2DReader delegate, String coverageName, CoverageStoreInfo storeInfo) {
            super((GridCoverage2DReader)delegate, coverageName, storeInfo);
            this.structuredDelegate = delegate;
        }

        public GranuleSource getGranules(String coverageName, boolean readOnly) throws IOException, UnsupportedOperationException {
            return this.structuredDelegate.getGranules(coverageName, readOnly);
        }

        public boolean isReadOnly() {
            return this.structuredDelegate.isReadOnly();
        }

        public void createCoverage(String coverageName, SimpleFeatureType schema) throws IOException, UnsupportedOperationException {
            this.structuredDelegate.createCoverage(coverageName, schema);
        }

        public boolean removeCoverage(String coverageName, boolean delete) throws IOException, UnsupportedOperationException {
            return this.structuredDelegate.removeCoverage(coverageName, delete);
        }

        public void delete(boolean deleteData) throws IOException {
            this.structuredDelegate.delete(deleteData);
        }

        public List<HarvestedSource> harvest(String defaultTargetCoverage, Object source, Hints hints) throws IOException, UnsupportedOperationException {
            return this.structuredDelegate.harvest(defaultTargetCoverage, source, hints);
        }

        public List<DimensionDescriptor> getDimensionDescriptors(String coverageName) throws IOException {
            return this.structuredDelegate.getDimensionDescriptors(coverageName);
        }
    }
}

