/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.lang.reflect.Proxy;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogCapabilities;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public interface CatalogFacade {
    public static final WorkspaceInfo ANY_WORKSPACE = CatalogFacade.any(WorkspaceInfo.class);
    public static final NamespaceInfo ANY_NAMESPACE = CatalogFacade.any(NamespaceInfo.class);
    public static final WorkspaceInfo NO_WORKSPACE = CatalogFacade.any(WorkspaceInfo.class);

    public Catalog getCatalog();

    public void setCatalog(Catalog var1);

    public StoreInfo add(StoreInfo var1);

    public void remove(StoreInfo var1);

    public void save(StoreInfo var1);

    public <T extends StoreInfo> T detach(T var1);

    public <T extends StoreInfo> T getStore(String var1, Class<T> var2);

    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo var1, String var2, Class<T> var3);

    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo var1, Class<T> var2);

    public <T extends StoreInfo> List<T> getStores(Class<T> var1);

    public DataStoreInfo getDefaultDataStore(WorkspaceInfo var1);

    public void setDefaultDataStore(WorkspaceInfo var1, DataStoreInfo var2);

    public ResourceInfo add(ResourceInfo var1);

    public void remove(ResourceInfo var1);

    public void save(ResourceInfo var1);

    public <T extends ResourceInfo> T detach(T var1);

    public <T extends ResourceInfo> T getResource(String var1, Class<T> var2);

    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo var1, String var2, Class<T> var3);

    public <T extends ResourceInfo> List<T> getResources(Class<T> var1);

    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo var1, Class<T> var2);

    public <T extends ResourceInfo> T getResourceByStore(StoreInfo var1, String var2, Class<T> var3);

    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo var1, Class<T> var2);

    public LayerInfo add(LayerInfo var1);

    public void remove(LayerInfo var1);

    public void save(LayerInfo var1);

    public LayerInfo detach(LayerInfo var1);

    public LayerInfo getLayer(String var1);

    public LayerInfo getLayerByName(String var1);

    public List<LayerInfo> getLayers(ResourceInfo var1);

    public List<LayerInfo> getLayers(StyleInfo var1);

    public List<LayerInfo> getLayers();

    public MapInfo add(MapInfo var1);

    public void remove(MapInfo var1);

    public void save(MapInfo var1);

    public MapInfo detach(MapInfo var1);

    public MapInfo getMap(String var1);

    public MapInfo getMapByName(String var1);

    public List<MapInfo> getMaps();

    public LayerGroupInfo add(LayerGroupInfo var1);

    public void remove(LayerGroupInfo var1);

    public void save(LayerGroupInfo var1);

    public LayerGroupInfo detach(LayerGroupInfo var1);

    public LayerGroupInfo getLayerGroup(String var1);

    public LayerGroupInfo getLayerGroupByName(String var1);

    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo var1, String var2);

    public List<LayerGroupInfo> getLayerGroups();

    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo var1);

    public NamespaceInfo add(NamespaceInfo var1);

    public void remove(NamespaceInfo var1);

    public void save(NamespaceInfo var1);

    public NamespaceInfo detach(NamespaceInfo var1);

    public NamespaceInfo getDefaultNamespace();

    public void setDefaultNamespace(NamespaceInfo var1);

    public NamespaceInfo getNamespace(String var1);

    public NamespaceInfo getNamespaceByPrefix(String var1);

    public NamespaceInfo getNamespaceByURI(String var1);

    default public List<NamespaceInfo> getNamespacesByURI(String uri) {
        return this.getNamespaces().stream().filter(namespace -> namespace.getURI().equals(uri)).collect(Collectors.toList());
    }

    public List<NamespaceInfo> getNamespaces();

    public WorkspaceInfo add(WorkspaceInfo var1);

    public void remove(WorkspaceInfo var1);

    public void save(WorkspaceInfo var1);

    public WorkspaceInfo detach(WorkspaceInfo var1);

    public WorkspaceInfo getDefaultWorkspace();

    public void setDefaultWorkspace(WorkspaceInfo var1);

    public WorkspaceInfo getWorkspace(String var1);

    public WorkspaceInfo getWorkspaceByName(String var1);

    public List<WorkspaceInfo> getWorkspaces();

    public StyleInfo add(StyleInfo var1);

    public void remove(StyleInfo var1);

    public void save(StyleInfo var1);

    public StyleInfo detach(StyleInfo var1);

    public StyleInfo getStyle(String var1);

    public StyleInfo getStyleByName(String var1);

    public StyleInfo getStyleByName(WorkspaceInfo var1, String var2);

    public List<StyleInfo> getStyles();

    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo var1);

    public void dispose();

    public void resolve();

    public void syncTo(CatalogFacade var1);

    public <T extends CatalogInfo> int count(Class<T> var1, Filter var2);

    public boolean canSort(Class<? extends CatalogInfo> var1, String var2);

    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> var1, Filter var2, @Nullable Integer var3, @Nullable Integer var4, SortBy ... var5);

    default public CatalogCapabilities getCatalogCapabilities() {
        return new CatalogCapabilities();
    }

    public static <T extends CatalogInfo> T any(Class<T> clazz) {
        try {
            return (T)((CatalogInfo)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

