/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.iterator;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import java.util.Iterator;
import java.util.List;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.iterator.IteratorFactory;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;

public class WFSFeatureIteratorFactory
implements IteratorFactory<Feature> {
    private SimpleFeatureCollection features;
    private List<KmlDecoratorFactory.KmlDecorator> callbacks;
    private KmlEncodingContext context;

    public WFSFeatureIteratorFactory(KmlEncodingContext context) {
        this.context = context;
        this.features = context.getCurrentFeatureCollection();
        this.callbacks = context.getDecoratorsForClass(Placemark.class);
    }

    @Override
    public Iterator<Feature> newIterator() {
        return new FeatureGenerator(this.context.openIterator((FeatureCollection)this.features));
    }

    public class FeatureGenerator
    implements Iterator<Feature> {
        private FeatureIterator fi;

        public FeatureGenerator(FeatureIterator fi) {
            this.fi = fi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Feature next() {
            if (this.fi == null) {
                return null;
            }
            if (this.hasNext()) {
                boolean featureRetrieved = false;
                try {
                    SimpleFeature sf = (SimpleFeature)this.fi.next();
                    featureRetrieved = true;
                    WFSFeatureIteratorFactory.this.context.setCurrentFeature(sf);
                    Placemark pm = new Placemark();
                    pm.setId(sf.getID());
                    for (KmlDecoratorFactory.KmlDecorator callback : WFSFeatureIteratorFactory.this.callbacks) {
                        pm = (Placemark)callback.decorate((Feature)pm, WFSFeatureIteratorFactory.this.context);
                        if (pm != null) continue;
                    }
                    Placemark placemark = pm;
                    return placemark;
                }
                finally {
                    if (!featureRetrieved) {
                        WFSFeatureIteratorFactory.this.context.closeIterator(this.fi);
                    }
                }
            }
            if (!this.hasNext()) {
                WFSFeatureIteratorFactory.this.context.closeIterator(this.fi);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.fi.hasNext();
        }
    }
}

