/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;

public abstract class RegionatingTestSupport
extends GeoServerSystemTestSupport {
    public static QName STACKED_FEATURES = new QName(MockData.SF_URI, "Stacked", MockData.SF_PREFIX);
    public static QName DISPERSED_FEATURES = new QName(MockData.SF_URI, "Dispersed", MockData.SF_PREFIX);
    public static QName TILE_TESTS = new QName(MockData.SF_URI, "Tiles", MockData.SF_PREFIX);
    public static QName CENTERED_POLY = new QName(MockData.SF_URI, "CenteredPoly", MockData.SF_PREFIX);

    protected void setUpTestData(SystemTestData data) throws Exception {
        super.setUpTestData(data);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("wcs", "http://www.opengis.net/wcs/1.1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("sf", "http://cite.opengeospatial.org/gmlsf");
        namespaces.put("kml", "http://www.opengis.net/kml/2.2");
        namespaces.put("atom", "http://www.w3.org/2005/Atom");
        SystemTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        data.setUpVectorLayer(STACKED_FEATURES, null, "Stacked.properties", ((Object)((Object)this)).getClass());
        data.setUpVectorLayer(DISPERSED_FEATURES, null, "Dispersed.properties", ((Object)((Object)this)).getClass());
        data.setUpVectorLayer(TILE_TESTS, null, "TileTests.properties", ((Object)((Object)this)).getClass());
        data.setUpVectorLayer(CENTERED_POLY, null, "CenteredPoly.properties", ((Object)((Object)this)).getClass());
    }
}

