/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.kml.regionate.CachedHierarchyRegionatingStrategy;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class KMLSuperOverlayTest
extends WMSTestSupport {
    public static QName DISPERSED_FEATURES = new QName(MockData.SF_URI, "Dispersed", MockData.SF_PREFIX);
    public static QName BOULDER = new QName(MockData.SF_URI, "boulder", MockData.SF_PREFIX);
    private XpathEngine xpath;

    @Before
    public void setupXPath() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs10RasterLayers();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("allsymbolizers", "allsymbolizers.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("SingleFeature", "singlefeature.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("Bridge", "bridge.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.copyTo(((Object)((Object)this)).getClass().getResourceAsStream("bridge.png"), "styles/bridge.png");
        testData.addVectorLayer(DISPERSED_FEATURES, Collections.emptyMap(), "Dispersed.properties", ((Object)((Object)this)).getClass(), catalog);
        HashMap<SystemTestData.LayerProperty, Object> properties = new HashMap<SystemTestData.LayerProperty, Object>();
        properties.put(SystemTestData.LayerProperty.LATLON_ENVELOPE, new ReferencedEnvelope(-105.336, -105.112, 39.9, 40.116, CRS.decode((String)"EPSG:4326")));
        properties.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope(3045967.0, 3108482.0, 1206627.0, 1285209.0, CRS.decode((String)"EPSG:2876")));
        properties.put(SystemTestData.LayerProperty.SRS, 2876);
        testData.addVectorLayer(BOULDER, properties, "boulder.properties", ((Object)((Object)this)).getClass(), catalog);
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        ft.getMetadata().put("kml.regionateFeatureLimit", (Serializable)Integer.valueOf(1));
        this.getCatalog().save((ResourceInfo)ft);
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        File dir = this.getDataDirectory().findOrCreateDir(new String[]{"geosearch"});
        CachedHierarchyRegionatingStrategy.clearAllHsqlDatabases((File)dir);
        super.onTearDown(testData);
    }

    @Test
    public void testWorldBoundsSuperOverlay() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(DISPERSED_FEATURES) + "&mode=superoverlay");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"2", (Object)this.xpath.evaluate("count(//kml:Folder)", document));
        Assert.assertEquals((long)9L, (long)document.getElementsByTagName("Region").getLength());
        Assert.assertEquals((Object)"8", (Object)this.xpath.evaluate("count(//kml:NetworkLink)", document));
        Assert.assertEquals((Object)"0", (Object)this.xpath.evaluate("count(//kml:GroundOverlay)", document));
        XMLAssert.assertXpathEvaluatesTo((String)"90.0", (String)"//kml:Region/kml:LatLonAltBox/kml:north", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"-90.0", (String)"//kml:Region/kml:LatLonAltBox/kml:south", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"180.0", (String)"//kml:Region/kml:LatLonAltBox/kml:east", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"-180.0", (String)"//kml:Region/kml:LatLonAltBox/kml:west", (Document)document);
        XMLAssert.assertXpathExists((String)"//kml:NetworkLink[kml:name='contents-0']", (Document)document);
        XMLAssert.assertXpathExists((String)"//kml:NetworkLink[kml:name='contents-1']", (Document)document);
    }

    @Test
    public void testCrossingSuperoverlay() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(BOULDER) + "&mode=superoverlay");
        XMLAssert.assertXpathEvaluatesTo((String)"40.78125", (String)"//kml:Region/kml:LatLonAltBox/kml:north", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"39.375", (String)"//kml:Region/kml:LatLonAltBox/kml:south", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"-104.0625", (String)"//kml:Region/kml:LatLonAltBox/kml:east", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"-105.46875", (String)"//kml:Region/kml:LatLonAltBox/kml:west", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"-105.22419118401743", (String)"//kml:Document/kml:LookAt/kml:longitude", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"40.008056082289826", (String)"//kml:Document/kml:LookAt/kml:latitude", (Document)document);
        Assert.assertEquals((double)-105.2243, (double)Double.parseDouble(this.xpath.evaluate("//kml:Document/kml:Folder/kml:LookAt/kml:longitude", document)), (double)1.0E-4);
        Assert.assertEquals((double)40.0081, (double)Double.parseDouble(this.xpath.evaluate("//kml:Document/kml:Folder/kml:LookAt/kml:latitude", document)), (double)1.0E-4);
    }

    @Test
    public void testSuperOverlayLinkContents() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&mode=superoverlay");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//kml:Folder)", document));
        Assert.assertEquals((long)5L, (long)document.getElementsByTagName("Region").getLength());
        Assert.assertEquals((Object)"4", (Object)this.xpath.evaluate("count(//kml:NetworkLink)", document));
        Assert.assertEquals((Object)"0", (Object)this.xpath.evaluate("count(//kml:GroundOverlay)", document));
        String link0 = this.xpath.evaluate("//kml:NetworkLink[kml:name='0']/kml:Link/kml:href", document);
        Map kvp0 = KvpUtils.parseQueryString((String)link0);
        Assert.assertEquals((Object)"application/vnd.google-earth.kml+xml;mode=networklink", kvp0.get("format"));
        Assert.assertEquals((Object)"-180.0,-90.0,0.0,90.0", kvp0.get("bbox"));
        String link1 = this.xpath.evaluate("//kml:NetworkLink[kml:name='1']/kml:Link/kml:href", document);
        Map kvp1 = KvpUtils.parseQueryString((String)link1);
        Assert.assertEquals((Object)"application/vnd.google-earth.kml+xml;mode=networklink", kvp1.get("format"));
        Assert.assertEquals((Object)"0.0,-90.0,180.0,90.0", kvp1.get("bbox"));
    }

    @Test
    public void testSubtileSuperOverlay() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(DISPERSED_FEATURES) + "&mode=superoverlay&bbox=0,-90,180,90");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        Assert.assertEquals((long)3L, (long)document.getElementsByTagName("Region").getLength());
        Assert.assertEquals((long)2L, (long)document.getElementsByTagName("NetworkLink").getLength());
        Assert.assertEquals((long)0L, (long)document.getElementsByTagName("GroundOverlay").getLength());
    }

    @Test
    public void testGWCIntegration() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(MockData.USA_WORLDIMG) + "&mode=superoverlay&superoverlay_mode=cached");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)document.getElementsByTagName("Region").getLength());
        Assert.assertEquals((long)1L, (long)document.getElementsByTagName("NetworkLink").getLength());
        Assert.assertEquals((long)0L, (long)document.getElementsByTagName("GroundOverlay").getLength());
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/gwc/service/kml/cdf:usa.png.kml", (Object)this.xpath.evaluate("//kml:NetworkLink/kml:Link/kml:href", document));
        Assert.assertEquals((Object)"never", (Object)this.xpath.evaluate("//kml:NetworkLink/kml:Link/kml:viewRefreshMode", document));
    }

    @Test
    public void testGWCIntegrationFailing() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(MockData.USA_WORLDIMG) + "&mode=superoverlay&superoverlay_mode=cached&kmplacemark=true");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        Assert.assertEquals((long)6L, (long)document.getElementsByTagName("Region").getLength());
        Assert.assertEquals((long)4L, (long)document.getElementsByTagName("NetworkLink").getLength());
        Assert.assertEquals((long)1L, (long)document.getElementsByTagName("GroundOverlay").getLength());
        Assert.assertTrue((String)"http://localhost:8080/geoserver/gwc/service/kml/cdf:usa.png.kml", (boolean)this.xpath.evaluate("//kml:NetworkLink/kml:Link/kml:href", document).contains("geoserver/wms"));
    }

    @Test
    public void testKmlTitleFormatOption() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(DISPERSED_FEATURES) + "&mode=superoverlay&bbox=0,-90,180,90&format_options=kmltitle:myCustomLayerTitle");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"myCustomLayerTitle", (Object)this.xpath.evaluate("//kml:Document/kml:name", document));
    }
}

