/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.IOException;
import java.util.logging.Logger;
import org.geoserver.kml.KMLMap;
import org.geoserver.kml.KMLMapOutputFormat;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.builder.SimpleNetworkLinkBuilder;
import org.geoserver.kml.builder.SuperOverlayNetworkLinkBuilder;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geotools.util.logging.Logging;

public class NetworkLinkMapOutputFormat
extends AbstractMapOutputFormat {
    static final Logger LOGGER = Logging.getLogger(NetworkLinkMapOutputFormat.class);
    public static final String KML_MIME_TYPE = "application/vnd.google-earth.kml+xml;mode=networklink";
    public static final String KMZ_MIME_TYPE = "application/vnd.google-earth.kmz;mode=networklink";
    public static final String[] OUTPUT_FORMATS = new String[]{"application/vnd.google-earth.kml+xml;mode=networklink", "application/vnd.google-earth.kmz;mode=networklink"};
    private WMS wms;

    public NetworkLinkMapOutputFormat(WMS wms) {
        super(KML_MIME_TYPE, OUTPUT_FORMATS);
        this.wms = wms;
    }

    public KMLMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        GetMapRequest request = mapContent.getRequest();
        boolean kmz = false;
        if (KML_MIME_TYPE.equals(request.getFormat())) {
            request.setFormat("application/vnd.google-earth.kml+xml");
        } else {
            kmz = true;
            request.setFormat("application/vnd.google-earth.kmz");
        }
        Boolean superoverlay = (Boolean)request.getFormatOptions().get("superoverlay");
        if (superoverlay == null) {
            superoverlay = Boolean.FALSE;
        }
        Kml kml = null;
        KmlEncodingContext context = new KmlEncodingContext(mapContent, this.wms, kmz);
        kml = superoverlay != false ? new SuperOverlayNetworkLinkBuilder(context).buildKMLDocument() : new SimpleNetworkLinkBuilder(context).buildKMLDocument();
        String mime = kmz ? "application/vnd.google-earth.kmz" : "application/vnd.google-earth.kml+xml";
        KMLMap map = new KMLMap(mapContent, null, kml, mime);
        map.setContentDispositionHeader(mapContent, kmz ? ".kmz" : ".kml");
        return map;
    }

    public MapProducerCapabilities getCapabilities(String format) {
        return KMLMapOutputFormat.KML_CAPABILITIES;
    }
}

