/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.kml.KMLTest;
import org.geoserver.kml.WFSKMLOutputFormat;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class KMLWFSTest
extends WFSTestSupport {
    protected void setUpNamespaces(Map<String, String> namespaces) {
        namespaces.put("kml", "http://www.opengis.net/kml/2.2");
    }

    @Test
    public void testGetCapabilities() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetCapabilities&version=1.1.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:Operation[@name='GetFeature']/ows:Parameter[@name='outputFormat']/ows:Value[text() = 'application/vnd.google-earth.kml+xml'])", (Document)doc);
    }

    @Test
    public void testGetFeature() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=" + this.getLayerId(MockData.AGGREGATEGEOFEATURE) + "&outputFormat=" + "application/vnd.google-earth.kml+xml".replace("+", "%2B"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)("inline; filename=" + MockData.AGGREGATEGEOFEATURE.getLocalPart() + ".kml"), (Object)response.getHeader("Content-Disposition"));
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        this.checkAggregateGeoFeatureKmlContents(doc);
    }

    @Test
    public void testGetFeatureKMLAlias() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=" + this.getLayerId(MockData.AGGREGATEGEOFEATURE) + "&outputFormat=KML");
        this.checkAggregateGeoFeatureKmlContents(doc);
    }

    private void checkAggregateGeoFeatureKmlContents(Document doc) throws Exception {
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Document/kml:Schema)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//kml:Document/kml:Schema/kml:SimpleField)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Document/kml:Schema/kml:SimpleField[@name='multiPointProperty'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Document/kml:Schema/kml:SimpleField[@name='multiCurveProperty'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Document/kml:Schema/kml:SimpleField[@name='multiSurfaceProperty'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"string", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='description']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"double", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='doubleProperty']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"int", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='intRangeProperty']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"string", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='strProperty']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"string", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='featureCode']/@type", (Document)doc);
        String sd = "//kml:Placemark[@id='AggregateGeoFeature.f005']/kml:ExtendedData/kml:SchemaData/kml:SimpleData";
        XMLAssert.assertXpathEvaluatesTo((String)"description-f005", (String)(sd + "[@name='description']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"name-f005", (String)(sd + "[@name='name']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2012.78", (String)(sd + "[@name='doubleProperty']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues.", (String)(sd + "[@name='strProperty']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"BK030", (String)(sd + "[@name='featureCode']"), (Document)doc);
    }

    @Test
    public void testForceWGS84() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=" + this.getLayerId(MockData.MPOINTS) + "&outputFormat=KML");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder)", (Document)doc);
        KMLTest.assertPointCoordinate(doc, "//kml:Placemark/kml:MultiGeometry/kml:Point[1]/kml:coordinates", -92.99707024070754, 4.523788746085423);
        KMLTest.assertPointCoordinate(doc, "//kml:Placemark/kml:MultiGeometry/kml:Point[2]/kml:coordinates", -92.99661950641159, 4.524241081543828);
    }

    @Test
    public void testCloseIterators() throws ServiceException, IOException {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.POLYGONS));
        FeatureSource fs = fti.getFeatureSource(null, null);
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fs.getFeatures();
        final AtomicInteger openIterators = new AtomicInteger(0);
        DecoratingSimpleFeatureCollection decorated = new DecoratingSimpleFeatureCollection(fc){

            public SimpleFeatureIterator features() {
                openIterators.incrementAndGet();
                final SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)this.delegate);
                return new SimpleFeatureIterator(){

                    public SimpleFeature next() throws NoSuchElementException {
                        return f;
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public void close() {
                        openIterators.decrementAndGet();
                    }
                };
            }
        };
        FeatureCollectionResponse fcResponse = this.getFeatureCollectionResponse((FeatureCollection)decorated);
        WFSKMLOutputFormat outputFormat = (WFSKMLOutputFormat)GeoServerExtensions.bean(WFSKMLOutputFormat.class);
        FilterOutputStream fos = new FilterOutputStream(new ByteArrayOutputStream()){
            int count;
            {
                this.count = 0;
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                for (int i = off; i < len; ++i) {
                    this.write(b[i]);
                }
            }

            @Override
            public void write(int b) throws IOException {
                ++this.count;
                if (this.count > 100) {
                    throw new IOException("Simularing client shutting down connection");
                }
                super.write(b);
            }
        };
        try {
            outputFormat.write(fcResponse, (OutputStream)fos, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)openIterators.get());
    }

    private FeatureCollectionResponse getFeatureCollectionResponse(FeatureCollection decorated) {
        FeatureCollectionType response = WfsFactory.eINSTANCE.createFeatureCollectionType();
        response.getFeature().add((Object)decorated);
        FeatureCollectionResponse fcResponse = FeatureCollectionResponse.adapt((Object)response);
        return fcResponse;
    }
}

