/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KMLTest
extends WMSTestSupport {
    public static QName BOULDER = new QName(MockData.SF_URI, "boulder", MockData.SF_PREFIX);
    private static final QName STORM_OBS = new QName(MockData.CITE_URI, "storm_obs", MockData.CITE_PREFIX);
    private static TimeZone oldTimeZone;
    XpathEngine xpath;

    @Before
    public void setUpXpath() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @BeforeClass
    public static void setTimeZone() {
        oldTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @AfterClass
    public static void clearTimeZone() {
        TimeZone.setDefault(oldTimeZone);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("notthere", "notthere.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("scaleRange", "scaleRange.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("outputMode", "outputMode.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addVectorLayer(STORM_OBS, Collections.emptyMap(), "storm_obs.properties", ((Object)((Object)this)).getClass(), catalog);
        HashMap<SystemTestData.LayerProperty, Object> properties = new HashMap<SystemTestData.LayerProperty, Object>();
        properties.put(SystemTestData.LayerProperty.LATLON_ENVELOPE, new ReferencedEnvelope(-105.336, -105.112, 39.9, 40.116, CRS.decode((String)"EPSG:4326")));
        properties.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope(3045967.0, 3108482.0, 1206627.0, 1285209.0, CRS.decode((String)"EPSG:2876")));
        properties.put(SystemTestData.LayerProperty.SRS, 2876);
        testData.addVectorLayer(BOULDER, properties, "boulder.properties", ((Object)((Object)this)).getClass(), catalog);
        String points = MockData.POINTS.getLocalPart();
        String lines = MockData.LINES.getLocalPart();
        String polygons = MockData.POLYGONS.getLocalPart();
        this.setNativeBox(catalog, points);
        this.setNativeBox(catalog, lines);
        this.setNativeBox(catalog, polygons);
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("layerGroup");
        lg.getLayers().add(catalog.getLayerByName(points));
        lg.getStyles().add(catalog.getStyleByName("point"));
        lg.getLayers().add(catalog.getLayerByName(lines));
        lg.getStyles().add(catalog.getStyleByName("line"));
        lg.getLayers().add(catalog.getLayerByName(polygons));
        lg.getStyles().add(catalog.getStyleByName("polygon"));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.BRIDGES));
        fti.setTitle("Bridges Title");
        fti.setAbstract("Bridges Abstract");
        catalog.save((ResourceInfo)fti);
        fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        fti.setTitle("Polygons Title");
        fti.setAbstract("");
        catalog.save((ResourceInfo)fti);
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        ci.setTitle("Tasmania DEM");
        ci.setAbstract(null);
        catalog.save((ResourceInfo)ci);
    }

    public void setNativeBox(Catalog catalog, String name) throws Exception {
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(name);
        fti.setNativeBoundingBox(fti.getFeatureSource(null, null).getBounds());
        fti.setLatLonBoundingBox(new ReferencedEnvelope((Envelope)fti.getNativeBoundingBox(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        catalog.save((ResourceInfo)fti);
    }

    @Test
    public void testLayerGroupWithPoints() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo lgi = cat.getLayerGroupByName("layerGroup");
        List layers = lgi.getLayers();
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + lgi.getName() + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((long)layers.size(), (long)doc.getElementsByTagName("Folder").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/kml/icon/point?0.0.0=", (String)"//kml:Folder[1]/kml:Placemark/kml:Style/kml:IconStyle/kml:Icon/kml:href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://icons.opengeo.org/markers/icon-line.1.png", (String)"//kml:Folder[2]/kml:Placemark/kml:Style/kml:IconStyle/kml:Icon/kml:href", (Document)doc);
    }

    @Test
    public void testVector() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((long)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures().size(), (long)doc.getElementsByTagName("Placemark").getLength());
    }

    @Test
    public void testReprojectedVector() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(BOULDER) + "&styles=&height=1024&width=1024&bbox=3045967,1206627,3108482,1285209&srs=EPSG:2876");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("Placemark").getLength());
        Assert.assertEquals((double)-105.2243, (double)Double.parseDouble(this.xpath.evaluate("//kml:Document/kml:LookAt/kml:longitude", doc)), (double)1.0E-4);
        Assert.assertEquals((double)40.0081, (double)Double.parseDouble(this.xpath.evaluate("//kml:Document/kml:LookAt/kml:latitude", doc)), (double)1.0E-4);
    }

    @Test
    public void testVectorScaleRange() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=scaleRange&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((long)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures().size(), (long)doc.getElementsByTagName("Placemark").getLength());
    }

    @Test
    public void testVectorWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureid=BasicPolygons.1107531493643");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("Placemark").getLength());
    }

    @Test
    public void testVectorWithSortByAscending() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&sortBy=FID A");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//kml:Placemark)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045088", (String)"//kml:Placemark[1]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045089", (String)"//kml:Placemark[2]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045089", (String)"//kml:Placemark[3]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045090", (String)"//kml:Placemark[4]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045091", (String)"//kml:Placemark[5]/@id", (Document)doc);
    }

    @Test
    public void testVectorWithSortByDescending() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&sortBy=FID D");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//kml:Placemark)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045091", (String)"//kml:Placemark[1]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045090", (String)"//kml:Placemark[2]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045089", (String)"//kml:Placemark[3]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045089", (String)"//kml:Placemark[4]/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045088", (String)"//kml:Placemark[5]/@id", (Document)doc);
    }

    @Test
    public void testBasicVector() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureId=RoadSegments.1107532045088");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045088", (String)"//kml:Placemark/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045088", (String)"//kml:Placemark/kml:name", (Document)doc);
        String expectedDescription = String.format("<h4>RoadSegments</h4>%n\n<ul class=\"textattributes\">\n  \n  <li><strong><span class=\"atr-name\">FID</span>:</strong> <span class=\"atr-value\">102</span></li>\n  <li><strong><span class=\"atr-name\">NAME</span>:</strong> <span class=\"atr-value\">Route 5</span></li>\n</ul>\n", new Object[0]);
        String actualDescription = this.xpath.evaluate("//kml:Placemark/kml:description", doc);
        this.assertEqualsIgnoreNewLineStyle(expectedDescription, actualDescription);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.0020000000000095497", (String)"//kml:Placemark/kml:LookAt/kml:longitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"5.000000003008154E-5", (String)"//kml:Placemark/kml:LookAt/kml:latitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"00ffffff", (String)"//kml:Placemark/kml:Style/kml:IconStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0.4", (String)"//kml:Placemark/kml:Style/kml:IconStyle/kml:scale", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://icons.opengeo.org/markers/icon-line.1.png", (String)"//kml:Placemark/kml:Style/kml:IconStyle/kml:Icon/kml:href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"00ffffff", (String)"//kml:Placemark/kml:Style/kml:LabelStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"ff000000", (String)"//kml:Placemark/kml:Style/kml:LineStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"4.0", (String)"//kml:Placemark/kml:Style/kml:LineStyle/kml:width", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.002000087662804264,4.997808429893395E-5", (String)"//kml:Placemark/kml:MultiGeometry/kml:Point/kml:coordinates", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.0042,-6.0E-4 -0.0032,-3.0E-4 -0.0026,-1.0E-4 -0.0014,2.0E-4 2.0E-4,7.0E-4", (String)"//kml:Placemark/kml:MultiGeometry/kml:LineString/kml:coordinates", (Document)doc);
    }

    @Test
    public void testLayerLookAt() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&height=1024&width=1024&bbox=-1.5,2,1.5,4&srs=EPSG:4326");
        XMLAssert.assertXpathEvaluatesTo((String)"-0.004885780703602904", (String)"//kml:Folder/kml:LookAt/kml:longitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"4.00243024094668", (String)"//kml:Folder/kml:LookAt/kml:latitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"777088.7971299331", (String)"//kml:Folder/kml:LookAt/kml:altitude", (Document)doc);
    }

    @Test
    public void testNoAttributes() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureId=RoadSegments.1107532045088&kmattr=false");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045088", (String)"//kml:Placemark/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark/kml:name)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark/kml:description)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.0020000000000095497", (String)"//kml:Placemark/kml:LookAt/kml:longitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"5.000000003008154E-5", (String)"//kml:Placemark/kml:LookAt/kml:latitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark/kml:Style/kml:IconStyle)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark/kml:Style/kml:LabelStyle)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"ff000000", (String)"//kml:Placemark/kml:Style/kml:LineStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"4.0", (String)"//kml:Placemark/kml:Style/kml:LineStyle/kml:width", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark/kml:MultiGeometry)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.0042,-6.0E-4 -0.0032,-3.0E-4 -0.0026,-1.0E-4 -0.0014,2.0E-4 2.0E-4,7.0E-4", (String)"//kml:Placemark/kml:LineString/kml:coordinates", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeTemplate() throws Exception {
        FeatureTypeInfo ftInfo = (FeatureTypeInfo)this.getCatalog().getResourceByName(this.getLayerId(MockData.OTHER), FeatureTypeInfo.class);
        File resourceDir = Resources.directory((Resource)this.getDataDirectory().get((ResourceInfo)ftInfo, new String[0]));
        File templateFile = new File(resourceDir, "time.ftl");
        try {
            FileUtils.writeStringToFile((File)templateFile, (String)"${dates.value}", (String)"UTF-8");
            Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.OTHER) + "&styles=&height=1024&width=1024&bbox= -96.0000,0.0000,-90.0000,84.0000&srs=EPSG:4326");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"2002-12-02T00:00:00Z", (String)"//kml:Placemark/kml:TimeStamp/kml:when", (Document)doc);
        }
        finally {
            Assert.assertTrue((boolean)templateFile.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeInvervalTemplate() throws Exception {
        FeatureTypeInfo ftInfo = (FeatureTypeInfo)this.getCatalog().getResourceByName(this.getLayerId(MockData.OTHER), FeatureTypeInfo.class);
        File resourceDir = Resources.directory((Resource)this.getDataDirectory().get((ResourceInfo)ftInfo, new String[0]));
        File templateFile = new File(resourceDir, "time.ftl");
        try {
            FileUtils.writeStringToFile((File)templateFile, (String)"${dates.value}||${dates.value}", (String)"UTF-8");
            Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.OTHER) + "&styles=&height=1024&width=1024&bbox= -96.0000,0.0000,-90.0000,84.0000&srs=EPSG:4326");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"2002-12-02T00:00:00Z", (String)"//kml:Placemark/kml:TimeSpan/kml:begin", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"2002-12-02T00:00:00Z", (String)"//kml:Placemark/kml:TimeSpan/kml:end", (Document)doc);
        }
        finally {
            Assert.assertTrue((boolean)templateFile.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeightTemplate() throws Exception {
        FeatureTypeInfo ftInfo = (FeatureTypeInfo)this.getCatalog().getResourceByName(this.getLayerId(MockData.OTHER), FeatureTypeInfo.class);
        File resourceDir = Resources.directory((Resource)this.getDataDirectory().get((ResourceInfo)ftInfo, new String[0]));
        File templateFile = new File(resourceDir, "height.ftl");
        try {
            FileUtils.writeStringToFile((File)templateFile, (String)"200", (String)"UTF-8");
            Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.OTHER) + "&styles=&height=1024&width=1024&bbox= -96.0000,0.0000,-90.0000,84.0000&srs=EPSG:4326");
            KMLTest.assertPointCoordinate(doc, "//kml:Placemark/kml:Point/kml:coordinates", -92.99954926766114, 4.52401492058674, 200.0);
        }
        finally {
            Assert.assertTrue((boolean)templateFile.delete());
        }
    }

    public static void assertPointCoordinate(Document doc, String path, double ... expected) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String coordinates = xpath.evaluate(path, doc);
        MatcherAssert.assertThat((Object)coordinates, (Matcher)Matchers.not((Matcher)Matchers.emptyString()));
        double[] ordinates = Arrays.stream(coordinates.split("\\s*,\\s*")).mapToDouble(Double::parseDouble).toArray();
        Assert.assertEquals((long)expected.length, (long)ordinates.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)ordinates[i], (double)1.0E-6);
        }
    }

    @Test
    public void testVectorWithRemoteLayer() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=topp:states&styles=Default&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&remote_ows_type=wfs&remote_ows_url=http://demo.opengeo.org/geoserver/wfs?&cql_filter=PERSONS>20000000");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("Placemark").getLength());
    }

    @Test
    public void testMissingGraphic() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BRIDGES) + "&styles=notthere&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("Placemark").getLength());
    }

    @Test
    public void testContentDisposition() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kmz&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((Object)"attachment; filename=cite-BasicPolygons.kmz", (Object)resp.getHeader("Content-Disposition"));
    }

    @Test
    public void testEncodeTime() throws Exception {
        this.setupTemplate(STORM_OBS, "time.ftl", "${obs_datetime.value}");
        String doc = this.getAsString("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(STORM_OBS) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureId=storm_obs.1321870537475");
        Assert.assertTrue((boolean)doc.contains("<when>1994-07-0"));
    }

    @Test
    public void testKmltitleFormatOption() throws Exception {
        String kmlRequest = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BRIDGES) + "&styles=notthere&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&format_options=kmltitle:myCustomLayerTitle";
        Document doc = this.getAsDOM(kmlRequest);
        this.print(doc);
        Assert.assertEquals((Object)"name", (Object)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getLocalName());
        Assert.assertEquals((Object)"myCustomLayerTitle", (Object)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getTextContent());
    }

    @Test
    public void testKmltitleFormatOptionWithMultipleLayers() throws Exception {
        String kmlRequest = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BRIDGES) + "," + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=notthere," + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&format_options=kmltitle:myCustomLayerTitle";
        Document doc = this.getAsDOM(kmlRequest);
        this.print(doc);
        Assert.assertEquals((Object)"name", (Object)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getLocalName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("Document").getLength());
        Assert.assertEquals((long)2L, (long)doc.getElementsByTagName("Folder").getLength());
        Assert.assertEquals((Object)"myCustomLayerTitle", (Object)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getTextContent());
    }

    @Test
    public void testFolderAndOverlayNamesAndDescriptions() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BRIDGES) + "," + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        XMLAssert.assertXpathEvaluatesTo((String)"Bridges Title", (String)"//kml:Folder[1]/kml:name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Bridges Abstract", (String)"//kml:Folder[1]/kml:description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Polygons Title", (String)"//kml:Folder[2]/kml:name", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"//kml:Folder[2]/kml:description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Tasmania DEM", (String)"//kml:Folder[3]/kml:name", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"//kml:Folder[3]/kml:description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Tasmania DEM", (String)"//kml:Folder[3]/kml:GroundOverlay/kml:name", (Document)doc);
    }

    @Test
    public void testRelativeLinks() throws Exception {
        String kmlRequest = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&format_options=rellinks:true";
        Document dom = this.getAsDOM(kmlRequest + "&startIndex=0&maxFeatures=1");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder/kml:NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"next", (String)"//kml:Folder/kml:NetworkLink/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Next page", (String)"//kml:Folder/kml:NetworkLink/kml:description", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/cite/BasicPolygons.kml?startindex=1&maxfeatures=1", (String)"//kml:Folder/kml:NetworkLink/kml:Link/kml:href", (Document)dom);
        dom = this.getAsDOM(kmlRequest + "&startIndex=1&maxFeatures=1");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//kml:Folder/kml:NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"prev", (String)"//kml:Folder/kml:NetworkLink[1]/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Previous page", (String)"//kml:Folder/kml:NetworkLink[1]/kml:description", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/cite/BasicPolygons.kml?startindex=0&maxfeatures=1", (String)"//kml:Folder/kml:NetworkLink[1]/kml:Link/kml:href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"next", (String)"//kml:Folder/kml:NetworkLink[2]/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Next page", (String)"//kml:Folder/kml:NetworkLink[2]/kml:description", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/cite/BasicPolygons.kml?startindex=2&maxfeatures=1", (String)"//kml:Folder/kml:NetworkLink[2]/kml:Link/kml:href", (Document)dom);
    }

    @Test
    public void testForceGroundOverlay() throws Exception {
        Document dom = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&format_options=mode:refresh;kmscore:0;autofit:true");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:GroundOverlay)", (Document)dom);
        String pngOverlay = "http://localhost:8080/geoserver/wms?service=wms&request=GetMap&version=1.1.1&format=image%2Fpng&layers=cite%3ABasicPolygons&styles=BasicPolygons&height=512&width=1024&transparent=true&bbox=-180.0%2C-90.0%2C180.0%2C90.0&srs=EPSG%3A4326&format_options=AUTOFIT%3Atrue%3BKMSCORE%3A0%3BMODE%3Arefresh";
        XMLAssert.assertXpathEvaluatesTo((String)pngOverlay, (String)"//kml:GroundOverlay/kml:Icon/kml:href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-180.0", (String)"//kml:GroundOverlay/kml:LatLonBox/kml:west", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"180.0", (String)"//kml:GroundOverlay/kml:LatLonBox/kml:east", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"90.0", (String)"//kml:GroundOverlay/kml:LatLonBox/kml:north", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-90.0", (String)"//kml:GroundOverlay/kml:LatLonBox/kml:south", (Document)dom);
    }

    @Test
    public void testOutputModeVector() throws Exception {
        Document dom = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=outputMode&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&format_options=kmscore:100&featureid=BasicPolygons.1107531493644");
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:GroundOverlay)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/styles/bridge.png", (String)"//kml:Placemark/kml:Style/kml:IconStyle/kml:Icon/kml:href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.5,3.5", (String)"//kml:Placemark/kml:MultiGeometry/kml:Point/kml:coordinates", (Document)dom);
    }

    @Test
    public void testRasterLayer() throws Exception {
        Document dom = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:GroundOverlay)", (Document)dom);
        String pngOverlay = "http://localhost:8080/geoserver/wms?service=wms&request=GetMap&version=1.1.1&format=image%2Fpng&layers=wcs%3ADEM&styles=raster&height=1024&width=1024&transparent=true&bbox=-180.0%2C-90.0%2C180.0%2C90.0&srs=EPSG%3A4326";
        XMLAssert.assertXpathEvaluatesTo((String)pngOverlay, (String)"//kml:GroundOverlay/kml:Icon/kml:href", (Document)dom);
    }

    @Test
    public void testKMZMixed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kmz&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.WORLD) + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + ",&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&format_options=kmscore:100");
        Assert.assertEquals((Object)"application/vnd.google-earth.kmz", (Object)response.getContentType());
        ByteArrayInputStream bis = this.getBinaryInputStream(response);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry entry = zis.getNextEntry();
        Assert.assertEquals((Object)"wms.kml", (Object)entry.getName());
        byte[] data = IOUtils.toByteArray((InputStream)zis);
        Document dom = this.dom(new ByteArrayInputStream(data));
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//kml:Folder[1]/kml:Placemark)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Folder[1]/kml:GroundOverlay)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Folder[2]/kml:Placemark)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder[2]/kml:GroundOverlay)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"images/layers_1.png", (String)"//kml:Folder[2]/kml:GroundOverlay/kml:Icon/kml:href", (Document)dom);
        zis.closeEntry();
        entry = zis.getNextEntry();
        Assert.assertEquals((Object)"images/", (Object)entry.getName());
        zis.closeEntry();
        entry = zis.getNextEntry();
        Assert.assertEquals((Object)"images/layers_1.png", (Object)entry.getName());
        zis.closeEntry();
        Assert.assertNull((Object)zis.getNextEntry());
    }

    @Test
    public void testProjectedGroundOverlayWithPlacemarks() throws Exception {
        Document dom = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(BOULDER) + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + ",&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&format_options=mode:refresh;kmscore:0;kmplacemark:true");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder[1]/kml:GroundOverlay)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder[1]/kml:Placemark)", (Document)dom);
        Element pm = this.getFirstElementByTagName(dom, "Placemark");
        Assert.assertNotNull((Object)pm);
        Element point = this.getFirstElementByTagName(pm, "Point");
        Assert.assertNotNull((Object)point);
        String[] coords = this.getFirstElementByTagName(point, "coordinates").getFirstChild().getTextContent().split(",");
        double[] p = new double[]{Double.parseDouble(coords[0]), Double.parseDouble(coords[1])};
        Assert.assertEquals((double)-105.2, (double)p[0], (double)0.1);
        Assert.assertEquals((double)40.0, (double)p[1], (double)0.1);
    }

    @Test
    public void testPointLayerGroupVector() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureId=RoadSegments.1107532045088");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045088", (String)"//kml:Placemark/@id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"RoadSegments.1107532045088", (String)"//kml:Placemark/kml:name", (Document)doc);
        String expectedDescription = String.format("<h4>RoadSegments</h4>%n\n<ul class=\"textattributes\">\n  \n  <li><strong><span class=\"atr-name\">FID</span>:</strong> <span class=\"atr-value\">102</span></li>\n  <li><strong><span class=\"atr-name\">NAME</span>:</strong> <span class=\"atr-value\">Route 5</span></li>\n</ul>\n", new Object[0]);
        String actualDescription = this.xpath.evaluate("//kml:Placemark/kml:description", doc);
        this.assertEqualsIgnoreNewLineStyle(expectedDescription, actualDescription);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.0020000000000095497", (String)"//kml:Placemark/kml:LookAt/kml:longitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"5.000000003008154E-5", (String)"//kml:Placemark/kml:LookAt/kml:latitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"00ffffff", (String)"//kml:Placemark/kml:Style/kml:IconStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0.4", (String)"//kml:Placemark/kml:Style/kml:IconStyle/kml:scale", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://icons.opengeo.org/markers/icon-line.1.png", (String)"//kml:Placemark/kml:Style/kml:IconStyle/kml:Icon/kml:href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"00ffffff", (String)"//kml:Placemark/kml:Style/kml:LabelStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"ff000000", (String)"//kml:Placemark/kml:Style/kml:LineStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"4.0", (String)"//kml:Placemark/kml:Style/kml:LineStyle/kml:width", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.002000087662804264,4.997808429893395E-5", (String)"//kml:Placemark/kml:MultiGeometry/kml:Point/kml:coordinates", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.0042,-6.0E-4 -0.0032,-3.0E-4 -0.0026,-1.0E-4 -0.0014,2.0E-4 2.0E-4,7.0E-4", (String)"//kml:Placemark/kml:MultiGeometry/kml:LineString/kml:coordinates", (Document)doc);
    }
}

