/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.kml.RegionatingTestSupport;
import org.geoserver.kml.regionate.CachedHierarchyRegionatingStrategy;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GeoSearchKMLTest
extends RegionatingTestSupport {
    @Before
    public void resetMetadata() throws IOException {
        FeatureTypeInfo fti = this.getFeatureTypeInfo(TILE_TESTS);
        fti.getMetadata().remove((Object)"kml.regionateFeatureLimit");
        this.getCatalog().save((ResourceInfo)fti);
    }

    @After
    public void cleanupRegionationDatabases() throws IOException, SQLException {
        File dir = this.getDataDirectory().findOrCreateDir(new String[]{"geosearch"});
        CachedHierarchyRegionatingStrategy.clearAllHsqlDatabases((File)dir);
        FileUtils.deleteDirectory((File)dir);
    }

    @Test
    public void testSelfLinks() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,0,90&srs=EPSG:4326&featureid=BasicPolygons.1107531493643&format_options=selfLinks:true";
        Document document = this.getAsDOM(path);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder/kml:Placemark)", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/cite/BasicPolygons/1107531493643.kml", (String)"//kml:Placemark/atom:link/@href", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"self", (String)"//kml:Placemark/atom:link/@rel", (Document)document);
    }

    @Test
    public void testDataRegionator() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326&format_options=regionateBy:external-sorting;regionateAttr:NUM_LANES";
        Document document = this.getAsDOM(path + "&bbox=-180,-90,0,90");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getTagName());
        int westCount = document.getDocumentElement().getElementsByTagName("Placemark").getLength();
        this.assertStatusCodeForGet(204, path + "&bbox=0,-90,180,90");
        Assert.assertEquals((long)1L, (long)westCount);
    }

    @Test
    public void testGeometryRegionator() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326&format_options=regionateBy:geometry;regionateAttr:the_geom";
        Document document = this.getAsDOM(path + "&bbox=-180,-90,0,90");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getTagName());
        Assert.assertEquals((long)1L, (long)document.getDocumentElement().getElementsByTagName("Placemark").getLength());
        this.assertStatusCodeForGet(204, path + "&bbox=0,-90,180,90");
    }

    @Test
    public void testRandomRegionator() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326&format_options=regionateBy:random";
        Document document = this.getAsDOM(path + "&bbox=-180,-90,0,90");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getTagName());
        Assert.assertEquals((long)1L, (long)document.getDocumentElement().getElementsByTagName("Placemark").getLength());
        this.assertStatusCodeForGet(204, path + "&bbox=0,-90,180,90");
    }

    @Test
    public void testBogusRegionator() throws Exception {
        Logging.getLogger((String)"org.geoserver.ows").setLevel(Level.OFF);
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326&format_options=regionateBy:bogus";
        Document document = this.getAsDOM(path + "&bbox=0,-90,180,90", true);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)document.getDocumentElement().getTagName());
    }

    @Test
    public void testBigGeometries() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + CENTERED_POLY.getPrefix() + ":" + CENTERED_POLY.getLocalPart() + "&styles=&height=1024&width=1024&srs=EPSG:4326&format_options=regionateBy:external-sorting;regionateattr:foo";
        this.assertStatusCodeForGet(204, path + "&bbox=-180,-90,0,90");
        Document document = this.getAsDOM(path + "&bbox=0,-90,180,90");
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getTagName());
        Assert.assertEquals((long)1L, (long)document.getDocumentElement().getElementsByTagName("Placemark").getLength());
    }

    @Test
    public void testStrategyChangesStuff() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + TILE_TESTS.getPrefix() + ":" + TILE_TESTS.getLocalPart() + "&bbox=-180,-90,0,90&styles=&height=1024&width=1024&srs=EPSG:4326";
        FeatureTypeInfo fti = this.getFeatureTypeInfo(TILE_TESTS);
        fti.getMetadata().put("kml.regionateFeatureLimit", (Serializable)Integer.valueOf(2));
        this.getCatalog().save((ResourceInfo)fti);
        Document geo = this.getAsDOM(path + "&format_options=regionateBy:geometry;regionateattr:location");
        Assert.assertEquals((Object)"kml", (Object)geo.getDocumentElement().getTagName());
        NodeList geoPlacemarks = geo.getDocumentElement().getElementsByTagName("Placemark");
        Assert.assertEquals((long)2L, (long)geoPlacemarks.getLength());
        Document data = this.getAsDOM(path + "&format_options=regionateBy:external-sorting;regionateAttr:z");
        Assert.assertEquals((Object)"kml", (Object)data.getDocumentElement().getTagName());
        NodeList dataPlacemarks = data.getDocumentElement().getElementsByTagName("Placemark");
        Assert.assertEquals((long)2L, (long)dataPlacemarks.getLength());
        for (int i = 0; i < geoPlacemarks.getLength(); ++i) {
            String geoName = ((Element)geoPlacemarks.item(i)).getAttribute("id");
            String dataName = ((Element)dataPlacemarks.item(i)).getAttribute("id");
            Assert.assertNotEquals((String)(geoName + " and " + dataName + " should not be the same!"), (Object)geoName, (Object)dataName);
        }
    }

    @Test
    public void testDuplicateAttribute() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + TILE_TESTS.getPrefix() + ":" + TILE_TESTS.getLocalPart() + "&bbox=-180,-90,0,90&styles=&height=1024&width=1024&srs=EPSG:4326";
        FeatureTypeInfo fti = this.getFeatureTypeInfo(TILE_TESTS);
        fti.getMetadata().put("kml.regionateFeatureLimit", (Serializable)Integer.valueOf(2));
        Document geo = this.getAsDOM(path + "&format_options=regionateBy:best_guess;regionateattr:the_geom");
        Assert.assertEquals((Object)"kml", (Object)geo.getDocumentElement().getTagName());
    }
}

