/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.iterator;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geoserver.kml.iterator.IteratorFactory;

public class IteratorList<T>
extends AbstractList<T> {
    IteratorFactory<T> generatorFactory;

    public IteratorList(IteratorFactory<T> generatorFactory) {
        this.generatorFactory = generatorFactory;
    }

    @Override
    public Iterator<T> iterator() {
        return new GeneratorIterator<T>(this.generatorFactory.newIterator());
    }

    @Override
    public T get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return -1;
    }

    public static class GeneratorIterator<T>
    implements Iterator<T> {
        private Iterator<T> generator;

        public GeneratorIterator(Iterator<T> generator) {
            this.generator = generator;
        }

        @Override
        public boolean hasNext() {
            return this.generator.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.generator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

