/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Link;
import de.micromata.opengis.kml.v_2_2_0.NetworkLink;
import java.io.IOException;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.AbstractGeoSearchDecorator;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSInfo;

public class FolderRelativeLinksDecoratorFactory
implements KmlDecoratorFactory {
    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return null;
        }
        if (!featureClass.equals(Folder.class)) {
            return null;
        }
        GetMapRequest request = context.getRequest();
        String relLinks = (String)request.getFormatOptions().get("relLinks");
        if (request.getMaxFeatures() != null && relLinks != null && relLinks.equalsIgnoreCase("true")) {
            return new FolderRelativeLinksDecorator();
        }
        return null;
    }

    static class FolderRelativeLinksDecorator
    extends AbstractGeoSearchDecorator {
        FolderRelativeLinksDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            if (context.getCurrentLayer() == null || context.getCurrentFeatureCollection() == null) {
                return feature;
            }
            Folder folder = (Folder)feature;
            Object linkbase = "";
            try {
                linkbase = this.getFeatureTypeURL(context);
                linkbase = (String)linkbase + ".kml";
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            GetMapRequest request = context.getRequest();
            int maxFeatures = request.getMaxFeatures();
            int startIndex = request.getStartIndex() == null ? 0 : request.getStartIndex();
            int prevStart = startIndex - maxFeatures;
            int nextStart = startIndex + maxFeatures;
            if (prevStart >= 0) {
                this.encodeSequentialNetworkLink(folder, (String)linkbase, prevStart, maxFeatures, "prev", "Previous page");
            }
            if (context.getCurrentFeatureCollection().size() >= maxFeatures) {
                this.encodeSequentialNetworkLink(folder, (String)linkbase, nextStart, maxFeatures, "next", "Next page");
            }
            return folder;
        }

        private void encodeSequentialNetworkLink(Folder folder, String linkbase, int start, int maxFeatures, String id, String readableName) {
            NetworkLink nl = folder.createAndAddNetworkLink();
            Link link = nl.createAndSetLink();
            link.setHref(linkbase + "?startindex=" + start + "&maxfeatures=" + maxFeatures);
            nl.setDescription(readableName);
            nl.setId(id);
        }
    }
}

