/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.geoserver.kml.utils.KmlCentroidBuilder;
import org.geoserver.kml.utils.KmlCentroidOptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class KmlCentroidBuilderTest {
    Geometry cShapeGeom;

    @Before
    public void setUp() throws Exception {
        this.cShapeGeom = new WKTReader().read("POLYGON ((-112.534433451864 43.8706532611928,-112.499157652296 44.7878240499628,-99.6587666095152 44.7878240499628,-99.7242788087131 43.2155312692142,-111.085391877449 43.099601544023,-110.744593363875 36.1862602686501,-98.6760836215473 35.9436771582516,-98.7415958207452 33.5197257879307,-111.77852346112 33.9783111823157,-111.758573671673 34.6566040234952,-113.088767445077 34.7644575726901,-113.023255245879 43.8706532611928,-112.534433451864 43.8706532611928))");
    }

    @Test
    public void testSampleForPoint() throws Exception {
        Geometry g = this.cShapeGeom;
        KmlCentroidOptions opts1 = KmlCentroidOptions.create((Map)ImmutableMap.of((Object)"kmcentroid_contain", (Object)"true", (Object)"kmcentroid_sample", (Object)"2"));
        KmlCentroidOptions opts2 = KmlCentroidOptions.create((Map)ImmutableMap.of((Object)"kmcentroid_contain", (Object)"true", (Object)"kmcentroid_sample", (Object)"10"));
        KmlCentroidBuilder builder = new KmlCentroidBuilder();
        Coordinate c = builder.geometryCentroid(g, null, opts1);
        Assert.assertFalse((boolean)g.contains((Geometry)g.getFactory().createPoint(c)));
        c = builder.geometryCentroid(g, null, opts2);
        Assert.assertTrue((boolean)g.contains((Geometry)g.getFactory().createPoint(c)));
    }

    @Test
    public void testClip() {
        Geometry g = this.cShapeGeom;
        KmlCentroidOptions opts1 = KmlCentroidOptions.create((Map)ImmutableMap.of());
        KmlCentroidOptions opts2 = KmlCentroidOptions.create((Map)ImmutableMap.of((Object)"kmcentroid_clip", (Object)"true"));
        opts2.isClip();
        KmlCentroidBuilder builder = new KmlCentroidBuilder();
        Coordinate c = builder.geometryCentroid(g, null, opts1);
        Assert.assertFalse((boolean)g.contains((Geometry)g.getFactory().createPoint(c)));
        Envelope bbox = new Envelope(-106.603059724489, -103.655010760585, 34.6334331742943, 36.9918723454173);
        c = builder.geometryCentroid(g, bbox, opts2);
        Assert.assertTrue((boolean)g.contains((Geometry)g.getFactory().createPoint(c)));
    }

    @Test
    public void testCaseInsensitivity() {
        KmlCentroidOptions opts = KmlCentroidOptions.create((Map)ImmutableMap.of((Object)"kmcentroid_contain".toUpperCase(), (Object)"true", (Object)"kmcentroid_clip".toUpperCase(), (Object)"true", (Object)"kmcentroid_sample".toUpperCase(), (Object)"12"));
        Assert.assertTrue((boolean)opts.isContain());
        Assert.assertTrue((boolean)opts.isClip());
        Assert.assertEquals((long)12L, (long)opts.getSamples());
    }
}

