/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wmts;

import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.util.InternationalStringUtils;
import org.geowebcache.config.meta.ServiceContact;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.config.meta.ServiceProvider;
import org.geowebcache.service.wmts.WMTSExtensionImpl;

public class WMTSCapabilitiesProvider
extends WMTSExtensionImpl {
    private final GeoServer geoserver;

    public WMTSCapabilitiesProvider(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    public ServiceInformation getServiceInformation() {
        String onlineResource;
        WMTSInfo gsInfo = (WMTSInfo)this.geoserver.getService(WMTSInfo.class);
        ContactInfo gsContactInfo = this.geoserver.getSettings().getContact();
        ServiceInformation gwcInfo = new ServiceInformation();
        gwcInfo.setTitle(gsInfo.getTitle());
        gwcInfo.setTitle(gsInfo.getTitle());
        gwcInfo.setDescription(gsInfo.getAbstract());
        gwcInfo.getKeywords().addAll(gsInfo.keywordValues());
        gwcInfo.setFees(gsInfo.getFees());
        gwcInfo.setAccessConstraints(gsInfo.getAccessConstraints());
        ServiceProvider serviceProvider = new ServiceProvider();
        String providerName = InternationalStringUtils.firstNonBlank((String[])new String[]{gsInfo.getMaintainer(), gsContactInfo.getContactOrganization()});
        if (providerName != null) {
            serviceProvider.setProviderName(providerName);
        }
        if ((onlineResource = InternationalStringUtils.firstNonBlank((String[])new String[]{gsInfo.getOnlineResource(), gsContactInfo != null ? gsContactInfo.getOnlineResource() : null, gsInfo.getGeoServer().getSettings().getOnlineResource()})) != null) {
            serviceProvider.setProviderSite(onlineResource);
        }
        if (gsContactInfo != null) {
            ServiceContact gwcContactInfo = new ServiceContact();
            gwcContactInfo.setIndividualName(gsContactInfo.getContactPerson());
            gwcContactInfo.setPositionName(gsContactInfo.getContactPosition());
            gwcContactInfo.setAddressType(gsContactInfo.getAddressType());
            gwcContactInfo.setAddressStreet(gsContactInfo.getAddress());
            gwcContactInfo.setAddressCity(gsContactInfo.getAddressCity());
            gwcContactInfo.setAddressPostalCode(gsContactInfo.getAddressPostalCode());
            gwcContactInfo.setAddressCountry(gsContactInfo.getAddressCountry());
            gwcContactInfo.setPhoneNumber(gsContactInfo.getContactVoice());
            gwcContactInfo.setFaxNumber(gsContactInfo.getContactFacsimile());
            gwcContactInfo.setAddressEmail(gsContactInfo.getContactEmail());
            serviceProvider.setServiceContact(gwcContactInfo);
        }
        gwcInfo.setServiceProvider(serviceProvider);
        gwcInfo.setCiteCompliant(gsInfo.isCiteCompliant());
        return gwcInfo;
    }
}

