/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.seed;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.geoserver.threadlocals.ThreadLocalsTransfer;
import org.geowebcache.seed.SeederThreadPoolExecutor;

public class SeederThreadLocalTransferExecutor
extends SeederThreadPoolExecutor {
    public SeederThreadLocalTransferExecutor(int corePoolSize, int maxPoolSize) {
        super(corePoolSize, maxPoolSize);
    }

    public Future<?> submit(Runnable task) {
        ThreadLocalsTransfer threadLocalTransfer = new ThreadLocalsTransfer();
        return super.submit(() -> {
            threadLocalTransfer.apply();
            try {
                task.run();
            }
            finally {
                threadLocalTransfer.cleanup();
            }
        });
    }

    public <T> Future<T> submit(Callable<T> task) {
        ThreadLocalsTransfer threadLocalTransfer = new ThreadLocalsTransfer();
        return super.submit(() -> {
            threadLocalTransfer.apply();
            try {
                Object v = task.call();
                return v;
            }
            finally {
                threadLocalTransfer.cleanup();
            }
        });
    }

    public <T> Future<T> submit(Runnable task, T result) {
        ThreadLocalsTransfer threadLocalTransfer = new ThreadLocalsTransfer();
        return super.submit(() -> {
            threadLocalTransfer.apply();
            try {
                task.run();
                Object object = result;
                return object;
            }
            finally {
                threadLocalTransfer.cleanup();
            }
        });
    }
}

