/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wmts;

import java.io.InputStream;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.gwc.wmts.WMTSXStreamLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class WMTSXStreamLoaderTest
extends GeoServerSystemTestSupport {
    @Test
    public void testLoadSimpleConfiguration() throws Exception {
        XStreamPersisterFactory factory = (XStreamPersisterFactory)GeoServerExtensions.bean(XStreamPersisterFactory.class);
        XStreamPersister xp = factory.createXMLPersister();
        WMTSXStreamLoader loader = (WMTSXStreamLoader)GeoServerExtensions.bean(WMTSXStreamLoader.class);
        loader.initXStreamPersister(xp, this.getGeoServer());
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/wmts-test.xml");){
            WMTSInfo serviceInfo = loader.initialize((WMTSInfo)xp.load(is, WMTSInfo.class));
            MatcherAssert.assertThat((Object)serviceInfo.getId(), (Matcher)Matchers.is((Object)"WMTS-TEST"));
            MatcherAssert.assertThat((Object)serviceInfo.isEnabled(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)serviceInfo.getType(), (Matcher)Matchers.is((Object)"WMTS"));
            MatcherAssert.assertThat((Object)serviceInfo.getName(), (Matcher)Matchers.is((Object)"GeoServer WMTS"));
            MatcherAssert.assertThat((Object)serviceInfo.getTitle(), (Matcher)Matchers.is((Object)"GeoServer Web Map Tile Service"));
            MatcherAssert.assertThat((Object)serviceInfo.getMaintainer(), (Matcher)Matchers.is((Object)"geoserver"));
            MatcherAssert.assertThat((Object)serviceInfo.getAbstract(), (Matcher)Matchers.is((Object)"Testing the WMTS service."));
            MatcherAssert.assertThat((Object)serviceInfo.getAccessConstraints(), (Matcher)Matchers.is((Object)"SOME"));
            MatcherAssert.assertThat((Object)serviceInfo.getFees(), (Matcher)Matchers.is((Object)"MONEY"));
            MatcherAssert.assertThat((Object)serviceInfo.getOnlineResource(), (Matcher)Matchers.is((Object)"http://geoserver.org"));
            MatcherAssert.assertThat((Object)serviceInfo.getSchemaBaseURL(), (Matcher)Matchers.is((Object)"http://schemas.opengis.net"));
        }
    }
}

