/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCSynchEnv;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.ows.LocalWorkspace;
import org.geotools.api.feature.type.FeatureType;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CatalogConfigurationTest {
    private Catalog catalog;
    private TileLayerCatalog tileLayerCatalog;
    private GridSetBroker gridSetBroker;
    private CatalogConfiguration config;
    private LayerInfo layer1;
    private LayerInfo layer2;
    private LayerInfo layerWithNoTileLayer;
    private LayerGroupInfo group1;
    private LayerGroupInfo group2;
    private LayerGroupInfo groupWithNoTileLayer;
    private GeoServerTileLayerInfo layerInfo1;
    private GeoServerTileLayerInfo layerInfo2;
    private GeoServerTileLayerInfo groupInfo1;
    private GeoServerTileLayerInfo groupInfo2;
    private GWC mockMediator;
    private GWCSynchEnv mockGWCSynchEnv;
    private GWCConfig defaults;

    @Before
    public void setUp() throws Exception {
        this.defaults = GWCConfig.getOldDefaults();
        this.defaults.getDefaultVectorCacheFormats().clear();
        this.defaults.getDefaultVectorCacheFormats().add("image/png8");
        this.defaults.getDefaultOtherCacheFormats().clear();
        this.defaults.getDefaultOtherCacheFormats().add("image/jpeg");
        this.defaults.setCacheLayersByDefault(false);
        this.defaults.setCacheNonDefaultStyles(true);
        this.layer1 = GWCTestHelpers.mockLayer("layer1", "test", new String[0], PublishedType.RASTER);
        this.layer2 = GWCTestHelpers.mockLayer("layer2", "test", new String[0], PublishedType.RASTER);
        this.layerWithNoTileLayer = GWCTestHelpers.mockLayer("layerWithNoTileLayer", new String[0], PublishedType.RASTER);
        this.group1 = GWCTestHelpers.mockGroup("group1", new PublishedInfo[]{this.layer1, this.layer2});
        this.group2 = GWCTestHelpers.mockGroup("group2", new PublishedInfo[]{this.layer2, this.layer1});
        this.groupWithNoTileLayer = GWCTestHelpers.mockGroup("groupWithNoTileLayer", new PublishedInfo[]{this.layerWithNoTileLayer, this.layer1, this.layer2});
        this.layerInfo1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer1, (GWCConfig)this.defaults);
        this.layerInfo1.setMetaTilingX(1);
        this.layerInfo1.setMetaTilingY(1);
        this.layerInfo2 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer2, (GWCConfig)this.defaults);
        this.layerInfo2.setMetaTilingX(2);
        this.layerInfo2.setMetaTilingY(2);
        this.groupInfo1 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.group1, (GWCConfig)this.defaults);
        this.groupInfo1.setMetaTilingX(3);
        this.groupInfo1.setMetaTilingY(3);
        this.groupInfo2 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.group2, (GWCConfig)this.defaults);
        this.groupInfo2.setMetaTilingX(4);
        this.groupInfo2.setMetaTilingY(4);
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)this.catalog.getLayers()).thenReturn((Object)ImmutableList.of((Object)this.layer1, (Object)this.layerWithNoTileLayer, (Object)this.layer2));
        Mockito.when((Object)this.catalog.getLayer(this.layer1.getId())).thenReturn((Object)this.layer1);
        Mockito.when((Object)this.catalog.getLayer(this.layer2.getId())).thenReturn((Object)this.layer2);
        Mockito.when((Object)this.catalog.getLayerGroup(this.group1.getId())).thenReturn((Object)this.group1);
        Mockito.when((Object)this.catalog.getLayerGroup(this.group2.getId())).thenReturn((Object)this.group2);
        Mockito.when((Object)this.catalog.getLayerGroups()).thenReturn((Object)ImmutableList.of((Object)this.group1, (Object)this.groupWithNoTileLayer, (Object)this.group2));
        Mockito.when((Object)this.catalog.getLayerByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerInfo)this.layer1)))).thenReturn((Object)this.layer1);
        Mockito.when((Object)this.catalog.getLayerByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerInfo)this.layer2)))).thenReturn((Object)this.layer2);
        Mockito.when((Object)this.catalog.getLayerByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerInfo)this.layerWithNoTileLayer)))).thenReturn((Object)this.layerWithNoTileLayer);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)this.group1)))).thenReturn((Object)this.group1);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)this.group2)))).thenReturn((Object)this.group2);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)this.groupWithNoTileLayer)))).thenReturn((Object)this.groupWithNoTileLayer);
        this.gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        ImmutableSet layerNames = ImmutableSet.of((Object)GWC.tileLayerName((LayerInfo)this.layer1), (Object)GWC.tileLayerName((LayerInfo)this.layer2), (Object)GWC.tileLayerName((LayerGroupInfo)this.group1), (Object)GWC.tileLayerName((LayerGroupInfo)this.group2));
        this.tileLayerCatalog = (TileLayerCatalog)Mockito.mock(TileLayerCatalog.class);
        Mockito.when((Object)this.tileLayerCatalog.getLayerIds()).thenReturn((Object)ImmutableSet.of((Object)this.layer1.getId(), (Object)this.layer2.getId(), (Object)this.group1.getId(), (Object)this.group2.getId()));
        Mockito.when((Object)this.tileLayerCatalog.getLayerNames()).thenReturn((Object)layerNames);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.layer1.getId())).thenReturn((Object)this.layerInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.layer2.getId())).thenReturn((Object)this.layerInfo2);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.group1.getId())).thenReturn((Object)this.groupInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.group2.getId())).thenReturn((Object)this.groupInfo2);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.layer1.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.layer2.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.group1.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.group2.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerInfo)this.layer1))).thenReturn((Object)this.layerInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerInfo)this.layer2))).thenReturn((Object)this.layerInfo2);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerGroupInfo)this.group1))).thenReturn((Object)this.groupInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerGroupInfo)this.group2))).thenReturn((Object)this.groupInfo2);
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerInfo)this.layer1))).thenReturn((Object)this.layer1.getId());
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerInfo)this.layer2))).thenReturn((Object)this.layer2.getId());
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerGroupInfo)this.group1))).thenReturn((Object)this.group1.getId());
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerGroupInfo)this.group2))).thenReturn((Object)this.group2.getId());
        this.config = new CatalogConfiguration(this.catalog, this.tileLayerCatalog, this.gridSetBroker);
        this.mockMediator = (GWC)Mockito.mock(GWC.class);
        this.mockGWCSynchEnv = (GWCSynchEnv)Mockito.mock(GWCSynchEnv.class);
        GWC.set((GWC)this.mockMediator, (GWCSynchEnv)this.mockGWCSynchEnv);
        Mockito.when((Object)this.mockMediator.getConfig()).thenReturn((Object)this.defaults);
        Mockito.when((Object)this.mockMediator.getCatalog()).thenReturn((Object)this.catalog);
    }

    @After
    public void tearDown() {
        GWC.set(null, null);
    }

    @Test
    public void testGoofyMethods() {
        Assert.assertEquals((Object)"GeoServer Catalog Configuration", (Object)this.config.getIdentifier());
    }

    @Test
    public void testInitialize() {
        this.config.afterPropertiesSet();
    }

    @Test
    public void testGetTileLayerCount() {
        Assert.assertEquals((long)4L, (long)this.config.getLayerCount());
    }

    @Test
    public void testGetTileLayerNames() {
        ImmutableSet expected = ImmutableSet.of((Object)GWC.tileLayerName((LayerInfo)this.layer1), (Object)GWC.tileLayerName((LayerInfo)this.layer2), (Object)GWC.tileLayerName((LayerGroupInfo)this.group1), (Object)GWC.tileLayerName((LayerGroupInfo)this.group2));
        Set actual = this.config.getLayerNames();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetLayers() {
        Collection layers = this.config.getLayers();
        this.testGetLayers(layers);
    }

    @Test
    public void testDeprecatedGetTileLayers() {
        Collection layers = this.config.getLayers();
        this.testGetLayers(layers);
    }

    private void testGetLayers(Iterable<TileLayer> layers) {
        Assert.assertEquals((long)3L, (long)this.catalog.getLayers().size());
        Assert.assertEquals((long)3L, (long)this.catalog.getLayerGroups().size());
        Assert.assertEquals((long)4L, (long)Iterables.size(layers));
        ImmutableSet expected = ImmutableSet.of((Object)this.layerInfo1, (Object)this.layerInfo2, (Object)this.groupInfo1, (Object)this.groupInfo2);
        HashSet<GeoServerTileLayerInfo> actual = new HashSet<GeoServerTileLayerInfo>();
        for (TileLayer layer : layers) {
            actual.add(((GeoServerTileLayer)layer).getInfo());
        }
        Assert.assertEquals((long)4L, (long)actual.size());
        Assert.assertEquals((Object)expected, actual);
    }

    @Test
    public void testGetTileLayer() {
        String layerName = GWC.tileLayerName((LayerInfo)this.layerWithNoTileLayer);
        Assert.assertFalse((boolean)this.config.getLayer(layerName).isPresent());
        Assert.assertFalse((boolean)this.config.getLayer(GWC.tileLayerName((LayerGroupInfo)this.groupWithNoTileLayer)).isPresent());
        Assert.assertTrue((boolean)this.config.getLayer(GWC.tileLayerName((LayerInfo)this.layer1)).isPresent());
        Assert.assertTrue((boolean)this.config.getLayer(GWC.tileLayerName((LayerInfo)this.layer2)).isPresent());
        Assert.assertTrue((boolean)this.config.getLayer(GWC.tileLayerName((LayerGroupInfo)this.group1)).isPresent());
        Assert.assertTrue((boolean)this.config.getLayer(GWC.tileLayerName((LayerGroupInfo)this.group2)).isPresent());
        Assert.assertFalse((boolean)this.config.getLayer("anythingElse").isPresent());
    }

    @Test
    public void testModifyLayer() {
        try {
            this.config.modifyLayer(null);
            Assert.fail((String)"expected precondition exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is null"));
        }
        try {
            this.config.modifyLayer((TileLayer)Mockito.mock(TileLayer.class));
            Assert.fail((String)"expected precondition exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Can't save TileLayer of type"));
        }
        GeoServerTileLayer tileLayer1 = (GeoServerTileLayer)this.config.getLayer(GWC.tileLayerName((LayerInfo)this.layer1)).get();
        GeoServerTileLayer tileLayer2 = (GeoServerTileLayer)this.config.getLayer(GWC.tileLayerName((LayerGroupInfo)this.group1)).get();
        this.testModifyLayer(tileLayer1);
        this.testModifyLayer(tileLayer2);
    }

    private void testModifyLayer(GeoServerTileLayer orig) {
        GeoServerTileLayerInfoImpl newState = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        newState.setId(orig.getInfo().getId());
        newState.setName(orig.getInfo().getName());
        Assert.assertNotEquals((Object)orig, (Object)newState);
        GeoServerTileLayer modified = new GeoServerTileLayer(orig.getPublishedInfo(), this.gridSetBroker, (GeoServerTileLayerInfo)newState);
        Assert.assertEquals((Object)orig.getInfo(), (Object)((GeoServerTileLayer)this.config.getLayer(orig.getName()).get()).getInfo());
        Mockito.when((Object)this.tileLayerCatalog.save(modified.getInfo())).thenReturn((Object)orig.getInfo());
        this.config.modifyLayer((TileLayer)modified);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(modified.getId())).thenReturn((Object)modified.getInfo());
        Assert.assertEquals((Object)newState, (Object)((GeoServerTileLayer)this.config.getLayer(orig.getName()).get()).getInfo());
        String origName = orig.getName();
        modified.getInfo().setName("changed");
        Mockito.when((Object)this.tileLayerCatalog.save(modified.getInfo())).thenReturn((Object)orig.getInfo());
        this.config.modifyLayer((TileLayer)modified);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(orig.getId())).thenReturn(null);
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(orig.getName())).thenReturn(null);
        Mockito.when((Object)this.tileLayerCatalog.getLayerNames()).thenReturn(Collections.emptySet());
        Assert.assertFalse((boolean)this.config.getLayer(origName).isPresent());
        Assert.assertFalse((boolean)this.config.getLayerNames().contains(origName));
    }

    @Test
    public void testRemoveLayer() {
        try {
            this.config.removeLayer(null);
            Assert.fail((String)"expected precondition violation exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.config.removeLayer(GWC.tileLayerName((LayerInfo)this.layerWithNoTileLayer));
            Assert.fail((String)"expected precondition violation exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.config.removeLayer(GWC.tileLayerName((LayerGroupInfo)this.groupWithNoTileLayer));
            Assert.fail((String)"expected precondition violation exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        String layerName = GWC.tileLayerName((LayerInfo)this.layer1);
        Assert.assertNotNull((Object)this.config.getLayer(layerName));
        int initialCount = this.config.getLayerCount();
        this.config.removeLayer(layerName);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(layerName)).thenReturn(null);
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(layerName)).thenReturn(null);
        Mockito.when((Object)this.tileLayerCatalog.getLayerNames()).thenReturn((Object)ImmutableSet.of((Object)GWC.tileLayerName((LayerInfo)this.layer2), (Object)GWC.tileLayerName((LayerGroupInfo)this.group1), (Object)GWC.tileLayerName((LayerGroupInfo)this.group2)));
        Mockito.when((Object)this.tileLayerCatalog.getLayerIds()).thenReturn((Object)ImmutableSet.of((Object)this.layer2.getId(), (Object)this.group1.getId(), (Object)this.group2.getId()));
        Assert.assertFalse((boolean)this.config.getLayer(layerName).isPresent());
        Assert.assertFalse((boolean)this.config.getLayerNames().contains(layerName));
        Assert.assertEquals((long)(initialCount - 1), (long)this.config.getLayerCount());
        layerName = GWC.tileLayerName((LayerGroupInfo)this.group1);
        Assert.assertNotNull((Object)this.config.getLayer(layerName));
        this.config.removeLayer(layerName);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(layerName)).thenReturn(null);
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(layerName)).thenReturn(null);
        Mockito.when((Object)this.tileLayerCatalog.getLayerNames()).thenReturn((Object)ImmutableSet.of((Object)GWC.tileLayerName((LayerInfo)this.layer2), (Object)GWC.tileLayerName((LayerGroupInfo)this.group2)));
        Mockito.when((Object)this.tileLayerCatalog.getLayerIds()).thenReturn((Object)ImmutableSet.of((Object)this.layer2.getId(), (Object)this.group2.getId()));
        Assert.assertFalse((boolean)this.config.getLayer(layerName).isPresent());
        Assert.assertEquals((long)(initialCount - 2), (long)this.config.getLayerCount());
    }

    @Test
    public void testSaveRename() {
        GeoServerTileLayerInfo originalState = this.layerInfo1;
        GeoServerTileLayerInfoImpl forceState1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer1, (GWCConfig)this.defaults);
        Mockito.when((Object)this.tileLayerCatalog.save((GeoServerTileLayerInfo)ArgumentMatchers.same((Object)forceState1))).thenReturn((Object)originalState);
        forceState1.setName("newName");
        this.config.modifyLayer((TileLayer)new GeoServerTileLayer((PublishedInfo)this.layer1, this.gridSetBroker, (GeoServerTileLayerInfo)forceState1));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).layerRemoved(ArgumentMatchers.anyString());
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.same((Object)forceState1));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerRenamed((String)ArgumentMatchers.eq((Object)this.layerInfo1.getName()), (String)ArgumentMatchers.eq((Object)"newName"));
    }

    @Test
    public void testSave() {
        Mockito.when((Object)this.tileLayerCatalog.delete((String)ArgumentMatchers.eq((Object)this.layerInfo2.getId()))).thenReturn((Object)this.layerInfo2);
        this.config.removeLayer(this.layerInfo2.getName());
        Mockito.when((Object)this.tileLayerCatalog.delete((String)ArgumentMatchers.eq((Object)this.groupInfo1.getId()))).thenReturn((Object)this.groupInfo1);
        this.config.removeLayer(this.groupInfo1.getName());
        ((TileLayerCatalog)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("failedDelete")}).when((Object)this.tileLayerCatalog)).delete((String)ArgumentMatchers.eq((Object)this.group1.getId()));
        GeoServerTileLayerInfoImpl forceState1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer1, (GWCConfig)this.defaults);
        forceState1.setName("newName");
        GeoServerTileLayerInfoImpl forceState2 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.group2, (GWCConfig)this.defaults);
        Mockito.when((Object)this.tileLayerCatalog.save((GeoServerTileLayerInfo)ArgumentMatchers.same((Object)forceState1))).thenReturn((Object)this.layerInfo1);
        this.config.modifyLayer((TileLayer)new GeoServerTileLayer((PublishedInfo)this.layer1, this.gridSetBroker, (GeoServerTileLayerInfo)forceState1));
        this.config.modifyLayer((TileLayer)new GeoServerTileLayer((PublishedInfo)this.group2, this.gridSetBroker, (GeoServerTileLayerInfo)forceState2));
        ((TileLayerCatalog)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("failedSave")}).when((Object)this.tileLayerCatalog)).save((GeoServerTileLayerInfo)ArgumentMatchers.eq((Object)forceState2));
        GeoServerTileLayerInfoImpl addedState1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layerWithNoTileLayer, (GWCConfig)this.defaults);
        this.config.addLayer((TileLayer)new GeoServerTileLayer((PublishedInfo)this.layerWithNoTileLayer, this.gridSetBroker, (GeoServerTileLayerInfo)addedState1));
        ((GWC)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("callback exception")}).when((Object)this.mockMediator)).layerAdded((String)ArgumentMatchers.eq((Object)addedState1.getName()));
        GeoServerTileLayerInfoImpl addedState2 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.groupWithNoTileLayer, (GWCConfig)this.defaults);
        this.config.addLayer((TileLayer)new GeoServerTileLayer((PublishedInfo)this.groupWithNoTileLayer, this.gridSetBroker, (GeoServerTileLayerInfo)addedState2));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)this.group1.getId()));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)this.layer2.getId()));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.same((Object)forceState1));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.same((Object)forceState2));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.same((Object)addedState1));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.same((Object)addedState2));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerRemoved((String)ArgumentMatchers.eq((Object)this.layerInfo2.getName()));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerRenamed((String)ArgumentMatchers.eq((Object)this.layerInfo1.getName()), (String)ArgumentMatchers.eq((Object)"newName"));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerAdded((String)ArgumentMatchers.eq((Object)addedState1.getName()));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerAdded((String)ArgumentMatchers.eq((Object)addedState2.getName()));
    }

    @Test
    public void testCanSave() {
        GeoServerTileLayer l = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)l.isTransientLayer()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.config.canSave((TileLayer)l));
    }

    @Test
    public void testNoGeometry() throws Exception {
        FeatureType featureTypeWithNoGeometry = (FeatureType)Mockito.mock(FeatureType.class);
        Mockito.when((Object)featureTypeWithNoGeometry.getGeometryDescriptor()).thenReturn(null);
        FeatureTypeInfo resourceWithNoGeometry = (FeatureTypeInfo)Mockito.mock(FeatureTypeInfo.class);
        Mockito.when((Object)resourceWithNoGeometry.getFeatureType()).thenReturn((Object)featureTypeWithNoGeometry);
        LayerInfoImpl layerWithNoGeometry = GWCTestHelpers.mockLayer("layerWithNoGeometry", new String[0], PublishedType.VECTOR);
        layerWithNoGeometry.setResource((ResourceInfo)resourceWithNoGeometry);
        GeoServerTileLayer tl = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("layerWithNoGeometry");
        info.setName("layerWithNoGeometry");
        Mockito.when((Object)tl.getId()).thenReturn((Object)"layerWithNoGeometry");
        Mockito.when((Object)tl.isTransientLayer()).thenReturn((Object)false);
        Mockito.when((Object)tl.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)tl.getPublishedInfo()).thenReturn((Object)layerWithNoGeometry);
        Mockito.when((Object)this.catalog.getLayer(layerWithNoGeometry.getId())).thenReturn((Object)layerWithNoGeometry);
        Mockito.when((Object)this.catalog.getLayerByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerInfo)layerWithNoGeometry)))).thenReturn((Object)layerWithNoGeometry);
        this.config.addLayer((TileLayer)tl);
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.never())).save((GeoServerTileLayerInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationDeadlock() throws Exception {
        int LOOPS = 1000;
        ExecutorService service = Executors.newFixedThreadPool(8);
        Runnable reloader = () -> {
            this.config.setGridSetBroker(this.gridSetBroker);
            this.config.afterPropertiesSet();
        };
        Runnable tileLayerFetcher = () -> {
            this.config.getLayer(this.layer1.getName());
            this.config.getLayer(this.layer2.getName());
            this.config.getLayer(this.group1.getName());
            this.config.getLayer(this.group2.getName());
        };
        try {
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 1000; ++i) {
                futures.add(service.submit(reloader));
                futures.add(service.submit(tileLayerFetcher));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            service.shutdown();
        }
    }

    @Test
    public void getLayerByIdWithLocalWorkspace() {
        try {
            WorkspaceInfoImpl testWorkspace = new WorkspaceInfoImpl();
            testWorkspace.setName("test");
            WorkspaceInfoImpl otherWorkspace = new WorkspaceInfoImpl();
            otherWorkspace.setName("other");
            LocalWorkspace.set((WorkspaceInfo)testWorkspace);
            MatcherAssert.assertThat((Object)this.config.getLayer(this.layer1.prefixedName()).orElse(null), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)this.config.getLayer(this.layer2.prefixedName()).orElse(null), (Matcher)Matchers.notNullValue());
            LocalWorkspace.set((WorkspaceInfo)otherWorkspace);
            MatcherAssert.assertThat((Object)this.config.getLayer(this.layer1.prefixedName()).orElse(null), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)this.config.getLayer(this.layer2.prefixedName()).orElse(null), (Matcher)Matchers.nullValue());
        }
        finally {
            LocalWorkspace.set(null);
        }
    }

    @Test
    public void getLayersWithLocalWorkspace() {
        try {
            WorkspaceInfoImpl testWorkspace = new WorkspaceInfoImpl();
            testWorkspace.setName("test");
            WorkspaceInfoImpl otherWorkspace = new WorkspaceInfoImpl();
            otherWorkspace.setName("other");
            LocalWorkspace.set((WorkspaceInfo)testWorkspace);
            MatcherAssert.assertThat((Object)Iterators.size(this.config.getLayers().iterator()), (Matcher)Matchers.is((Object)2));
            LocalWorkspace.set((WorkspaceInfo)otherWorkspace);
            MatcherAssert.assertThat((Object)Iterators.size(this.config.getLayers().iterator()), (Matcher)Matchers.is((Object)0));
        }
        finally {
            LocalWorkspace.set(null);
        }
    }
}

