/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFacade;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.config.GWCInitializer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.gwc.wmts.WMTSInfoImpl;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GWCInitializerTest {
    private GWCInitializer initializer;
    private GWCConfigPersister configPersister;
    private GeoServer geoServer;
    private Catalog rawCatalog;
    private TileLayerCatalog tileLayerCatalog;
    private GeoServerFacade geoServerFacade;
    private WMTSInfo wmtsInfo = new WMTSInfoImpl();

    @Before
    public void setUp() throws Exception {
        this.configPersister = (GWCConfigPersister)Mockito.mock(GWCConfigPersister.class);
        GWCConfig config = GWCConfig.getOldDefaults();
        config.setWMTSEnabled(Boolean.valueOf(false));
        Mockito.when((Object)this.configPersister.getConfig()).thenReturn((Object)config);
        this.rawCatalog = (Catalog)Mockito.mock(Catalog.class);
        this.tileLayerCatalog = (TileLayerCatalog)Mockito.mock(TileLayerCatalog.class);
        this.initializer = new GWCInitializer(this.configPersister, this.rawCatalog, this.tileLayerCatalog);
        this.wmtsInfo.setEnabled(true);
        this.geoServerFacade = (GeoServerFacade)Mockito.mock(GeoServerFacade.class);
        Mockito.when((Object)((WMTSInfo)this.geoServerFacade.getService(WMTSInfo.class))).thenReturn((Object)this.wmtsInfo);
        this.geoServer = (GeoServer)Mockito.mock(GeoServer.class);
        Mockito.when((Object)this.geoServer.getFacade()).thenReturn((Object)this.geoServerFacade);
    }

    @Test
    public void testInitializeLayersToOldDefaults() throws Exception {
        Mockito.when((Object)this.configPersister.findConfigFile()).thenReturn(null);
        Mockito.when((Object)((WMSInfo)this.geoServer.getService((Class)ArgumentMatchers.eq(WMSInfo.class)))).thenReturn(null);
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[0], PublishedType.RASTER);
        LayerGroupInfoImpl group = GWCTestHelpers.mockGroup("testGroup", new PublishedInfo[]{layer});
        Mockito.when((Object)this.rawCatalog.getLayers()).thenReturn((Object)Lists.newArrayList((Object[])new LayerInfo[]{layer}));
        Mockito.when((Object)this.rawCatalog.getLayerGroups()).thenReturn((Object)Lists.newArrayList((Object[])new LayerGroupInfo[]{group}));
        this.initializer.initialize(this.geoServer);
        GWCConfig oldDefaults = GWCConfig.getOldDefaults();
        GeoServerTileLayerInfoImpl tileLayer = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)oldDefaults);
        GeoServerTileLayerInfoImpl tileLayerGroup = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)group, (GWCConfig)oldDefaults);
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.eq((Object)tileLayer));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.eq((Object)tileLayerGroup));
    }

    @Test
    public void testUpgradeDirectWMSIntegrationFlag() throws Exception {
        Mockito.when((Object)this.configPersister.findConfigFile()).thenReturn(null);
        ImmutableList layers = ImmutableList.of();
        ImmutableList groups = ImmutableList.of();
        Mockito.when((Object)this.rawCatalog.getLayers()).thenReturn((Object)layers);
        Mockito.when((Object)this.rawCatalog.getLayerGroups()).thenReturn((Object)groups);
        WMSInfoImpl wmsInfo = new WMSInfoImpl();
        wmsInfo.getMetadata().put(GWCInitializer.WMS_INTEGRATION_ENABLED_KEY, (Serializable)Boolean.TRUE);
        Mockito.when((Object)((WMSInfo)this.geoServer.getService((Class)ArgumentMatchers.eq(WMSInfo.class)))).thenReturn((Object)wmsInfo);
        ArgumentCaptor captor = ArgumentCaptor.forClass(GWCConfig.class);
        this.initializer.initialize(this.geoServer);
        ((GWCConfigPersister)Mockito.verify((Object)this.configPersister, (VerificationMode)Mockito.times((int)3))).save((GWCConfig)captor.capture());
        Assert.assertTrue((boolean)((GWCConfig)captor.getAllValues().get(0)).isDirectWMSIntegrationEnabled());
        Assert.assertFalse((boolean)wmsInfo.getMetadata().containsKey((Object)GWCInitializer.WMS_INTEGRATION_ENABLED_KEY));
        ((GeoServer)Mockito.verify((Object)this.geoServer)).save((ServiceInfo)ArgumentMatchers.same((Object)wmsInfo));
    }

    @Test
    public void testUpgradeFromTileLayerInfosToTileLayerCatalog() throws Exception {
        Resource fakeConfig = Files.asResource((File)new File("target", "gwc-gs.xml"));
        Mockito.when((Object)this.configPersister.findConfigFile()).thenReturn((Object)fakeConfig);
        GWCConfig defaults = GWCConfig.getOldDefaults();
        defaults.setCacheLayersByDefault(true);
        Mockito.when((Object)this.configPersister.getConfig()).thenReturn((Object)defaults);
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[0], PublishedType.RASTER);
        LayerGroupInfoImpl group = GWCTestHelpers.mockGroup("testGroup", new PublishedInfo[]{layer});
        Mockito.when((Object)this.rawCatalog.getLayers()).thenReturn((Object)Lists.newArrayList((Object[])new LayerInfo[]{layer}));
        Mockito.when((Object)this.rawCatalog.getLayerGroups()).thenReturn((Object)Lists.newArrayList((Object[])new LayerGroupInfo[]{group}));
        GeoServerTileLayerInfoImpl layerInfo = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)defaults);
        GeoServerTileLayerInfoImpl groupInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)group, (GWCConfig)defaults);
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)layerInfo, (MetadataMap)layer.getMetadata());
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)groupInfo, (MetadataMap)group.getMetadata());
        this.initializer.initialize(this.geoServer);
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.eq((Object)layerInfo));
        Assert.assertFalse((boolean)LegacyTileLayerInfoLoader.hasTileLayerDef((MetadataMap)layer.getMetadata()));
        ((Catalog)Mockito.verify((Object)this.rawCatalog, (VerificationMode)Mockito.times((int)1))).save((LayerInfo)ArgumentMatchers.eq((Object)layer));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)ArgumentMatchers.eq((Object)groupInfo));
        Assert.assertFalse((boolean)LegacyTileLayerInfoLoader.hasTileLayerDef((MetadataMap)group.getMetadata()));
        ((Catalog)Mockito.verify((Object)this.rawCatalog, (VerificationMode)Mockito.times((int)1))).save((LayerGroupInfo)ArgumentMatchers.eq((Object)group));
    }

    @Test
    public void testUpgradeWithWmtsEnablingInfo() throws Exception {
        Mockito.when((Object)this.configPersister.findConfigFile()).thenReturn(null);
        Assert.assertTrue((boolean)this.wmtsInfo.isEnabled());
        this.initializer.initialize(this.geoServer);
        ((GeoServer)Mockito.verify((Object)this.geoServer)).save((ServiceInfo)ArgumentMatchers.same((Object)this.wmtsInfo));
        ((GWCConfigPersister)Mockito.verify((Object)this.configPersister, (VerificationMode)Mockito.times((int)2))).save(this.configPersister.getConfig());
        Assert.assertFalse((boolean)this.wmtsInfo.isEnabled());
    }
}

