/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.ConfigurableQuotaStoreProvider;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCSynchEnv;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.JDBCConfigurationStorage;
import org.geoserver.gwc.PassThroughMethodInvocation;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.gwc.wms.CachingWebMapService;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.platform.ExtensionFilter;
import org.geoserver.platform.ExtensionProvider;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.kvp.PaletteManager;
import org.geoserver.wms.map.RawMap;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationPersistenceException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.seed.TruncateAllRequest;
import org.geowebcache.service.Service;
import org.geowebcache.storage.BlobStoreAggregator;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;

public class GWCTest {
    private GWC mediator;
    private GWCConfig defaults;
    private GWCConfigPersister gwcConfigPersister;
    private XMLConfiguration xmlConfig;
    private StorageBroker storageBroker;
    private GridSetBroker gridSetBroker;
    private TileLayerConfiguration config;
    private TileLayerDispatcher tld;
    private TileBreeder tileBreeder;
    private QuotaStore quotaStore;
    private DiskQuotaMonitor diskQuotaMonitor;
    private ConfigurableQuotaStoreProvider diskQuotaStoreProvider;
    private Dispatcher owsDispatcher;
    private Catalog catalog;
    LayerInfo layer;
    LayerGroupInfo layerGroup;
    GeoServerTileLayerInfo tileLayerInfo;
    GeoServerTileLayerInfo tileLayerGroupInfo;
    GeoServerTileLayer tileLayer;
    GeoServerTileLayer tileLayerGroup;
    private DefaultStorageFinder storageFinder;
    private JDBCConfigurationStorage jdbcStorage;
    private GWCSynchEnv synchEnv;
    private BlobStoreAggregator blobStoreAggregator;

    static Resource tmpDir() throws IOException {
        Resource root = Files.asResource((File)new File(System.getProperty("java.io.tmpdir", ".")));
        Resource directory = Resources.createRandom((String)"tmp", (String)"", (Resource)root);
        do {
            FileUtils.forceDelete((File)directory.dir());
        } while (Resources.exists((Resource)directory));
        FileUtils.forceMkdir((File)directory.dir());
        return Files.asResource((File)directory.dir());
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        System.setProperty("TEST_ENV_PROPERTY", "HSQL");
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        this.layer = GWCTestHelpers.mockLayer("testLayer", new String[]{"style1", "style2"}, PublishedType.RASTER);
        this.layerGroup = GWCTestHelpers.mockGroup("testGroup", new PublishedInfo[]{this.layer});
        this.mockCatalog();
        this.defaults = GWCConfig.getOldDefaults();
        this.gwcConfigPersister = (GWCConfigPersister)Mockito.mock(GWCConfigPersister.class);
        Mockito.when((Object)this.gwcConfigPersister.getConfig()).thenReturn((Object)this.defaults);
        this.storageBroker = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.tileLayerInfo = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer, (GWCConfig)this.defaults);
        this.tileLayerGroupInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.layerGroup, (GWCConfig)this.defaults);
        this.config = (TileLayerConfiguration)Mockito.mock(TileLayerConfiguration.class);
        this.tileBreeder = (TileBreeder)Mockito.mock(TileBreeder.class);
        this.quotaStore = (QuotaStore)Mockito.mock(QuotaStore.class);
        this.diskQuotaMonitor = (DiskQuotaMonitor)Mockito.mock(DiskQuotaMonitor.class);
        Mockito.when((Object)this.diskQuotaMonitor.getQuotaStore()).thenReturn((Object)this.quotaStore);
        this.owsDispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        this.diskQuotaStoreProvider = (ConfigurableQuotaStoreProvider)Mockito.mock(ConfigurableQuotaStoreProvider.class);
        Mockito.when((Object)this.diskQuotaMonitor.getQuotaStoreProvider()).thenReturn((Object)this.diskQuotaStoreProvider);
        this.storageFinder = (DefaultStorageFinder)Mockito.mock(DefaultStorageFinder.class);
        this.jdbcStorage = (JDBCConfigurationStorage)EasyMock.createMock(JDBCConfigurationStorage.class);
        this.xmlConfig = (XMLConfiguration)Mockito.mock(XMLConfiguration.class);
        this.blobStoreAggregator = (BlobStoreAggregator)Mockito.mock(BlobStoreAggregator.class);
        this.synchEnv = (GWCSynchEnv)Mockito.mock(GWCSynchEnv.class);
        this.gridSetBroker = new GridSetBroker(Arrays.asList(new DefaultGridsets(true, true), this.xmlConfig));
        this.tileLayer = new GeoServerTileLayer((PublishedInfo)this.layer, this.gridSetBroker, this.tileLayerInfo);
        GridSet testGridSet = this.namedGridsetCopy("TEST", this.gridSetBroker.getDefaults().worldEpsg4326());
        GridSubset testGridSubset = GridSubsetFactory.createGridSubSet((GridSet)testGridSet, (BoundingBox)new BoundingBox(-180.0, 0.0, 0.0, 90.0), (Integer)0, (Integer)(testGridSet.getNumLevels() - 1));
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"TEST"))).thenReturn(Optional.of(testGridSet));
        this.tileLayer.addGridSubset(testGridSubset);
        this.tileLayerGroup = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.gridSetBroker, this.tileLayerGroupInfo);
        this.tileLayerGroup.addGridSubset(testGridSubset);
        this.tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.mockTileLayerDispatcher();
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoWebCacheEnvironment genv = (GeoWebCacheEnvironment)EasyMock.createMockBuilder(GeoWebCacheEnvironment.class).withConstructor().createMock();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoWebCacheEnvironment.class)).andReturn((Object)new String[]{"geoWebCacheEnvironment"}).anyTimes();
        HashMap<String, GeoWebCacheEnvironment> genvMap = new HashMap<String, GeoWebCacheEnvironment>();
        genvMap.put("geoWebCacheEnvironment", genv);
        EasyMock.expect((Object)appContext.getBeansOfType(GeoWebCacheEnvironment.class)).andReturn(genvMap).anyTimes();
        EasyMock.expect((Object)appContext.getBean("geoWebCacheEnvironment")).andReturn((Object)genv).anyTimes();
        EasyMock.expect((Object)appContext.isSingleton("geoWebCacheEnvironment")).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(XMLConfiguration.class)).andReturn((Object)new String[]{"geoWebCacheXMLConfiguration"}).anyTimes();
        HashMap<String, XMLConfiguration> xmlConfMap = new HashMap<String, XMLConfiguration>();
        xmlConfMap.put("geoWebCacheXMLConfiguration", this.xmlConfig);
        EasyMock.expect((Object)appContext.getBeansOfType(XMLConfiguration.class)).andReturn(xmlConfMap).anyTimes();
        EasyMock.expect((Object)appContext.getBean("geoWebCacheXMLConfiguration")).andReturn((Object)this.xmlConfig).anyTimes();
        GeoServerEnvironment gsenv = (GeoServerEnvironment)EasyMock.createMockBuilder(GeoServerEnvironment.class).withConstructor().addMockedMethods(new String[]{"getProps"}).createMock();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerEnvironment.class)).andReturn((Object)new String[]{"environments"}).anyTimes();
        HashMap<String, GeoServerEnvironment> gsenvMap = new HashMap<String, GeoServerEnvironment>();
        gsenvMap.put("environments", gsenv);
        EasyMock.expect((Object)appContext.getBeansOfType(GeoServerEnvironment.class)).andReturn(gsenvMap).anyTimes();
        EasyMock.expect((Object)appContext.getBean("environments")).andReturn((Object)gsenv).anyTimes();
        EasyMock.expect((Object)appContext.isSingleton("environments")).andReturn((Object)true).anyTimes();
        Properties properties = new Properties();
        properties.put("TEST", "TEST VALUE");
        EasyMock.expect((Object)gsenv.getProps()).andReturn((Object)properties).anyTimes();
        EasyMock.replay((Object[])new Object[]{gsenv});
        GWC gwcenv = (GWC)EasyMock.createMockBuilder(GWC.class).withConstructor(new Object[]{this.gwcConfigPersister, this.storageBroker, this.tld, this.gridSetBroker, this.tileBreeder, this.diskQuotaMonitor, this.owsDispatcher, this.catalog, this.catalog, this.storageFinder, this.jdbcStorage, this.blobStoreAggregator, this.synchEnv}).createMock();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GWC.class)).andReturn((Object)new String[]{"gwc"}).anyTimes();
        HashMap<String, GWC> gwcenvMap = new HashMap<String, GWC>();
        gwcenvMap.put("gwc", gwcenv);
        EasyMock.expect((Object)appContext.getBeansOfType(GWC.class)).andReturn(gwcenvMap).anyTimes();
        EasyMock.expect((Object)appContext.getBean("gwc")).andReturn((Object)gwcenv).anyTimes();
        EasyMock.expect((Object)appContext.isSingleton("gwc")).andReturn((Object)true).anyTimes();
        GeoServerResourceLoader loader = (GeoServerResourceLoader)EasyMock.createMockBuilder(GeoServerResourceLoader.class).withConstructor().createMock();
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerResourceLoader.class)).andReturn((Object)new String[]{"resourceLoader"}).anyTimes();
        HashMap<String, GeoServerResourceLoader> grenvMap = new HashMap<String, GeoServerResourceLoader>();
        grenvMap.put("resourceLoader", loader);
        EasyMock.expect((Object)appContext.getBeansOfType(GeoServerResourceLoader.class)).andReturn(grenvMap).anyTimes();
        EasyMock.expect((Object)appContext.getBean("resourceLoader")).andReturn((Object)loader).anyTimes();
        EasyMock.expect((Object)appContext.isSingleton("resourceLoader")).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoWebCacheExtensions gse = (GeoWebCacheExtensions)EasyMock.createMockBuilder(GeoWebCacheExtensions.class).createMock();
        gse.setApplicationContext(appContext);
        EasyMock.replay((Object[])new Object[]{gse});
        GeoServerExtensions gsext = new GeoServerExtensions();
        gsext.setApplicationContext(appContext);
        List extensions = GeoWebCacheExtensions.extensions(GeoWebCacheEnvironment.class);
        Assert.assertNotNull((Object)extensions);
        Assert.assertEquals((long)1L, (long)extensions.size());
        Assert.assertTrue((boolean)extensions.contains(genv));
        JDBCConfiguration jdbcConfiguration = new JDBCConfiguration();
        if (GeoWebCacheEnvironment.ALLOW_ENV_PARAMETRIZATION) {
            jdbcConfiguration.setDialect("${TEST_ENV_PROPERTY}");
        } else {
            jdbcConfiguration.setDialect("HSQL");
        }
        File jdbcConfigurationFile = File.createTempFile("jdbcConfigurationFile", ".tmp", GWCTest.tmpDir().dir());
        JDBCConfiguration.store((JDBCConfiguration)jdbcConfiguration, (File)jdbcConfigurationFile);
        JDBCConfiguration loadedConf = JDBCConfiguration.load((File)jdbcConfigurationFile);
        this.jdbcStorage.setApplicationContext(appContext);
        EasyMock.expect((Object)this.jdbcStorage.getJDBCDiskQuotaConfig()).andReturn((Object)loadedConf).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.jdbcStorage});
        this.mediator = new GWC(this.gwcConfigPersister, this.storageBroker, this.tld, this.gridSetBroker, this.tileBreeder, this.diskQuotaMonitor, this.owsDispatcher, this.catalog, this.catalog, this.storageFinder, this.jdbcStorage, this.blobStoreAggregator, this.synchEnv);
        this.mediator.setApplicationContext(appContext);
        this.mediator = (GWC)Mockito.spy((Object)this.mediator);
        GWC.set((GWC)this.mediator, (GWCSynchEnv)this.synchEnv);
    }

    @After
    public void tearDown() {
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
        System.clearProperty("TEST_ENV_PROPERTY");
        GWC.set(null, null);
    }

    private void mockCatalog() {
        Mockito.when((Object)this.catalog.getLayers()).thenReturn(Arrays.asList(this.layer));
        Mockito.when((Object)this.catalog.getLayerGroups()).thenReturn(Arrays.asList(this.layerGroup));
        Mockito.when((Object)this.catalog.getLayer((String)ArgumentMatchers.eq((Object)this.layer.getId()))).thenReturn((Object)this.layer);
        Mockito.when((Object)this.catalog.getLayerGroup(this.layerGroup.getId())).thenReturn((Object)this.layerGroup);
        Mockito.when((Object)this.catalog.getLayerByName((String)ArgumentMatchers.eq((Object)this.layer.getResource().prefixedName()))).thenReturn((Object)this.layer);
        Mockito.when((Object)this.catalog.getLayerGroupByName(GWC.tileLayerName((LayerGroupInfo)this.layerGroup))).thenReturn((Object)this.layerGroup);
    }

    private void mockTileLayerDispatcher() throws Exception {
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()))).thenReturn((Object)this.tileLayer);
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()))).thenReturn((Object)this.tileLayerGroup);
        Mockito.when((Object)this.tld.getLayerNames()).thenReturn((Object)ImmutableSet.of((Object)this.tileLayer.getName(), (Object)this.tileLayerGroup.getName()));
        ImmutableList tileLayers = ImmutableList.of((Object)this.tileLayer, (Object)this.tileLayerGroup);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn((Object)tileLayers);
        Mockito.when((Object)this.tld.layerExists((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()))).thenReturn((Object)true);
        Mockito.when((Object)this.tld.layerExists((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()))).thenReturn((Object)true);
    }

    @Test
    public void testAddTileLayer() throws Exception {
        ((TileLayerDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("fake")}).when((Object)this.tld)).addLayer((TileLayer)ArgumentMatchers.same((Object)this.tileLayer));
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).addLayer((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup));
        try {
            this.mediator.add(this.tileLayer);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        this.mediator.add(this.tileLayerGroup);
    }

    @Test
    public void testModifyTileLayer() throws Exception {
        try {
            this.mediator.save(null);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        ((TileLayerDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException()}).when((Object)this.tld)).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayer));
        try {
            this.mediator.save((TileLayer)this.tileLayer);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup));
        this.mediator.save((TileLayer)this.tileLayerGroup);
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup));
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayer));
        ((TileLayerConfiguration)Mockito.doThrow((Throwable[])new Throwable[]{new ConfigurationPersistenceException((Throwable)new IOException())}).when((Object)this.config)).modifyLayer((TileLayer)this.tileLayer);
        try {
            this.mediator.save((TileLayer)this.tileLayer);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testRemoveTileLayers() throws Exception {
        try {
            this.mediator.removeTileLayers(null);
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).removeLayer((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()));
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).removeLayer((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()));
        List<String> layerNames = Arrays.asList(this.tileLayer.getName(), this.tileLayerGroup.getName());
        this.mediator.removeTileLayers(layerNames);
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).removeLayer((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).removeLayer((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()));
    }

    @Test
    public void testAddGridset() throws Exception {
        try {
            this.mediator.addGridSet(null);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        GridSet gset = (GridSet)Mockito.mock(GridSet.class);
        GridSet gset2 = (GridSet)Mockito.mock(GridSet.class);
        ((TileLayerDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("fake")}).when((Object)this.tld)).addGridSet((GridSet)ArgumentMatchers.same((Object)gset));
        try {
            this.mediator.addGridSet(gset);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"fake", (Object)e.getMessage());
        }
        this.mediator.addGridSet(gset2);
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).addGridSet((GridSet)ArgumentMatchers.same((Object)gset2));
    }

    @Test
    public void testModifyGridsetPreconditions() throws Exception {
        GridSet oldGridset = this.gridSetBroker.get("EPSG:4326");
        try {
            this.mediator.modifyGridSet(null, oldGridset);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.mediator.modifyGridSet("oldname", null);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"wrongOldName"))).thenReturn(Optional.empty());
        try {
            this.mediator.modifyGridSet("wrongOldName", oldGridset);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("does not exist"));
        }
    }

    @Test
    public void testModifyGridsetNoNeedToTruncate() throws Exception {
        String oldName = "TEST";
        String newName = "TEST_CHANGED";
        GridSet oldGridset = this.gridSetBroker.get("TEST");
        GridSet newGridset = this.namedGridsetCopy("TEST_CHANGED", oldGridset);
        Assert.assertNotNull((Object)this.tileLayer.getGridSubset("TEST"));
        Assert.assertNotNull((Object)this.tileLayerGroup.getGridSubset("TEST"));
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"TEST_CHANGED"))).thenReturn(Optional.empty());
        Mockito.when((Object)this.xmlConfig.canSave((GridSet)ArgumentMatchers.eq((Object)newGridset))).thenReturn((Object)true);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        this.mediator.modifyGridSet("TEST", newGridset);
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"TEST"))).thenReturn(Optional.empty());
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"TEST_CHANGED"))).thenReturn(Optional.of(newGridset));
        Assert.assertNull((Object)this.tileLayer.getGridSubset("TEST"));
        Assert.assertNull((Object)this.tileLayerGroup.getGridSubset("TEST"));
        Assert.assertNotNull((Object)this.tileLayer.getGridSubset("TEST_CHANGED"));
        Assert.assertNotNull((Object)this.tileLayerGroup.getGridSubset("TEST_CHANGED"));
        ((XMLConfiguration)Mockito.verify((Object)this.xmlConfig, (VerificationMode)Mockito.times((int)1))).removeGridSet((String)ArgumentMatchers.eq((Object)"TEST"));
        ((XMLConfiguration)Mockito.verify((Object)this.xmlConfig, (VerificationMode)Mockito.times((int)1))).addGridSet((GridSet)ArgumentMatchers.eq((Object)newGridset));
        Assert.assertNull((Object)this.gridSetBroker.get("TEST"));
        Assert.assertEquals((Object)newGridset, (Object)this.gridSetBroker.get("TEST_CHANGED"));
    }

    protected GridSet namedGridsetCopy(String newName, GridSet oldGridset) {
        XMLGridSet xmlGridSet = new XMLGridSet(oldGridset);
        xmlGridSet.setName(newName);
        GridSet newGridset = xmlGridSet.makeGridSet();
        return newGridset;
    }

    @Test
    public void testModifyGridsetTruncates() throws Exception {
        String oldName = "TEST";
        String newName = "TEST_CHANGED";
        GridSet oldGridset = this.gridSetBroker.get("TEST");
        XMLGridSet xmlGridSet = new XMLGridSet(oldGridset);
        xmlGridSet.setName("TEST_CHANGED");
        xmlGridSet.setAlignTopLeft(Boolean.valueOf(xmlGridSet.getAlignTopLeft() == false));
        GridSet newGridset = xmlGridSet.makeGridSet();
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"TEST_CHANGED"))).thenReturn(Optional.empty());
        Mockito.when((Object)this.xmlConfig.canSave((GridSet)ArgumentMatchers.eq((Object)newGridset))).thenReturn((Object)true);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        this.mediator.modifyGridSet("TEST", newGridset);
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"TEST"))).thenReturn(Optional.empty());
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"TEST_CHANGED"))).thenReturn(Optional.of(newGridset));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()), (String)ArgumentMatchers.eq((Object)"TEST"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()), (String)ArgumentMatchers.eq((Object)"TEST"));
    }

    @Test
    public void testRemoveGridsets() throws Exception {
        try {
            this.mediator.removeGridSets(null);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        GridSet oldGridset = this.gridSetBroker.get("TEST");
        GridSet newGridset = this.namedGridsetCopy("My4326", oldGridset);
        Mockito.when((Object)this.xmlConfig.getGridSet((String)ArgumentMatchers.eq((Object)"My4326"))).thenReturn(Optional.of(newGridset));
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayer));
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup));
        this.mediator.removeGridSets((Set)ImmutableSet.of((Object)"My4326", (Object)"TEST"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"EPSG:4326", (Object)"EPSG:900913"), (Object)this.tileLayer.getGridSubsets());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"EPSG:4326", (Object)"EPSG:900913"), (Object)this.tileLayerGroup.getGridSubsets());
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()), (String)ArgumentMatchers.eq((Object)"TEST"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()), (String)ArgumentMatchers.eq((Object)"TEST"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()), (String)ArgumentMatchers.eq((Object)"EPSG:900913"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()), (String)ArgumentMatchers.eq((Object)"EPSG:4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()), (String)ArgumentMatchers.eq((Object)"My4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()), (String)ArgumentMatchers.eq((Object)"EPSG:900913"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()), (String)ArgumentMatchers.eq((Object)"EPSG:4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()), (String)ArgumentMatchers.eq((Object)"My4326"));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayer));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup));
    }

    @Test
    public void testRemoveAllLayerGridsetsDisablesLayer() throws Exception {
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayer));
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup));
        Assert.assertTrue((boolean)this.tileLayer.getInfo().isEnabled());
        Assert.assertTrue((boolean)this.tileLayer.getInfo().isEnabled());
        this.tileLayer.removeGridSubset("EPSG:900913");
        this.tileLayer.removeGridSubset("EPSG:4326");
        this.tileLayerGroup.removeGridSubset("EPSG:900913");
        this.tileLayerGroup.removeGridSubset("EPSG:4326");
        this.mediator.save((TileLayer)this.tileLayer);
        this.mediator.save((TileLayer)this.tileLayerGroup);
        this.mediator.removeGridSets((Set)ImmutableSet.of((Object)"TEST"));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)2))).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayer));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)2))).modify((TileLayer)ArgumentMatchers.same((Object)this.tileLayerGroup));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()), (String)ArgumentMatchers.eq((Object)"TEST"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)ArgumentMatchers.eq((Object)this.tileLayer.getName()), (String)ArgumentMatchers.eq((Object)"TEST"));
        Assert.assertTrue((boolean)this.tileLayer.getGridSubsets().isEmpty());
        Assert.assertTrue((boolean)this.tileLayerGroup.getGridSubsets().isEmpty());
        Assert.assertFalse((boolean)this.tileLayer.getInfo().isEnabled());
        Assert.assertFalse((boolean)this.tileLayerGroup.getInfo().isEnabled());
    }

    @Test
    public void testAutoConfigureLayers() throws Exception {
        GWCConfig insaneDefaults = new GWCConfig();
        insaneDefaults.setMetaTilingX(-1);
        Assert.assertFalse((boolean)insaneDefaults.isSane());
        try {
            this.mediator.autoConfigureLayers(Arrays.asList(this.tileLayer.getName()), insaneDefaults);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.mediator.autoConfigureLayers(Arrays.asList(this.tileLayer.getName()), this.defaults);
            Assert.fail((String)"expected IAE, layer exists");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        LayerInfoImpl layer2 = GWCTestHelpers.mockLayer("layer2", new String[0], PublishedType.RASTER);
        LayerGroupInfoImpl group2 = GWCTestHelpers.mockGroup("group2", new PublishedInfo[]{this.layer, layer2});
        Mockito.when((Object)this.catalog.getLayerByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerInfo)layer2)))).thenReturn((Object)layer2);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)ArgumentMatchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)group2)))).thenReturn((Object)group2);
        List<String> layerNames = Arrays.asList(GWC.tileLayerName((LayerInfo)layer2), GWC.tileLayerName((LayerGroupInfo)group2));
        ((TileLayerDispatcher)Mockito.doNothing().when((Object)this.tld)).addLayer((TileLayer)ArgumentMatchers.any(GeoServerTileLayer.class));
        this.mediator.autoConfigureLayers(layerNames, this.defaults);
        GeoServerTileLayerInfo expected1 = new GeoServerTileLayer((PublishedInfo)layer2, this.defaults, this.gridSetBroker).getInfo();
        GeoServerTileLayerInfo expected2 = new GeoServerTileLayer((PublishedInfo)group2, this.defaults, this.gridSetBroker).getInfo();
        ArgumentCaptor addCaptor = ArgumentCaptor.forClass(GeoServerTileLayer.class);
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)2))).addLayer((TileLayer)addCaptor.capture());
        GeoServerTileLayerInfo actual1 = ((GeoServerTileLayer)addCaptor.getAllValues().get(0)).getInfo();
        GeoServerTileLayerInfo actual2 = ((GeoServerTileLayer)addCaptor.getAllValues().get(1)).getInfo();
        Assert.assertEquals((Object)expected1, (Object)actual1);
        Assert.assertEquals((Object)expected2, (Object)actual2);
    }

    @Test
    public void testIsInternalGridset() {
        Set embeddedNames = this.gridSetBroker.getEmbeddedNames();
        for (String name : embeddedNames) {
            Assert.assertTrue((boolean)this.mediator.isInternalGridSet(name));
        }
        Assert.assertFalse((boolean)this.mediator.isInternalGridSet("somethingelse"));
    }

    @Test
    public void testDeleteCacheByGridSetId() throws Exception {
        Mockito.when((Object)this.storageBroker.deleteByGridSetId((String)ArgumentMatchers.eq((Object)"layer"), (String)ArgumentMatchers.eq((Object)"gset1"))).thenThrow(new Throwable[]{new StorageException("fake")});
        try {
            this.mediator.deleteCacheByGridSetId("layer", "gset1");
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        this.mediator.deleteCacheByGridSetId("layer", "gset2");
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)ArgumentMatchers.eq((Object)"layer"), (String)ArgumentMatchers.eq((Object)"gset2"));
    }

    @Test
    public void testDestroy() throws Exception {
        this.mediator.destroy();
        ArgumentCaptor captor = ArgumentCaptor.forClass(CatalogListener.class);
        ((Catalog)Mockito.verify((Object)this.catalog, (VerificationMode)Mockito.times((int)2))).removeListener((CatalogListener)captor.capture());
        for (CatalogListener captured : captor.getAllValues()) {
            Assert.assertTrue((captured instanceof CatalogLayerEventListener || captured instanceof CatalogStyleChangeListener ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTruncateLayerFully() throws Exception {
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)this.tileLayerGroup.getName()))).thenThrow(new Throwable[]{new GeoWebCacheException("fake")});
        this.mediator.truncate(this.tileLayerGroup.getName());
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        this.mediator.truncate(this.tileLayer.getName());
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)this.tileLayer.getGridSubsets().size()))).deleteByGridSetId(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testTruncateByLayerAndStyle() throws Exception {
        String layerName = this.tileLayer.getName();
        String styleName = "notACachedStyle";
        this.mediator.truncateByLayerAndStyle(layerName, styleName);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.never())).dispatchTasks((GWCTask[])ArgumentMatchers.any(GWCTask[].class));
        styleName = this.layer.getDefaultStyle().prefixedName();
        this.mediator.truncateByLayerAndStyle(layerName, styleName);
        int expected = this.tileLayer.getGridSubsets().size() * this.tileLayer.getMimeTypes().size();
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).dispatchTasks((GWCTask[])ArgumentMatchers.any());
    }

    @Test
    public void testTruncateByBounds() throws Exception {
        String layerName = this.tileLayer.getName();
        Mockito.when((Object)this.tileBreeder.findTileLayer(layerName)).thenReturn((Object)this.tileLayer);
        Set cachedParameters = this.tileLayer.getInfo().cachedStyles().stream().map(style -> Collections.singletonMap("STYLES", style)).collect(Collectors.toSet());
        Mockito.when((Object)this.storageBroker.getCachedParameters(layerName)).thenReturn(cachedParameters);
        ReferencedEnvelope bounds = new ReferencedEnvelope(10.0, 20.0, 10.0, 20.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BoundingBox layerBounds = this.tileLayer.getGridSubset("EPSG:4326").getOriginalExtent();
        Assert.assertFalse((boolean)bounds.intersects(layerBounds.getMinX(), layerBounds.getMinY()));
        Assert.assertFalse((boolean)bounds.intersects(layerBounds.getMaxX(), layerBounds.getMaxY()));
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.never())).dispatchTasks((GWCTask[])ArgumentMatchers.any(GWCTask[].class));
        bounds = new ReferencedEnvelope(-10.0, -10.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.mediator.truncate(layerName, bounds);
        int numGridsets = this.tileLayer.getGridSubsets().size();
        int numFormats = this.tileLayer.getMimeTypes().size();
        int numStyles = 1 + this.tileLayer.getInfo().cachedStyles().size();
        int expected = numGridsets * numFormats * numStyles;
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).seed((String)ArgumentMatchers.eq((Object)layerName), (SeedRequest)ArgumentMatchers.any(SeedRequest.class));
        Mockito.reset((Object[])new TileBreeder[]{this.tileBreeder});
        Mockito.when((Object)this.tileBreeder.findTileLayer(layerName)).thenReturn((Object)this.tileLayer);
        bounds = bounds.transform(CRS.decode((String)"EPSG:900913"), true);
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).seed((String)ArgumentMatchers.eq((Object)layerName), (SeedRequest)ArgumentMatchers.any(SeedRequest.class));
        Mockito.reset((Object[])new TileBreeder[]{this.tileBreeder});
        Mockito.when((Object)this.tileBreeder.findTileLayer(layerName)).thenReturn((Object)this.tileLayer);
        bounds = this.mediator.getAreaOfValidity(CRS.decode((String)"EPSG:2083"));
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)0))).seed((String)ArgumentMatchers.eq((Object)layerName), (SeedRequest)ArgumentMatchers.any(SeedRequest.class));
        Mockito.reset((Object[])new TileBreeder[]{this.tileBreeder});
        Mockito.when((Object)this.tileBreeder.findTileLayer(layerName)).thenReturn((Object)this.tileLayer);
        bounds = this.mediator.getAreaOfValidity(CRS.decode((String)"EPSG:26986"));
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).seed((String)ArgumentMatchers.eq((Object)layerName), (SeedRequest)ArgumentMatchers.any(SeedRequest.class));
    }

    @Test
    public void testTruncateByBoundsWithDimension() throws Exception {
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"TIME", (boolean)true);
        List<String> cachedTimes = Arrays.asList("time1", "time2");
        String layerName = this.tileLayer.getName();
        Mockito.when((Object)this.tileBreeder.findTileLayer(layerName)).thenReturn((Object)this.tileLayer);
        Set cachedParameters = this.tileLayer.getInfo().cachedStyles().stream().flatMap(style -> cachedTimes.stream().map(time -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("STYLE", (String)style);
            map.put("TIME", (String)time);
            return map;
        })).collect(Collectors.toSet());
        Mockito.when((Object)this.storageBroker.getCachedParameters(layerName)).thenReturn(cachedParameters);
        ReferencedEnvelope bounds = new ReferencedEnvelope(10.0, 20.0, 10.0, 20.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BoundingBox layerBounds = this.tileLayer.getGridSubset("EPSG:4326").getGridSet().getOriginalExtent();
        Assert.assertFalse((boolean)bounds.intersects(layerBounds.getMinX(), layerBounds.getMinY()));
        Assert.assertFalse((boolean)bounds.intersects(layerBounds.getMaxX(), layerBounds.getMaxY()));
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.never())).dispatchTasks((GWCTask[])ArgumentMatchers.any(GWCTask[].class));
        bounds = new ReferencedEnvelope(-10.0, -10.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.mediator.truncate(layerName, bounds);
        int numGridsets = this.tileLayer.getGridSubsets().size();
        int numFormats = this.tileLayer.getMimeTypes().size();
        int numStyles = this.tileLayer.getInfo().cachedStyles().size();
        int numTimes = cachedTimes.size();
        int numParameters = numStyles * numTimes + 1;
        int expected = numGridsets * numFormats * numParameters;
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).seed((String)ArgumentMatchers.eq((Object)layerName), (SeedRequest)ArgumentMatchers.any(SeedRequest.class));
    }

    @Test
    public void testTruncateAll() throws Exception {
        String layerName = this.tileLayer.getName();
        Mockito.when((Object)this.tileBreeder.findTileLayer(layerName)).thenReturn((Object)this.tileLayer);
        ArrayList<GeoServerTileLayer> mockList = new ArrayList<GeoServerTileLayer>();
        mockList.add(this.tileLayer);
        Mockito.when((Object)this.tileBreeder.getLayers()).thenReturn(mockList);
        for (String grid : this.tileLayer.getGridSubsets()) {
            Mockito.when((Object)this.storageBroker.deleteByGridSetId(layerName, grid)).thenReturn((Object)true);
        }
        TruncateAllRequest truncateAll = this.mediator.truncateAll();
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)1))).getLayers();
        Assert.assertTrue((boolean)truncateAll.getTrucatedLayersList().contains(layerName));
    }

    @Test
    public void testLayerRemoved() throws Exception {
        this.mediator.layerRemoved("someLayer");
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)"someLayer"));
        ((StorageBroker)Mockito.doThrow((Throwable[])new Throwable[]{new StorageException("fake")}).when((Object)this.storageBroker)).delete((String)ArgumentMatchers.eq((Object)"anotherLayer"));
        try {
            this.mediator.layerRemoved("anotherLayer");
            Assert.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof StorageException));
        }
    }

    @Test
    public void testLayerAdded() throws Exception {
        Mockito.when((Object)this.diskQuotaMonitor.isEnabled()).thenReturn((Object)false);
        this.mediator.layerAdded("someLayer");
        ((QuotaStore)Mockito.verify((Object)this.quotaStore, (VerificationMode)Mockito.never())).createLayer(ArgumentMatchers.anyString());
        Mockito.when((Object)this.diskQuotaMonitor.isEnabled()).thenReturn((Object)true);
        this.mediator.layerAdded("someLayer");
        ((QuotaStore)Mockito.verify((Object)this.quotaStore, (VerificationMode)Mockito.times((int)1))).createLayer((String)ArgumentMatchers.eq((Object)"someLayer"));
        ((QuotaStore)Mockito.doThrow((Throwable[])new Throwable[]{new InterruptedException("fake")}).when((Object)this.quotaStore)).createLayer((String)ArgumentMatchers.eq((Object)"someLayer"));
        try {
            this.mediator.layerAdded("someLayer");
            Assert.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InterruptedException));
        }
    }

    @Test
    public void testLayerRenamed() throws Exception {
        this.mediator.layerRenamed("old", "new");
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).rename((String)ArgumentMatchers.eq((Object)"old"), (String)ArgumentMatchers.eq((Object)"new"));
        ((StorageBroker)Mockito.doThrow((Throwable[])new Throwable[]{new StorageException("target directory already exists")}).when((Object)this.storageBroker)).rename((String)ArgumentMatchers.eq((Object)"old"), (String)ArgumentMatchers.eq((Object)"new"));
        try {
            this.mediator.layerRenamed("old", "new");
            Assert.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof StorageException));
        }
    }

    @Test
    public void testReload() throws Exception {
        this.mediator.reload();
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).reInit();
        ((ConfigurableQuotaStoreProvider)Mockito.verify((Object)this.diskQuotaStoreProvider, (VerificationMode)Mockito.times((int)1))).reloadQuotaStore();
        RuntimeException expected = new RuntimeException("expected");
        ((TileLayerDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{expected}).when((Object)this.tld)).reInit();
        try {
            this.mediator.reload();
            Assert.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void testReloadAndLayerRemovedExternally() throws Exception {
        String removedLayer = this.tileLayer.getName();
        String remainingLayer = this.tileLayerGroup.getName();
        HashSet layerNames = Sets.newHashSet((Object[])new String[]{removedLayer, remainingLayer});
        Mockito.when((Object)this.tld.getLayerNames()).thenReturn((Object)layerNames);
        ((TileLayerDispatcher)Mockito.doAnswer(invocation -> {
            layerNames.remove(removedLayer);
            return null;
        }).when((Object)this.tld)).reInit();
        ArgumentCaptor argCaptor = ArgumentCaptor.forClass(String.class);
        ((GWC)Mockito.doReturn((Object)true).when((Object)this.mediator)).layerRemoved((String)argCaptor.capture());
        this.mediator.reload();
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).reInit();
        Assert.assertEquals((long)1L, (long)argCaptor.getAllValues().size());
        Assert.assertEquals((Object)removedLayer, (Object)argCaptor.getValue());
    }

    @Test
    public void testIsServiceEnabled() {
        Service service = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)service.getPathName()).thenReturn((Object)"wms");
        this.defaults.setWMSCEnabled(true);
        Assert.assertTrue((boolean)this.mediator.isServiceEnabled(service));
        this.defaults.setWMSCEnabled(false);
        Assert.assertFalse((boolean)this.mediator.isServiceEnabled(service));
        Mockito.when((Object)service.getPathName()).thenReturn((Object)"tms");
        this.defaults.setTMSEnabled(true);
        Assert.assertTrue((boolean)this.mediator.isServiceEnabled(service));
        this.defaults.setTMSEnabled(false);
        Assert.assertFalse((boolean)this.mediator.isServiceEnabled(service));
        Mockito.when((Object)service.getPathName()).thenReturn((Object)"somethingElse");
        Assert.assertTrue((boolean)this.mediator.isServiceEnabled(service));
    }

    @Test
    public void testDispatchGetMapDoesntMatchTileCache() throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        rawKvp.put("layers", "more,than,one,layer");
        this.assertDispatchMismatch(request, "more than one layer requested");
        rawKvp.put("layers", "SomeNonCachedLayer");
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)"SomeNonCachedLayer"))).thenThrow(new Throwable[]{new GeoWebCacheException("layer not found")});
        this.assertDispatchMismatch(request, "not a tile layer");
        rawKvp.put("layers", this.tileLayer.getName());
        request.setFormat("badFormat");
        this.assertDispatchMismatch(request, "not a GWC supported format");
        request.setFormat("image/gif");
        this.assertDispatchMismatch(request, "no tile cache for requested format");
        request.setFormat(((MimeType)this.tileLayer.getMimeTypes().get(0)).getMimeType());
        request.setSRS("EPSG:4326");
        request.setBbox(new Envelope(10.0, 10.0, 20.0, 20.0));
        this.assertDispatchMismatch(request, "request does not align to grid");
        request.setSRS("EPSG:23036");
        this.assertDispatchMismatch(request, "no cache exists for requested CRS");
        request.setSRS("badCRS");
        this.assertDispatchMismatch(request, "exception occurred");
        request.setSRS("EPSG:4326");
        request.setWidth(128);
        request.setHeight(256);
        this.assertDispatchMismatch(request, "request does not align to grid");
        request.setWidth(256);
        request.setHeight(128);
        this.assertDispatchMismatch(request, "request does not align to grid");
        request.setSRS("EPSG:4326");
        request.setWidth(256);
        request.setHeight(256);
        this.assertDispatchMismatch(request, "request does not align to grid");
    }

    @Test
    public void testDispatchGetMapNonMatchingParameterFilter() throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        rawKvp.put("layers", this.tileLayer.getName());
        this.tileLayer.setEnabled(false);
        this.assertDispatchMismatch(request, "tile layer disabled");
        this.tileLayer.setEnabled(true);
        Assert.assertTrue((boolean)this.layer.enabled());
        request.setRemoteOwsURL(new URL("http://example.com"));
        this.assertDispatchMismatch(request, "remote OWS");
        request.setRemoteOwsURL(null);
        request.setRemoteOwsType("WFS");
        this.assertDispatchMismatch(request, "remote OWS");
        request.setRemoteOwsType(null);
        request.setEnv((Map)ImmutableMap.of((Object)"envVar", (Object)"envValue"));
        this.assertDispatchMismatch(request, "no parameter filter exists for ENV");
        request.setEnv(null);
        request.setFormatOptions((Map)ImmutableMap.of((Object)"optKey", (Object)"optVal"));
        this.assertDispatchMismatch(request, "no parameter filter exists for FORMAT_OPTIONS");
        request.setFormatOptions(null);
        request.setAngle(45.0);
        this.assertDispatchMismatch(request, "no parameter filter exists for ANGLE");
        request.setAngle(0.0);
        rawKvp.put("BGCOLOR", "0xAA0000");
        this.assertDispatchMismatch(request, "no parameter filter exists for BGCOLOR");
        rawKvp.remove("BGCOLOR");
        request.setBuffer(10);
        this.assertDispatchMismatch(request, "no parameter filter exists for BUFFER");
        request.setBuffer(0);
        request.setCQLFilter(Arrays.asList(CQL.toFilter((String)"ATT = 1")));
        this.assertDispatchMismatch(request, "no parameter filter exists for CQL_FILTER");
        request.setCQLFilter(null);
        request.setElevation(10.0);
        this.assertDispatchMismatch(request, "no parameter filter exists for ELEVATION");
        request.setElevation(Collections.emptyList());
        request.setFeatureId(Arrays.asList(new FeatureIdImpl("someid")));
        this.assertDispatchMismatch(request, "no parameter filter exists for FEATUREID");
        request.setFeatureId(null);
        request.setFilter(Arrays.asList(CQL.toFilter((String)"ATT = 1")));
        this.assertDispatchMismatch(request, "no parameter filter exists for FILTER");
        request.setFilter(null);
        request.setPalette(PaletteManager.getPalette((String)"SAFE"));
        this.assertDispatchMismatch(request, "no parameter filter exists for PALETTE");
        request.setPalette(null);
        request.setStartIndex(Integer.valueOf(10));
        this.assertDispatchMismatch(request, "no parameter filter exists for STARTINDEX");
        request.setStartIndex(null);
        request.setMaxFeatures(Integer.valueOf(1));
        this.assertDispatchMismatch(request, "no parameter filter exists for MAXFEATURES");
        request.setMaxFeatures(null);
        request.setTime(Arrays.asList(1, 2));
        this.assertDispatchMismatch(request, "no parameter filter exists for TIME");
        request.setTime(Collections.emptyList());
        ImmutableList viewParams = ImmutableList.of((Object)ImmutableMap.of((Object)"paramKey", (Object)"paramVal"));
        request.setViewParams((List)viewParams);
        this.assertDispatchMismatch(request, "no parameter filter exists for VIEWPARAMS");
        request.setViewParams(null);
        request.setFeatureVersion("@version");
        this.assertDispatchMismatch(request, "no parameter filter exists for FEATUREVERSION");
        request.setFeatureVersion(null);
    }

    @Test
    public void testNullsInDimensionAndTimeParameters() throws Exception {
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"ELEVATION", (boolean)true);
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"TIME", (boolean)true);
        this.tileLayer = new GeoServerTileLayer((PublishedInfo)this.layer, this.gridSetBroker, this.tileLayerInfo);
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        StringBuilder target = new StringBuilder();
        request.setElevation(Collections.singletonList(null));
        boolean cachingPossible = this.mediator.isCachingPossible((TileLayer)this.tileLayer, request, target);
        Assert.assertTrue((boolean)cachingPossible);
        Assert.assertEquals((long)0L, (long)target.length());
        request.setElevation(Collections.emptyList());
        request.setTime(Arrays.asList(new Object[]{null}));
        cachingPossible = this.mediator.isCachingPossible((TileLayer)this.tileLayer, request, target);
        Assert.assertTrue((boolean)cachingPossible);
        Assert.assertEquals((long)0L, (long)target.length());
    }

    @Test
    public void testCQLFILTERParameters() throws Exception {
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"CQL_FILTER", (boolean)true);
        this.tileLayer = new GeoServerTileLayer((PublishedInfo)this.layer, this.gridSetBroker, this.tileLayerInfo);
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        rawKvp.put("CQL_FILTER", "include");
        request.setRawKvp((Map)rawKvp);
        StringBuilder target = new StringBuilder();
        List<Filter> cqlFilters = Collections.singletonList(CQL.toFilter((String)"include"));
        request.setCQLFilter(cqlFilters);
        Assert.assertTrue((boolean)this.mediator.isCachingPossible((TileLayer)this.tileLayer, request, target));
        Assert.assertEquals((long)0L, (long)target.length());
        request.setFilter(cqlFilters);
        Assert.assertTrue((boolean)this.mediator.isCachingPossible((TileLayer)this.tileLayer, request, target));
        Assert.assertEquals((long)0L, (long)target.length());
        ArrayList<Filter> filters = new ArrayList<Filter>(cqlFilters);
        filters.add((Filter)Filter.INCLUDE);
        request.setFilter(filters);
        Assert.assertFalse((boolean)this.mediator.isCachingPossible((TileLayer)this.tileLayer, request, target));
        Assert.assertNotEquals((long)0L, (long)target.length());
    }

    private void assertDispatchMismatch(GetMapRequest request, String expectedReason) {
        StringBuilder target = new StringBuilder();
        Assert.assertNull((Object)this.mediator.dispatch(request, target));
        Assert.assertTrue((String)("mismatch reason '" + target + "' does not contain '" + expectedReason + "'"), (boolean)target.toString().contains(expectedReason));
    }

    @Test
    public void testGetMapRequest() throws Throwable {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        rawKvp.put("GWC_SEED_INTERCEPT", "true");
        request.setRawKvp((Map)rawKvp);
        rawKvp.put("layers", "test:mockLayer");
        RawMap rawMap = new RawMap(new WMSMapContent(request), new byte[0], "image/png");
        WebMapService mapService = (WebMapService)Mockito.mock(DefaultWebMapService.class);
        Mockito.when((Object)mapService.getMap(request)).thenReturn((Object)rawMap);
        Method getMapMethod = WebMapService.class.getMethod("getMap", GetMapRequest.class);
        PassThroughMethodInvocation invocation = new PassThroughMethodInvocation(mapService, getMapMethod, request);
        this.mediator.getConfig().setDirectWMSIntegrationEnabled(true);
        this.mediator.getConfig().setRequireTiledParameter(false);
        CachingWebMapService cwms = new CachingWebMapService(this.mediator);
        WebMap webMap = cwms.invoke((MethodInvocation)invocation);
        Assert.assertNull((Object)webMap.getResponseHeaders());
        GetMapRequest requestWithoutSeedKey = new GetMapRequest();
        rawKvp.remove("GWC_SEED_INTERCEPT");
        requestWithoutSeedKey.setRawKvp((Map)rawKvp);
        RawMap rawMap2 = new RawMap(new WMSMapContent(requestWithoutSeedKey), new byte[0], "image/png");
        Mockito.when((Object)mapService.getMap(requestWithoutSeedKey)).thenReturn((Object)rawMap2);
        PassThroughMethodInvocation invocation2 = new PassThroughMethodInvocation(mapService, getMapMethod, requestWithoutSeedKey);
        WebMap webMapWithoutSeed = cwms.invoke((MethodInvocation)invocation2);
        Assert.assertEquals((Object)"geowebcache-cache-result", (Object)webMapWithoutSeed.getResponseHeaders()[0][0]);
    }

    @Test
    public void testDispatchGetMapMultipleCrsMatchingGridSubsets() throws Exception {
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "EPSG:4326", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "EPSG:4326", new long[]{10L, 10L, 10L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{10L, 10L, 10L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{10L, 10L, 10L});
    }

    private void testMultipleCrsMatchingGridSubsets(String srs, String expectedGridset, long[] tileIndex) throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        request.setFormat("image/png");
        request.setSRS(srs);
        request.setWidth(256);
        request.setHeight(256);
        rawKvp.put("layers", "mockLayer");
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        this.tileLayer = this.mockTileLayer("mockLayer", gridSetNames);
        BoundingBox bounds = this.tileLayer.getGridSubset(expectedGridset).boundsFromIndex(tileIndex);
        Envelope reqBbox = new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
        request.setBbox(reqBbox);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ConveyorTile.class);
        StringBuilder errors = new StringBuilder();
        this.mediator.dispatch(request, errors);
        Assert.assertEquals((String)errors.toString(), (long)0L, (long)errors.length());
        ((GeoServerTileLayer)Mockito.verify((Object)this.tileLayer, (VerificationMode)Mockito.times((int)1))).getTile((ConveyorTile)captor.capture());
        ConveyorTile tileRequest = (ConveyorTile)captor.getValue();
        Assert.assertEquals((Object)expectedGridset, (Object)tileRequest.getGridSetId());
        Assert.assertEquals((Object)"image/png", (Object)tileRequest.getMimeType().getMimeType());
        Assert.assertArrayEquals((String)("Expected " + Arrays.toString(tileIndex) + " got " + Arrays.toString(tileRequest.getTileIndex())), (long[])tileIndex, (long[])tileRequest.getTileIndex());
    }

    private GeoServerTileLayer mockTileLayer(String layerName, List<String> gridSetNames) throws Exception {
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)this.tld.layerExists((String)ArgumentMatchers.eq((Object)layerName))).thenReturn((Object)true);
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)layerName))).thenReturn((Object)tileLayer);
        Mockito.when((Object)tileLayer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)tileLayer.isEnabled()).thenReturn((Object)true);
        MimeType mimeType1 = MimeType.createFromFormat((String)"image/png");
        MimeType mimeType2 = MimeType.createFromFormat((String)"image/jpeg");
        Mockito.when((Object)tileLayer.getMimeTypes()).thenReturn((Object)ImmutableList.of((Object)mimeType1, (Object)mimeType2));
        HashMap subsets = Maps.newHashMap();
        LinkedHashMultimap bySrs = LinkedHashMultimap.create();
        GridSetBroker broker = this.gridSetBroker;
        for (String gsetName : gridSetNames) {
            GridSet gridSet = broker.get(gsetName);
            XMLGridSubset xmlGridSubset = new XMLGridSubset();
            String gridSetName = gridSet.getName();
            xmlGridSubset.setGridSetName(gridSetName);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(broker);
            subsets.put(gsetName, gridSubSet);
            bySrs.put((Object)gridSet.getSrs(), (Object)gridSubSet);
            Mockito.when((Object)tileLayer.getGridSubset((String)ArgumentMatchers.eq((Object)gsetName))).thenReturn((Object)gridSubSet);
        }
        for (SRS srs : bySrs.keySet()) {
            ImmutableList list = ImmutableList.copyOf((Collection)bySrs.get((Object)srs));
            Mockito.when((Object)tileLayer.getGridSubsetsForSRS((SRS)ArgumentMatchers.eq((Object)srs))).thenReturn((Object)list);
        }
        Mockito.when((Object)tileLayer.getGridSubsets()).thenReturn(subsets.keySet());
        for (String gsetName : gridSetNames) {
            Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains(gsetName));
            Assert.assertNotNull((Object)tileLayer.getGridSubset(gsetName));
        }
        return tileLayer;
    }

    @Test
    public void testDispatchGetMapWithMatchingParameterFilters() throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        request.setFormat("image/png");
        request.setSRS("EPSG:900913");
        request.setWidth(256);
        request.setHeight(256);
        rawKvp.put("layers", this.tileLayer.getName());
        BoundingBox bounds = this.tileLayer.getGridSubset("EPSG:900913").boundsFromIndex(new long[]{0L, 0L, 1L});
        Envelope reqBbox = new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
        request.setBbox(reqBbox);
        Assert.assertFalse((boolean)this.tileLayer.getInfo().cachedStyles().isEmpty());
        for (String style : this.tileLayer.getInfo().cachedStyles()) {
            if (style != null && style.equals("default")) continue;
            String rawKvpParamName = "styles";
            String rawKvpParamValue = style;
            this.testParameterFilter(request, (Map<String, String>)rawKvp, rawKvpParamName, rawKvpParamValue);
        }
        request.setEnv((Map)ImmutableMap.of((Object)"envKey", (Object)"envValue"));
        TileLayerInfoUtil.updateStringParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"ENV", (boolean)true, (String)"def:devVal", (String[])new String[]{"envKey:envValue", "envKey2:envValue2"});
        this.testParameterFilter(request, (Map<String, String>)rawKvp, "env", "envKey:envValue");
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"ANGLE", (boolean)true);
        request.setAngle(60.0);
        this.testParameterFilter(request, (Map<String, String>)rawKvp, "angle", "60.0");
        request.setAngle(61.1);
        this.testParameterFilter(request, (Map<String, String>)rawKvp, "angle", "61.1");
    }

    private void testParameterFilter(GetMapRequest request, Map<String, String> rawKvp, String rawKvpParamName, String rawKvpParamValue) {
        rawKvp.put(rawKvpParamName, rawKvpParamValue);
        StringBuilder errors = new StringBuilder();
        ConveyorTile tileRequest = this.mediator.prepareRequest((TileLayer)this.tileLayer, request, errors);
        Assert.assertEquals((String)errors.toString(), (long)0L, (long)errors.length());
        Map fullParameters = tileRequest.getFilteringParameters();
        Assert.assertEquals((String)fullParameters.toString(), (Object)rawKvpParamValue, fullParameters.get(rawKvpParamName.toUpperCase()));
    }

    @Test
    public void testGetDefaultAdvertisedCachedFormats() {
        ImmutableSet defaultFormats = ImmutableSet.of((Object)"image/png", (Object)"image/png8", (Object)"image/jpeg", (Object)"image/gif", (Object)"image/vnd.jpeg-png", (Object)"image/vnd.jpeg-png8", (Object[])new String[0]);
        Sets.SetView formatsWithUtfGrid = Sets.union((Set)defaultFormats, Collections.singleton("application/json;type=utfgrid"));
        Assert.assertEquals((Object)formatsWithUtfGrid, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.VECTOR));
        Assert.assertEquals((Object)formatsWithUtfGrid, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.REMOTE));
        Assert.assertEquals((Object)defaultFormats, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.RASTER));
        Assert.assertEquals((Object)defaultFormats, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.WMS));
        Assert.assertEquals((Object)formatsWithUtfGrid, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.GROUP));
    }

    @Test
    public void testGetPluggabledAdvertisedCachedFormats() throws IOException {
        ArrayList urls;
        try {
            String defaultResource = "org/geoserver/gwc/advertised_formats.properties";
            String testResource = "org/geoserver/gwc/advertised_formats_unittesting.properties";
            ClassLoader classLoader = GWC.class.getClassLoader();
            urls = Lists.newArrayList((Iterator)Iterators.forEnumeration(classLoader.getResources(defaultResource)));
            urls.addAll(Lists.newArrayList((Iterator)Iterators.forEnumeration(classLoader.getResources(testResource))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ImmutableSet defaultFormats = ImmutableSet.of((Object)"image/png", (Object)"image/png8", (Object)"image/jpeg", (Object)"image/gif", (Object)"image/vnd.jpeg-png", (Object)"image/vnd.jpeg-png8", (Object[])new String[0]);
        Sets.SetView expectedVector = Sets.union((Set)defaultFormats, (Set)ImmutableSet.of((Object)"test/vector1", (Object)"test/vector2", (Object)"application/json;type=utfgrid"));
        Sets.SetView expectedRaster = Sets.union((Set)defaultFormats, (Set)ImmutableSet.of((Object)"test/raster1", (Object)"test/raster2;type=test"));
        Sets.SetView expectedGroup = Sets.union((Set)defaultFormats, (Set)ImmutableSet.of((Object)"test/group1", (Object)"test/group2", (Object)"application/json;type=utfgrid"));
        Assert.assertEquals((Object)expectedVector, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.VECTOR, (Iterable)urls));
        Assert.assertEquals((Object)expectedVector, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.REMOTE, (Iterable)urls));
        Assert.assertEquals((Object)expectedRaster, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.RASTER, (Iterable)urls));
        Assert.assertEquals((Object)expectedRaster, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.WMS, (Iterable)urls));
        Assert.assertEquals((Object)expectedGroup, (Object)GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.GROUP, (Iterable)urls));
    }

    @Test
    public void testSetBlobStoresNull() throws ConfigurationException {
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.mediator.setBlobStores(null));
        Assert.assertTrue((boolean)e.getMessage().contains("stores is null"));
    }

    @Test
    public void testSetBlobStoresSavesConfig() throws Exception {
        Mockito.when((Object)this.xmlConfig.getBlobStores()).thenReturn((Object)ImmutableList.of());
        CompositeBlobStore composite = (CompositeBlobStore)Mockito.mock(CompositeBlobStore.class);
        ((GWC)Mockito.doReturn((Object)composite).when((Object)this.mediator)).getCompositeBlobStore();
        ArrayList configList = Lists.newArrayList((Object[])new BlobStoreInfo[]{(BlobStoreInfo)Mockito.mock(BlobStoreInfo.class), (BlobStoreInfo)Mockito.mock(BlobStoreInfo.class)});
        Mockito.when((Object)((BlobStoreInfo)configList.get(0)).getName()).thenReturn((Object)"store0");
        Mockito.when((Object)((BlobStoreInfo)configList.get(1)).getName()).thenReturn((Object)"store1");
        Mockito.when((Object)this.blobStoreAggregator.getBlobStores()).thenReturn((Object)configList);
        Mockito.when((Object)this.blobStoreAggregator.getBlobStoreNames()).thenReturn(Arrays.asList("store0", "store1"));
        FileBlobStoreInfo config = new FileBlobStoreInfo("TestBlobStore");
        ImmutableList newStores = ImmutableList.of((Object)config);
        this.mediator.setBlobStores((List)newStores);
        ((BlobStoreAggregator)Mockito.verify((Object)this.blobStoreAggregator, (VerificationMode)Mockito.times((int)1))).removeBlobStore((String)ArgumentMatchers.eq((Object)((BlobStoreInfo)configList.get(0)).getName()));
        ((BlobStoreAggregator)Mockito.verify((Object)this.blobStoreAggregator, (VerificationMode)Mockito.times((int)1))).removeBlobStore((String)ArgumentMatchers.eq((Object)((BlobStoreInfo)configList.get(1)).getName()));
        ((BlobStoreAggregator)Mockito.verify((Object)this.blobStoreAggregator, (VerificationMode)Mockito.times((int)1))).addBlobStore((BlobStoreInfo)ArgumentMatchers.eq((Object)config));
    }

    @Test
    public void testSetBlobStoresRestoresRuntimeStoresOnSaveFailure() throws Exception {
        Mockito.when((Object)this.blobStoreAggregator.getBlobStores()).thenReturn((Object)ImmutableList.of());
        CompositeBlobStore composite = (CompositeBlobStore)Mockito.mock(CompositeBlobStore.class);
        ((GWC)Mockito.doReturn((Object)composite).when((Object)this.mediator)).getCompositeBlobStore();
        FileBlobStoreInfo config = new FileBlobStoreInfo("TestStore");
        ((BlobStoreAggregator)Mockito.doThrow((Throwable[])new Throwable[]{new ConfigurationPersistenceException((Throwable)new IOException("expected"))}).when((Object)this.blobStoreAggregator)).addBlobStore((BlobStoreInfo)config);
        ArrayList oldStores = Lists.newArrayList((Object[])new BlobStoreInfo[]{(BlobStoreInfo)Mockito.mock(BlobStoreInfo.class), (BlobStoreInfo)Mockito.mock(BlobStoreInfo.class)});
        Mockito.when((Object)this.blobStoreAggregator.getBlobStores()).thenReturn((Object)oldStores);
        ImmutableList newStores = ImmutableList.of((Object)config);
        try {
            this.mediator.setBlobStores((List)newStores);
            Assert.fail((String)"Expected ConfigurationException");
        }
        catch (ConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error saving config"));
        }
    }

    @Test
    public void testGeoServerEnvParametrization() throws Exception {
        if (GeoServerEnvironment.allowEnvParametrization()) {
            Assert.assertEquals((Object)"HSQL", (Object)this.jdbcStorage.getJDBCDiskQuotaConfig().clone(true).getDialect());
        }
    }

    @Test
    public void testGWCEnvParametrization() {
        if (GeoServerEnvironment.allowEnvParametrization()) {
            GeoWebCacheEnvironment gwcEnvironment = (GeoWebCacheEnvironment)GeoWebCacheExtensions.bean(GeoWebCacheEnvironment.class);
            Assert.assertEquals((Object)"TEST VALUE", (Object)gwcEnvironment.resolveValue((Object)"${TEST}"));
        }
    }

    @Test
    public void testBuildMetatilingExecutor() throws IOException {
        GWCConfig newConfig = new GWCConfig();
        newConfig.setMetaTilingThreads(Integer.valueOf(12));
        this.mediator.saveConfig(newConfig);
        Assert.assertNotNull((Object)this.mediator.getMetaTilingExecutor());
        Assert.assertEquals((long)12L, (long)((ThreadPoolExecutor)this.mediator.getMetaTilingExecutor()).getCorePoolSize());
        newConfig = new GWCConfig();
        newConfig.setMetaTilingThreads(null);
        this.mediator.saveConfig(newConfig);
        Assert.assertNotNull((Object)this.mediator.getMetaTilingExecutor());
        Assert.assertEquals((long)(Runtime.getRuntime().availableProcessors() * 2), (long)((ThreadPoolExecutor)this.mediator.getMetaTilingExecutor()).getCorePoolSize());
        newConfig = new GWCConfig();
        newConfig.setMetaTilingThreads(Integer.valueOf(0));
        this.mediator.saveConfig(newConfig);
        Assert.assertNull((Object)this.mediator.getMetaTilingExecutor());
    }

    @AfterClass
    public static void destroyAppContext() {
        GeoServerExtensionsHelper.init(null);
    }
}

