/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.gwc.layer.DefaultTileLayerCatalog;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileSystemWatcher;
import org.geoserver.util.DimensionWarning;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DefaultTileLayerCatalogTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private File baseDirectory;
    private GeoServerResourceLoader resourceLoader;
    private DefaultTileLayerCatalog catalog;

    @Before
    public void setUp() throws Exception {
        this.baseDirectory = this.tmpFolder.getRoot();
        this.resourceLoader = new GeoServerResourceLoader(this.baseDirectory);
        new File(this.baseDirectory, "gwc-layers").mkdir();
        Supplier<XStream> xStream = () -> XMLConfiguration.getConfiguredXStreamWithContext((XStream)new SecureXStream(), null, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.PERSIST);
        this.catalog = new DefaultTileLayerCatalog(this.resourceLoader, xStream);
        this.catalog.initialize();
    }

    @Test
    public void testGetLayerById() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        this.catalog.save((GeoServerTileLayerInfo)info);
        GeoServerTileLayerInfo actual = this.catalog.getLayerById("id1");
        actual = (GeoServerTileLayerInfo)ModificationProxy.unwrap((Object)actual);
        Assert.assertEquals((Object)info, (Object)actual);
    }

    @Test
    public void testGetLayerByName() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        this.catalog.save((GeoServerTileLayerInfo)info);
        GeoServerTileLayerInfo actual = this.catalog.getLayerByName("name1");
        actual = (GeoServerTileLayerInfo)ModificationProxy.unwrap((Object)actual);
        Assert.assertEquals((Object)info, (Object)actual);
    }

    @Test
    public void testDelete() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        this.catalog.save((GeoServerTileLayerInfo)info);
        GeoServerTileLayerInfo actual = this.catalog.getLayerByName("name1");
        actual = (GeoServerTileLayerInfo)ModificationProxy.unwrap((Object)actual);
        Assert.assertEquals((Object)info, (Object)actual);
        GeoServerTileLayerInfo deleted = this.catalog.delete("id1");
        Assert.assertEquals((Object)info, (Object)ModificationProxy.unwrap((Object)deleted));
        Assert.assertNull((Object)this.catalog.getLayerById("id1"));
    }

    @Test
    public void testSave() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        info.getMimeFormats().add("image/png");
        info.getMimeFormats().add("image/jpeg");
        Assert.assertNull((Object)this.catalog.save((GeoServerTileLayerInfo)info));
        GeoServerTileLayerInfo original = this.catalog.getLayerById("id1");
        Assert.assertEquals((Object)info.getMimeFormats(), (Object)original.getMimeFormats());
        original.getMimeFormats().clear();
        original.getMimeFormats().add("image/gif");
        original.setName("name2");
        GeoServerTileLayerInfo oldValue = this.catalog.save(original);
        Assert.assertNotNull((Object)oldValue);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"image/png", (Object)"image/jpeg"), (Object)oldValue.getMimeFormats());
        Assert.assertEquals((Object)"name1", (Object)oldValue.getName());
        Assert.assertNull((Object)this.catalog.getLayerByName("name1"));
        Assert.assertNotNull((Object)this.catalog.getLayerByName("name2"));
        GeoServerTileLayerInfo modified = this.catalog.getLayerById("id1");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"image/gif"), (Object)modified.getMimeFormats());
    }

    @Test
    public void testSaveWithEmptyStyleParamFilter() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        info.getMimeFormats().add("image/png");
        info.getMimeFormats().add("image/jpeg");
        StyleParameterFilter parameterFilter = new StyleParameterFilter();
        parameterFilter.setStyles(Collections.emptySet());
        info.addParameterFilter((ParameterFilter)parameterFilter);
        Assert.assertNull((Object)this.catalog.save((GeoServerTileLayerInfo)info));
        GeoServerTileLayerInfo original = this.catalog.getLayerById("id1");
        Assert.assertEquals((Object)info.getMimeFormats(), (Object)original.getMimeFormats());
        original.getMimeFormats().clear();
        original.getMimeFormats().add("image/gif");
        original.setName("name2");
        GeoServerTileLayerInfo oldValue = this.catalog.save(original);
        Assert.assertNotNull((Object)oldValue);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"image/png", (Object)"image/jpeg"), (Object)oldValue.getMimeFormats());
        Assert.assertEquals((Object)"name1", (Object)oldValue.getName());
        Assert.assertNull((Object)this.catalog.getLayerByName("name1"));
        Assert.assertNotNull((Object)this.catalog.getLayerByName("name2"));
        GeoServerTileLayerInfo modified = this.catalog.getLayerById("id1");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"image/gif"), (Object)modified.getMimeFormats());
    }

    @Test
    public void testEvents() throws IOException, InterruptedException {
        ((FileSystemWatcher)this.resourceLoader.getResourceNotificationDispatcher()).schedule(50L, TimeUnit.MILLISECONDS);
        AtomicBoolean hasBeenCreated = new AtomicBoolean(false);
        AtomicBoolean hasBeenModified = new AtomicBoolean(false);
        AtomicBoolean hasBeenDeleted = new AtomicBoolean(false);
        this.catalog.addListener((layerId, type) -> {
            switch (type) {
                case CREATE: {
                    hasBeenCreated.set(true);
                    break;
                }
                case DELETE: {
                    hasBeenDeleted.set(true);
                    break;
                }
                case MODIFY: {
                    hasBeenModified.set(true);
                    break;
                }
            }
        });
        File file = new File(this.baseDirectory, "gwc-layers/id1.xml");
        this.writeFileLayerInfoImpl(file, "originalname");
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(hasBeenCreated::get);
        GeoServerTileLayerInfo info = this.catalog.getLayerById("id1");
        Assert.assertEquals((Object)"originalname", (Object)info.getName());
        Assert.assertNotNull((Object)this.catalog.getLayerByName("originalname"));
        long lastModified = file.lastModified();
        Awaitility.await().atMost(1100L, TimeUnit.MILLISECONDS).until(() -> {
            this.writeFileLayerInfoImpl(file, "newname");
            return file.lastModified() > lastModified;
        });
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(hasBeenModified::get);
        info = this.catalog.getLayerById("id1");
        Assert.assertEquals((Object)"newname", (Object)info.getName());
        Assert.assertNull((Object)this.catalog.getLayerByName("originalname"));
        Assert.assertNotNull((Object)this.catalog.getLayerByName("newname"));
        file.delete();
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(hasBeenDeleted::get);
        Assert.assertNull((Object)this.catalog.getLayerById("id1"));
        Assert.assertNull((Object)this.catalog.getLayerByName("newname"));
    }

    private void writeFileLayerInfoImpl(File file, String name) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)("<org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl><id>id1</id><name>" + name + "</name></org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl>"), (String)"UTF-8");
    }

    @Test
    public void testSavedXML() throws IOException, SAXException, XpathException {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        info.getMimeFormats().add("image/png");
        info.getMimeFormats().add("image/jpeg");
        info.setCacheWarningSkips(new LinkedHashSet<DimensionWarning.WarningType>(Arrays.asList(DimensionWarning.WarningType.values())));
        StyleParameterFilter parameterFilter = new StyleParameterFilter();
        parameterFilter.setStyles(Collections.emptySet());
        info.addParameterFilter((ParameterFilter)parameterFilter);
        Assert.assertNull((Object)this.catalog.save((GeoServerTileLayerInfo)info));
        GeoServerTileLayerInfo original = this.catalog.getLayerById("id1");
        Assert.assertEquals((Object)info.getMimeFormats(), (Object)original.getMimeFormats());
        original.getMimeFormats().clear();
        original.getMimeFormats().add("image/gif");
        original.setName("name2");
        this.catalog.save(original);
        File file = new File(this.baseDirectory, "gwc-layers/id1.xml");
        String xml = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Document doc = XMLUnit.buildControlDocument((String)xml);
        Assert.assertEquals((Object)"", (Object)xpath.evaluate("//cacheWarningSkips/class", doc));
        Assert.assertEquals((Object)"Default", (Object)xpath.evaluate("//cacheWarningSkips/warning[1]", doc));
        Assert.assertEquals((Object)"Nearest", (Object)xpath.evaluate("//cacheWarningSkips/warning[2]", doc));
        Assert.assertEquals((Object)"FailedNearest", (Object)xpath.evaluate("//cacheWarningSkips/warning[3]", doc));
    }
}

