/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.util.DimensionWarning;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.w3c.dom.Document;

public class GWCConfigPersisterTest {
    private GeoServerResourceLoader resourceLoader;
    private GWCConfigPersister persister;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.resourceLoader = (GeoServerResourceLoader)Mockito.mock(GeoServerResourceLoader.class);
        this.persister = new GWCConfigPersister(new XStreamPersisterFactory(), this.resourceLoader);
    }

    @Test
    public void testPrecondition() throws Exception {
        Mockito.when((Object)this.resourceLoader.find((String)ArgumentMatchers.eq((Object)"gwc-gs.xml"))).thenReturn(null);
        try {
            this.persister.getConfig();
            Assert.fail((String)"Expected assertion error");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("gwc-gs.xml"));
        }
    }

    @Test
    public void testSaveLoad() throws Exception {
        File baseDirectory = new File("target");
        baseDirectory.mkdirs();
        File configFile = new File(baseDirectory, "gwc-gs.xml");
        if (configFile.exists()) {
            Assert.assertTrue((boolean)configFile.delete());
        }
        Mockito.when((Object)this.resourceLoader.get("")).thenReturn((Object)Files.asResource((File)baseDirectory));
        Mockito.when((Object)this.resourceLoader.get((String)ArgumentMatchers.eq((Object)"gwc-gs.xml"))).thenReturn((Object)Files.asResource((File)configFile));
        GWCConfig config = GWCConfig.getOldDefaults();
        config.setCacheNonDefaultStyles(true);
        config.setDirectWMSIntegrationEnabled(true);
        config.setMetaTilingThreads(Integer.valueOf(12));
        config.setCacheWarningSkips(new LinkedHashSet<DimensionWarning.WarningType>(Arrays.asList(DimensionWarning.WarningType.Default, DimensionWarning.WarningType.FailedNearest)));
        this.persister.save(config);
        Assert.assertSame((Object)config, (Object)this.persister.getConfig());
        this.persister = new GWCConfigPersister(new XStreamPersisterFactory(), this.resourceLoader);
        Assert.assertEquals((Object)config, (Object)this.persister.getConfig());
        Mockito.when((Object)this.resourceLoader.get((String)ArgumentMatchers.eq((Object)"gwc-gs.xml"))).thenReturn((Object)Files.asResource((File)this.tempFolder.newFile("shall_not_exist")));
        this.persister = new GWCConfigPersister(new XStreamPersisterFactory(), this.resourceLoader);
        GWCConfig expected = new GWCConfig();
        GWCConfig actual = this.persister.getConfig();
        Assert.assertEquals((Object)expected, (Object)actual);
        String xml = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Document doc = XMLUnit.buildControlDocument((String)xml);
        Assert.assertEquals((Object)"", (Object)xpath.evaluate("//cacheWarningSkips/class", doc));
        Assert.assertEquals((Object)"Default", (Object)xpath.evaluate("//cacheWarningSkips/warning[1]", doc));
        Assert.assertEquals((Object)"FailedNearest", (Object)xpath.evaluate("//cacheWarningSkips/warning[2]", doc));
    }
}

