/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletResponse;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.geoserver.data.test.MockData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.springframework.mock.web.MockHttpServletResponse;

@Ignore
public class WmsMetatileBenchmarkTest
extends GeoServerSystemTestSupport {
    static final String LAYER_NAME = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();

    @Test
    @Ignore
    public void profileBenchmark() throws Exception {
        long[][] uniqueMetaTileIndices;
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
        GWCConfig config = GWC.get().getConfig();
        config.setMetaTilingThreads(Integer.valueOf(2 * Runtime.getRuntime().availableProcessors()));
        GWC.get().saveConfig(config);
        for (long[] metaTileIndex : uniqueMetaTileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 10, 1000, 4, 1)) {
            String request = WmsMetatileBenchmarkTest.buildGetMap(LAYER_NAME, metaTileIndex);
            MockHttpServletResponse response = this.getAsServletResponse(request);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
            MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        }
    }

    @Test
    public void runBenchmark() throws Exception {
        Options options = new OptionsBuilder().include(WmsMetatileBenchmark.class.getSimpleName() + ".*").result("./target/benchmark-results.json").resultFormat(ResultFormatType.JSON).build();
        new Runner(options).run();
    }

    private static long[][] getTileIndices(String layerName, BoundingBox boundingBox, int zoomLevel, int amount, int metaTileSize, int tilesPerMetatile) {
        long currentY;
        long currentX;
        GWC gwc = GWC.get();
        TileLayer tileLayer = gwc.getTileLayerByName(layerName);
        GridSubset gridSubset = tileLayer.getGridSubset("EPSG:4326");
        long[] coverage = boundingBox == null ? gridSubset.getCoverage(zoomLevel) : gridSubset.getCoverageIntersection(zoomLevel, boundingBox);
        System.out.printf("Coverage: %d, %d, %d, %d, %d (minx, miny, maxx, maxy, zoomLevel)\n", coverage[0], coverage[1], coverage[2], coverage[3], coverage[4]);
        long[][] indices = new long[amount][3];
        long minX = currentX = coverage[0];
        long minY = currentY = coverage[1];
        long maxX = coverage[2];
        long maxY = coverage[3];
        long width = maxX - minX;
        long height = maxY - minY;
        long maxNumberOfNonOverlappingMetaTilesHorizontally = width / (long)metaTileSize;
        long maxNumberOfNonOverlappingMetaTilesVertically = height / (long)metaTileSize;
        System.out.println("Max number of metatiles with coverage: " + maxNumberOfNonOverlappingMetaTilesHorizontally * maxNumberOfNonOverlappingMetaTilesVertically);
        long horizontalIncrementBetweenMetaTiles = width / maxNumberOfNonOverlappingMetaTilesHorizontally;
        long verticalIncrementBetweenMetaTiles = height / maxNumberOfNonOverlappingMetaTilesVertically;
        long numberOfMetaTiles = amount / tilesPerMetatile;
        int tileCount = 0;
        int metaTileIndex = 0;
        while ((long)metaTileIndex < numberOfMetaTiles) {
            long currentXWithinMetaTile = 0L;
            long currentYWithinMetaTile = 0L;
            for (int tileIndex = 0; tileIndex < tilesPerMetatile; ++tileIndex) {
                indices[tileCount] = new long[]{currentX + currentXWithinMetaTile, currentY + currentYWithinMetaTile, zoomLevel};
                ++tileCount;
                if (++currentXWithinMetaTile <= (long)metaTileSize) continue;
                currentXWithinMetaTile = 0L;
                ++currentYWithinMetaTile;
            }
            if ((currentX += horizontalIncrementBetweenMetaTiles) > maxX - (long)metaTileSize) {
                currentX = minX;
                currentY += verticalIncrementBetweenMetaTiles;
            }
            if (currentY > maxY) {
                throw new RuntimeException("Grid subset isn't large enough to generate the desired number of non-conflicting metatiles; try a larger zoom level.");
            }
            ++metaTileIndex;
        }
        return indices;
    }

    private static String buildGetMap(String layerName, long[] tileIndex) {
        String gridsetId = "EPSG:4326";
        GWC gwc = GWC.get();
        TileLayer tileLayer = gwc.getTileLayerByName(layerName);
        GridSubset gridSubset = tileLayer.getGridSubset(gridsetId);
        BoundingBox bounds = gridSubset.boundsFromIndex(tileIndex);
        StringBuilder sb = new StringBuilder("wms");
        sb.append("?service=WMS&request=GetMap&version=1.1.1&format=image/png");
        sb.append("&layers=").append(layerName);
        sb.append("&srs=").append(gridSubset.getSRS());
        sb.append("&width=").append(gridSubset.getGridSet().getTileWidth());
        sb.append("&height=").append(gridSubset.getGridSet().getTileHeight());
        sb.append("&styles=");
        sb.append("&bbox=").append(bounds.toString());
        sb.append("&tilesorigin=-180.0,90.0");
        sb.append("&tiled=true");
        return sb.toString();
    }

    static void saveToCsv(String location, long[][] tileIndices) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(location));){
            String gridsetId = "EPSG:4326";
            GWC gwc = GWC.get();
            TileLayer tileLayer = gwc.getTileLayerByName(LAYER_NAME);
            GridSubset gridSubset = tileLayer.getGridSubset(gridsetId);
            for (long[] tileIndex : tileIndices) {
                BoundingBox bounds = gridSubset.boundsFromIndex(tileIndex);
                writer.println(bounds.toString());
            }
        }
    }

    @BenchmarkMode(value={Mode.Throughput})
    @Fork(value=1)
    @Threads(value=4)
    @Warmup(iterations=2, time=1)
    @Measurement(time=1)
    public static class WmsMetatileBenchmark {
        @Benchmark
        public ServletResponse runWithGwcWithConcurrencyAndNoCacheHits(GwcWithConcurrencyAndNoCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithGwcWithoutConcurrencyAndNoCacheHits(GwcWithoutConcurrencyAndNoCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithGwcWithConcurrencyAnd50PercentCacheHits(GwcWithConcurrencyAnd50PercentCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithGwcWithoutConcurrencyAnd50PercentCacheHits(GwcWithoutConcurrencyAnd50PercentCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithGwcWithConcurrencyAnd75PercentCacheHits(GwcWithConcurrencyAnd75PercentCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithGwcWithoutConcurrencyAnd75PercentCacheHits(GwcWithoutConcurrencyAnd75PercentCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithGwcWithConcurrencyAnd90PercentCacheHits(GwcWithConcurrencyAnd90PercentCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithGwcWithoutConcurrencyAnd90PercentCacheHits(GwcWithoutConcurrencyAnd90PercentCacheHitsState state) throws Exception {
            return this.run(state);
        }

        @Benchmark
        public ServletResponse runWithoutGwc(NoGwcState state) throws Exception {
            return this.run(state);
        }

        private ServletResponse run(AbstractBenchmarkState state) throws Exception {
            int currentIndex = state.currentIndex.getAndIncrement();
            long[] metaTileIndex = state.tileIndices[currentIndex];
            String request = WmsMetatileBenchmarkTest.buildGetMap(LAYER_NAME, metaTileIndex);
            MockHttpServletResponse response = state.geoServerSystemTestSupport.getAsServletResponse(request);
            String cacheResult = response.getHeader("geowebcache-cache-result");
            if (cacheResult == null) {
                cacheResult = "MISS";
            }
            state.cacheHitRate.compute(cacheResult, (key, value) -> value == null ? 1 : value + 1);
            return response;
        }

        public static class NoGwcState
        extends AbstractBenchmarkState {
            @Override
            public void setup() throws Exception {
                super.setup();
                GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 1);
            }
        }

        public static class GwcWithoutConcurrencyAnd90PercentCacheHitsState
        extends AbstractGwcWithoutConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 16);
                WmsMetatileBenchmarkTest.saveToCsv("./target/90-percent-hits.csv", this.tileIndices);
            }
        }

        public static class GwcWithConcurrencyAnd90PercentCacheHitsState
        extends AbstractGwcWithConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 16);
                WmsMetatileBenchmarkTest.saveToCsv("./target/90-percent-hits.csv", this.tileIndices);
            }
        }

        public static class GwcWithoutConcurrencyAnd75PercentCacheHitsState
        extends AbstractGwcWithoutConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 4);
                WmsMetatileBenchmarkTest.saveToCsv("./target/75-percent-hits.csv", this.tileIndices);
            }
        }

        public static class GwcWithConcurrencyAnd75PercentCacheHitsState
        extends AbstractGwcWithConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 4);
                WmsMetatileBenchmarkTest.saveToCsv("./target/75-percent-hits.csv", this.tileIndices);
            }
        }

        public static class GwcWithoutConcurrencyAnd50PercentCacheHitsState
        extends AbstractGwcWithoutConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 2);
                WmsMetatileBenchmarkTest.saveToCsv("./target/50-percent-hits.csv", this.tileIndices);
            }
        }

        public static class GwcWithConcurrencyAnd50PercentCacheHitsState
        extends AbstractGwcWithConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 2);
                WmsMetatileBenchmarkTest.saveToCsv("./target/50-percent-hits.csv", this.tileIndices);
            }
        }

        public static class GwcWithoutConcurrencyAndNoCacheHitsState
        extends AbstractGwcWithoutConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 1);
                WmsMetatileBenchmarkTest.saveToCsv("./target/all-misses.csv", this.tileIndices);
            }
        }

        public static class GwcWithConcurrencyAndNoCacheHitsState
        extends AbstractGwcWithConcurrency {
            @Override
            public void setup() throws Exception {
                super.setup();
                this.tileIndices = WmsMetatileBenchmarkTest.getTileIndices(LAYER_NAME, null, 11, 100000, 4, 1);
                WmsMetatileBenchmarkTest.saveToCsv("./target/all-misses.csv", this.tileIndices);
            }
        }

        public static class AbstractGwcWithoutConcurrency
        extends AbstractBenchmarkState {
            @Override
            public void setup() throws Exception {
                super.setup();
                GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
                this.setMetaTilingThreads(0);
            }
        }

        public static class AbstractGwcWithConcurrency
        extends AbstractBenchmarkState {
            @Override
            public void setup() throws Exception {
                super.setup();
                GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
                this.setMetaTilingThreads(2 * Runtime.getRuntime().availableProcessors());
            }
        }

        @State(value=Scope.Benchmark)
        public static class AbstractBenchmarkState {
            long[][] tileIndices;
            AtomicInteger currentIndex = new AtomicInteger(0);
            GeoServerBenchmarkSuppport geoServerSystemTestSupport = new GeoServerBenchmarkSuppport();
            Map<String, Integer> cacheHitRate = new ConcurrentHashMap();

            @Setup
            public void setup() throws Exception {
                this.geoServerSystemTestSupport.doSetup();
            }

            protected void setMetaTilingThreads(int metaTilingThreads) throws IOException {
                GWCConfig config = GWC.get().getConfig();
                config.setMetaTilingThreads(Integer.valueOf(metaTilingThreads));
                GWC.get().saveConfig(config);
            }

            @TearDown
            public void tearDown() throws Exception {
                GeoServerSystemTestSupport.doTearDownClass();
                int cacheHits = this.cacheHitRate.getOrDefault("HIT", 0);
                int cacheMisses = this.cacheHitRate.getOrDefault("MISS", 0);
                int totalRequests = cacheHits + cacheMisses;
                double cacheHitRate = (double)cacheHits / (double)totalRequests;
                AbstractBenchmarkState.extracted("Total requests: " + totalRequests);
                AbstractBenchmarkState.extracted("Cache hits: " + cacheHits);
                AbstractBenchmarkState.extracted("Cache misses: " + cacheMisses);
                AbstractBenchmarkState.extracted("Cache hit rate: " + cacheHitRate);
            }

            private static void extracted(String totalRequests) {
                System.out.println(totalRequests);
            }
        }
    }

    private static class GeoServerBenchmarkSuppport
    extends GeoServerSystemTestSupport {
        private GeoServerBenchmarkSuppport() {
        }

        public MockHttpServletResponse getAsServletResponse(String path) throws Exception {
            return super.getAsServletResponse(path);
        }
    }
}

