/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.awaitility.Awaitility;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.StorageObject;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class GWCSeedingSecurityIntegrationTest
extends GeoServerSystemTestSupport {
    static final String PUB_URI = "https://pub.org";
    static final String PUB_PREFIX = "pub";
    static final String SEC_URI = "https://sec.com";
    static final String SEC_PREFIX = "sec";
    static final QName SEC_BRIDGES = new QName("https://sec.com", "Bridges", "sec");
    static final QName SEC_BUILDINGS = new QName("https://sec.com", "Buildings", "sec");
    static final QName PUB_LAKES = new QName("https://pub.org", "Lakes", "pub");
    static final QName PUB_STREAMS = new QName("https://pub.org", "Streams", "pub");
    private TileBreeder tileBreeder = null;
    private Catalog rawCatalog = null;

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        testData.addWorkspace(PUB_PREFIX, PUB_URI, catalog);
        testData.addWorkspace(SEC_PREFIX, SEC_URI, catalog);
        testData.addVectorLayer(SEC_BRIDGES, Collections.emptyMap(), SystemTestData.class, catalog);
        testData.addVectorLayer(SEC_BUILDINGS, Collections.emptyMap(), SystemTestData.class, catalog);
        testData.addVectorLayer(PUB_STREAMS, Collections.emptyMap(), SystemTestData.class, catalog);
        testData.addVectorLayer(PUB_LAKES, Collections.emptyMap(), SystemTestData.class, catalog);
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
        GWC.get().getConfig().setSecurityEnabled(true);
        this.addLayerAccessRule(PUB_PREFIX, "*", AccessMode.READ, new String[]{"*"});
        this.addLayerAccessRule(SEC_PREFIX, "*", AccessMode.READ, new String[]{"ROLE_ADMINISTRATOR"});
        this.addLayerAccessRule("*", "*", AccessMode.ADMIN, new String[]{"ROLE_ADMINISTRATOR"});
    }

    @Before
    public void setUp() {
        this.tileBreeder = (TileBreeder)applicationContext.getBean(TileBreeder.class);
        this.rawCatalog = (Catalog)GeoServerExtensions.bean((String)"rawCatalog");
    }

    @After
    public void cleanUp() throws GeoWebCacheException, InterruptedException {
        this.logout();
        this.executeSeedRequest(this.createSeedRequest(PUB_STREAMS, GWCTask.TYPE.TRUNCATE));
        this.executeSeedRequest(this.createSeedRequest(PUB_LAKES, GWCTask.TYPE.TRUNCATE));
        this.executeSeedRequest(this.createSeedRequest(SEC_BRIDGES, GWCTask.TYPE.TRUNCATE));
        this.executeSeedRequest(this.createSeedRequest(SEC_BUILDINGS, GWCTask.TYPE.TRUNCATE));
        this.waitForSeedingToFinish();
    }

    @Test
    public void testSeedPublic() throws GeoWebCacheException, InterruptedException, StorageException {
        TileObject tileObject = this.getSampleTile(PUB_LAKES);
        Assert.assertEquals((String)"Cache should be empty at test start", (Object)StorageObject.Status.MISS, (Object)tileObject.getStatus());
        Assert.assertNull((String)"Cache should be empty at test start", (Object)tileObject.getBlob());
        SeedRequest sr = this.createSeedRequest(PUB_LAKES);
        GWCTask[] unUsedTasks = this.executeSeedRequest(sr);
        Assert.assertTrue((String)"Failed to initialize seeding tasks", (boolean)this.tileBreeder.getRunningAndPendingTasks().hasNext());
        this.waitForSeedingToFinish();
        Assert.assertFalse((String)"Failed to complete seeding after 120 seconds", (boolean)this.tileBreeder.getRunningAndPendingTasks().hasNext());
        tileObject = this.getSampleTile(PUB_LAKES);
        Assert.assertNotEquals((String)"Cache should not be empty after seeding", (Object)StorageObject.Status.MISS, (Object)tileObject.getStatus());
        Assert.assertNotNull((String)"Cache should not be empty after seeding", (Object)tileObject.getBlob());
    }

    @Test
    public void testSeedSecuredAsAnonymous() throws StorageException, GeoWebCacheException, InterruptedException {
        TileObject tileObject = this.getSampleTile(SEC_BUILDINGS);
        Assert.assertEquals((String)"Cache should be empty at test start", (Object)StorageObject.Status.MISS, (Object)tileObject.getStatus());
        Assert.assertNull((String)"Cache should be empty at test start", (Object)tileObject.getBlob());
        SeedRequest sr = this.createSeedRequest(SEC_BUILDINGS);
        GWCTask[] unUsedTasks = this.executeSeedRequest(sr);
        Assert.assertTrue((String)"Failed to initialize seeding tasks", (boolean)this.tileBreeder.getRunningAndPendingTasks().hasNext());
        this.waitForSeedingToFinish();
        Assert.assertFalse((String)"Failed to complete seeding after 120 seconds", (boolean)this.tileBreeder.getRunningAndPendingTasks().hasNext());
        tileObject = this.getSampleTile(SEC_BUILDINGS);
        Assert.assertEquals((String)"Cache should be empty after seeding", (Object)StorageObject.Status.MISS, (Object)tileObject.getStatus());
        Assert.assertNull((String)"Cache should be empty after seeding", (Object)tileObject.getBlob());
    }

    @Test
    public void testSeedSecuredAsAuthenticated() throws StorageException, GeoWebCacheException, InterruptedException {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        TileObject tileObject = this.getSampleTile(SEC_BUILDINGS);
        Assert.assertEquals((String)"Cache should be empty at test start", (Object)StorageObject.Status.MISS, (Object)tileObject.getStatus());
        Assert.assertNull((String)"Cache should be empty at test start", (Object)tileObject.getBlob());
        SeedRequest sr = this.createSeedRequest(SEC_BUILDINGS);
        GWCTask[] unUsedTasks = this.executeSeedRequest(sr);
        Assert.assertTrue((String)"Failed to initialize seeding tasks", (boolean)this.tileBreeder.getRunningAndPendingTasks().hasNext());
        this.waitForSeedingToFinish();
        Assert.assertFalse((String)"Failed to complete seeding after 120 seconds", (boolean)this.tileBreeder.getRunningAndPendingTasks().hasNext());
        tileObject = this.getSampleTile(SEC_BUILDINGS);
        Assert.assertNotEquals((String)"Cache should not be empty after seeding", (Object)StorageObject.Status.MISS, (Object)tileObject.getStatus());
        Assert.assertNotNull((String)"Cache should not be empty after seeding", (Object)tileObject.getBlob());
    }

    protected SeedRequest createSeedRequest(QName layerName) {
        return this.createSeedRequest(layerName, GWCTask.TYPE.SEED);
    }

    protected SeedRequest createSeedRequest(QName layerName, GWCTask.TYPE taskType) {
        GWC gwc = GWC.get();
        String prefixedName = layerName.getPrefix() + ":" + layerName.getLocalPart();
        LayerInfo layerInfo = this.rawCatalog.getLayerByName(prefixedName);
        GeoServerTileLayer tileLayer = gwc.getTileLayer((CatalogInfo)layerInfo);
        SeedRequest seedRequest = new SeedRequest(prefixedName, tileLayer.getGridSubset("EPSG:4326").getOriginalExtent(), "EPSG:4326", 1, 0, 2, "image/png", taskType, Collections.emptyMap());
        return seedRequest;
    }

    protected GWCTask[] executeSeedRequest(SeedRequest sr) throws GeoWebCacheException {
        TileLayer tl = this.tileBreeder.findTileLayer(sr.getLayerName());
        TileRange tr = TileBreeder.createTileRange((SeedRequest)sr, (TileLayer)tl);
        GWCTask[] tasks = this.tileBreeder.createTasks(tr, tl, sr.getType(), sr.getThreadCount().intValue(), sr.getFilterUpdate());
        this.tileBreeder.dispatchTasks(tasks);
        return tasks;
    }

    protected TileObject getSampleTile(QName layerName) throws StorageException {
        GWC gwc = GWC.get();
        String prefixedName = layerName.getPrefix() + ":" + layerName.getLocalPart();
        TileObject tileObject = TileObject.createQueryTileObject((String)prefixedName, (long[])new long[]{0L, 0L, 1L}, (String)"EPSG:4326", (String)"image/png", Collections.emptyMap());
        gwc.getCompositeBlobStore().get(tileObject);
        return tileObject;
    }

    protected void waitForSeedingToFinish() {
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(() -> !this.tileBreeder.getRunningAndPendingTasks().hasNext());
    }
}

