/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.util.DimensionWarning;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.mime.FormatModifier;

public class GeoServerTileLayerInfoImpl
implements Serializable,
GeoServerTileLayerInfo {
    private static final long serialVersionUID = 8277055420849712230L;
    private static final Logger LOGGER = Logging.getLogger(GeoServerTileLayerInfoImpl.class);
    private String id;
    private boolean enabled;
    private Boolean inMemoryCached;
    private String name;
    private String blobStoreId;
    private transient LayerMetaInformation metaInformation;
    private Set<String> mimeFormats;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private List<FormatModifier> formatModifiers;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private Set<XMLGridSubset> gridSubsets;
    private transient List<? extends UpdateSourceDefinition> updateSources;
    private transient List<? extends RequestFilter> requestFilters;
    private transient boolean useETags;
    private int[] metaWidthHeight;
    private int expireCache;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private List<ExpirationRule> expireCacheList;
    private int expireClients;
    private transient List<ExpirationRule> expireClientsList;
    private transient Integer backendTimeout;
    private transient Boolean cacheBypassAllowed;
    private transient Boolean queryable;
    private transient Map<String, ParameterFilter> parameterFiltersMap;
    private Set<ParameterFilter> parameterFilters;
    private int gutter;
    private Boolean autoCacheStyles;
    Set<DimensionWarning.WarningType> cacheWarningSkips;

    public GeoServerTileLayerInfoImpl() {
        this.readResolve();
    }

    private final Object readResolve() {
        if (null == this.metaWidthHeight) {
            this.metaWidthHeight = new int[2];
        }
        this.gridSubsets = this.nonNull(this.gridSubsets);
        this.mimeFormats = this.nonNull(this.mimeFormats);
        this.cacheWarningSkips = this.nonNull(this.cacheWarningSkips);
        this.parameterFilters = this.nonNull(this.parameterFilters);
        this.setParameterFilters(this.parameterFilters);
        if (this.autoCacheStyles != null) {
            if (this.autoCacheStyles.booleanValue()) {
                if (!this.isAutoCacheStyles()) {
                    this.addParameterFilter(new StyleParameterFilter());
                }
            } else if (this.isAutoCacheStyles()) {
                this.removeParameterFilter("STYLES");
            }
            this.autoCacheStyles = null;
        }
        return this;
    }

    private final Object writeReplace() {
        this.parameterFilters = this.getParameterFilters();
        return this;
    }

    @Override
    public GeoServerTileLayerInfoImpl clone() {
        GeoServerTileLayerInfoImpl clone;
        try {
            clone = (GeoServerTileLayerInfoImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.metaWidthHeight = (int[])this.metaWidthHeight.clone();
        clone.gridSubsets = this.nonNull((Set)null);
        for (XMLGridSubset gs : this.gridSubsets) {
            clone.gridSubsets.add(gs.clone());
        }
        clone.mimeFormats = this.nonNull((Set)null);
        clone.mimeFormats.addAll(this.mimeFormats);
        clone.parameterFiltersMap = this.nonNull((Map)null);
        for (ParameterFilter pf : this.parameterFiltersMap.values()) {
            clone.addParameterFilter(pf.clone());
        }
        clone.cacheWarningSkips = new LinkedHashSet<DimensionWarning.WarningType>();
        clone.cacheWarningSkips.addAll(this.cacheWarningSkips);
        return clone;
    }

    private <T> Set<T> nonNull(Set<T> set) {
        return set == null ? new HashSet() : set;
    }

    private <K, T> Map<K, T> nonNull(Map<K, T> set) {
        return set == null ? new HashMap() : set;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getBlobStoreId() {
        return this.blobStoreId;
    }

    @Override
    public void setBlobStoreId(@Nullable String blobStoreId) {
        this.blobStoreId = blobStoreId;
    }

    @Override
    public int getMetaTilingX() {
        return this.metaWidthHeight[0];
    }

    @Override
    public int getMetaTilingY() {
        return this.metaWidthHeight[1];
    }

    @Override
    public void setMetaTilingY(int metaTilingY) {
        Preconditions.checkArgument((metaTilingY > 0 ? 1 : 0) != 0);
        this.metaWidthHeight[1] = metaTilingY;
    }

    @Override
    public void setMetaTilingX(int metaTilingX) {
        Preconditions.checkArgument((metaTilingX > 0 ? 1 : 0) != 0);
        this.metaWidthHeight[0] = metaTilingX;
    }

    @Override
    public int getExpireCache() {
        return this.expireCache;
    }

    @Override
    public void setExpireCache(int expireCache) {
        this.expireCache = expireCache;
    }

    @Override
    public List<ExpirationRule> getExpireCacheList() {
        return this.expireCacheList;
    }

    @Override
    public void setExpireCacheList(List<ExpirationRule> expireCacheList) {
        this.expireCacheList = expireCacheList;
    }

    @Override
    public int getExpireClients() {
        return this.expireClients;
    }

    @Override
    public void setExpireClients(int seconds) {
        this.expireClients = seconds;
    }

    @Override
    public ImmutableSet<String> cachedStyles() {
        ParameterFilter styleQualifier = this.getParameterFilter("STYLES");
        try {
            List styles;
            if (styleQualifier != null && (styles = styleQualifier.getLegalValues()) != null) {
                return ImmutableSet.copyOf((Collection)styles);
            }
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.WARNING, "StyleParameterFilter was not initialized properly", ex);
        }
        return ImmutableSet.of();
    }

    @Override
    public Set<String> getMimeFormats() {
        return this.mimeFormats;
    }

    @Override
    public Set<XMLGridSubset> getGridSubsets() {
        return this.gridSubsets;
    }

    @Override
    public void setGridSubsets(Set<XMLGridSubset> gridSubsets) {
        this.gridSubsets = this.nonNull(gridSubsets);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setGutter(int gutter) {
        this.gutter = gutter;
    }

    @Override
    public int getGutter() {
        return this.gutter;
    }

    @Override
    public boolean isAutoCacheStyles() {
        ParameterFilter filter = this.getParameterFilter("STYLES");
        return filter != null && filter instanceof StyleParameterFilter && ((StyleParameterFilter)filter).getStyles() == null;
    }

    @Override
    public void setAutoCacheStyles(boolean autoCacheStyles) {
        if (autoCacheStyles) {
            StyleParameterFilter newFilter = new StyleParameterFilter();
            this.addParameterFilter(newFilter);
        } else {
            ParameterFilter filter = this.getParameterFilter("STYLES");
            if (filter != null && filter instanceof StyleParameterFilter) {
                this.parameterFilters.remove(filter);
            }
        }
    }

    @Override
    public Set<ParameterFilter> getParameterFilters() {
        return new HashSet<ParameterFilter>(this.parameterFiltersMap.values());
    }

    @Override
    public void setParameterFilters(Set<ParameterFilter> parameterFilters) {
        this.parameterFiltersMap = new HashMap<String, ParameterFilter>();
        for (ParameterFilter pf : parameterFilters) {
            this.addParameterFilter(pf);
        }
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public boolean addParameterFilter(ParameterFilter parameterFilter) {
        return this.parameterFiltersMap.put(parameterFilter.getKey().toUpperCase(), parameterFilter) != null;
    }

    @Override
    public boolean removeParameterFilter(String key) {
        return this.parameterFiltersMap.remove(key.toUpperCase()) != null;
    }

    @Override
    public ParameterFilter getParameterFilter(String key) {
        return this.parameterFiltersMap.get(key.toUpperCase());
    }

    @Override
    public boolean isInMemoryCached() {
        return this.inMemoryCached != null ? this.inMemoryCached : true;
    }

    @Override
    public void setInMemoryCached(boolean inMemoryCached) {
        this.inMemoryCached = inMemoryCached;
    }

    @Override
    public Set<DimensionWarning.WarningType> getCacheWarningSkips() {
        return this.cacheWarningSkips;
    }

    @Override
    public void setCacheWarningSkips(Set<DimensionWarning.WarningType> cacheWarningSkips) {
        this.cacheWarningSkips = this.nonNull(cacheWarningSkips);
    }
}

