/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerReinitializer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.ConfigurableBlobStore;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;

public class GWCInitializer
implements GeoServerReinitializer {
    private static final Logger LOGGER = Logging.getLogger(GWCInitializer.class);
    static String WMS_INTEGRATION_ENABLED_KEY = "GWC_WMS_Integration";
    private final GWCConfigPersister configPersister;
    private final Catalog rawCatalog;
    private final TileLayerCatalog tileLayerCatalog;
    private ConfigurableBlobStore blobStore;

    public GWCInitializer(GWCConfigPersister configPersister, Catalog rawCatalog, TileLayerCatalog tileLayerCatalog) {
        this.configPersister = configPersister;
        this.rawCatalog = rawCatalog;
        this.tileLayerCatalog = tileLayerCatalog;
    }

    public void initialize(GeoServer geoServer) throws Exception {
        GWCConfig config;
        Version version;
        LOGGER.config("Initializing GeoServer specific GWC configuration from gwc-gs.xml");
        Version currentVersion = new Version("1.1.0");
        Resource configFile = this.configPersister.findConfigFile();
        if (configFile == null || configFile.getType() != Resource.Type.RESOURCE) {
            LOGGER.fine("GWC's GeoServer specific configuration not found, creating with old defaults");
            GWCConfig oldDefaults = GWCConfig.getOldDefaults();
            oldDefaults.setVersion(currentVersion.toString());
            this.upgradeWMSIntegrationConfig(geoServer, oldDefaults);
            this.createDefaultTileLayerInfos(oldDefaults);
            this.configPersister.save(oldDefaults);
        }
        if ((version = new Version((config = this.configPersister.getConfig()).getVersion())).compareTo(new Version("2.0.0")) < 0 && config.isWMTSEnabled() != null) {
            WMTSInfo globalServiceInfo = (WMTSInfo)geoServer.getFacade().getService(WMTSInfo.class);
            globalServiceInfo.setEnabled(config.isWMTSEnabled());
            geoServer.save((ServiceInfo)globalServiceInfo);
            config.setWMTSEnabled(null);
            this.configPersister.save(config);
        }
        if (currentVersion.compareTo(version) > 0) {
            this.moveTileLayerInfosToTileLayerCatalog();
            config.setVersion(currentVersion.toString());
            this.configPersister.save(config);
        }
        GWCConfig gwcConfig = this.configPersister.getConfig();
        Preconditions.checkNotNull((Object)gwcConfig);
        if (gwcConfig.getCacheProviderClass() == null || gwcConfig.getCacheProviderClass().isEmpty()) {
            gwcConfig.setCacheProviderClass(GuavaCacheProvider.class.toString());
            this.configPersister.save(gwcConfig);
        }
        if (gwcConfig.getCacheConfigurations() == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Setting default CacheConfiguration");
            }
            HashMap<String, CacheConfiguration> map = new HashMap<String, CacheConfiguration>();
            map.put(GuavaCacheProvider.class.toString(), new CacheConfiguration());
            gwcConfig.setCacheConfigurations(map);
            this.configPersister.save(gwcConfig);
        } else if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("CacheConfiguration loaded");
        }
        if (this.blobStore != null) {
            String cacheProviderClass = gwcConfig.getCacheProviderClass();
            if (!this.blobStore.getCacheProviders().containsKey(cacheProviderClass)) {
                gwcConfig.setCacheProviderClass(GuavaCacheProvider.class.toString());
                this.configPersister.save(gwcConfig);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Unable to find: " + cacheProviderClass + ", used default configuration");
                }
            }
            this.blobStore.setChanged(gwcConfig, true);
            CacheProvider cache = this.blobStore.getCache();
            this.addLayersToNotCache(cache, gwcConfig);
        }
    }

    private void moveTileLayerInfosToTileLayerCatalog() {
        MetadataMap metadata;
        GeoServerTileLayerInfoImpl tileLayerInfo;
        for (LayerInfo layer : this.rawCatalog.getLayers()) {
            if (!CatalogConfiguration.isLayerExposable(layer)) continue;
            try {
                tileLayerInfo = LegacyTileLayerInfoLoader.load(layer);
                if (tileLayerInfo == null) continue;
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save(layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error migrating GWC Tile Layer settings for Layer '" + layer.getName() + "'", e);
            }
        }
        for (LayerInfo layer : this.rawCatalog.getLayerGroups()) {
            try {
                tileLayerInfo = LegacyTileLayerInfoLoader.load((LayerGroupInfo)layer);
                if (tileLayerInfo == null) continue;
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save((LayerGroupInfo)layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for LayerGroup '" + GWC.tileLayerName((LayerGroupInfo)layer) + "'", e);
            }
        }
    }

    private void createDefaultTileLayerInfos(GWCConfig defaultSettings) {
        MetadataMap metadata;
        GeoServerTileLayerInfoImpl tileLayerInfo;
        Preconditions.checkArgument((boolean)defaultSettings.isSane());
        for (LayerInfo layer : this.rawCatalog.getLayers()) {
            if (!CatalogConfiguration.isLayerExposable(layer)) continue;
            try {
                tileLayerInfo = TileLayerInfoUtil.loadOrCreate(layer, defaultSettings);
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                if (!metadata.containsKey((Object)"GWC.enabled")) continue;
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save(layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for Layer '" + layer.getName() + "'", e);
            }
        }
        for (LayerInfo layer : this.rawCatalog.getLayerGroups()) {
            try {
                tileLayerInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)layer, defaultSettings);
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                if (!metadata.containsKey((Object)"GWC.enabled")) continue;
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save((LayerGroupInfo)layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for LayerGroup '" + GWC.tileLayerName((LayerGroupInfo)layer) + "'", e);
            }
        }
    }

    private void upgradeWMSIntegrationConfig(GeoServer geoServer, GWCConfig gwcConfig) throws IOException {
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        if (service != null) {
            Boolean storedValue;
            MetadataMap metadata = service.getMetadata();
            if (service != null && metadata != null && (storedValue = (Boolean)metadata.get(WMS_INTEGRATION_ENABLED_KEY, Boolean.class)) != null) {
                boolean enabled = storedValue;
                gwcConfig.setDirectWMSIntegrationEnabled(enabled);
                metadata.remove((Object)WMS_INTEGRATION_ENABLED_KEY);
                geoServer.save((ServiceInfo)service);
            }
        }
    }

    private void addLayersToNotCache(CacheProvider cache, GWCConfig defaultSettings) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Adding Layers to avoid In Memory Caching");
        }
        this.tileLayerCatalog.getLayerIds().parallelStream().forEach(id -> this.addLayerToNotCache(cache, (String)id));
    }

    private void addLayerToNotCache(CacheProvider cache, String layerId) {
        try {
            GeoServerTileLayerInfo tileLayerInfo = this.tileLayerCatalog.getLayerById(layerId);
            if (tileLayerInfo != null && tileLayerInfo.isEnabled() && !tileLayerInfo.isInMemoryCached()) {
                cache.addUncachedLayer(tileLayerInfo.getName());
            }
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Error occurred retrieving Layer '" + layerId + "'", e);
        }
    }

    public void setBlobStore(ConfigurableBlobStore blobStore) {
        this.blobStore = blobStore;
    }
}

